/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.data.input.impl;

import com.google.common.collect.ImmutableList;
import java.util.List;
import org.apache.druid.data.input.impl.DimensionsSpec;
import org.apache.druid.data.input.impl.JavaScriptParseSpec;
import org.apache.druid.data.input.impl.ParseSpec;
import org.apache.druid.data.input.impl.StringInputRowParser;
import org.apache.druid.data.input.impl.TimestampSpec;
import org.apache.druid.js.JavaScriptConfig;
import org.hamcrest.CoreMatchers;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;

public class StringInputRowParserTest {
    @Rule
    public ExpectedException expectedException = ExpectedException.none();

    @Test
    public void testDisableJavaScript() {
        JavaScriptParseSpec parseSpec = new JavaScriptParseSpec(new TimestampSpec("timestamp", "auto", null), new DimensionsSpec(DimensionsSpec.getDefaultSchemas((List)ImmutableList.of((Object)"dim1", (Object)"dim2"))), "func", new JavaScriptConfig(false));
        StringInputRowParser parser = new StringInputRowParser((ParseSpec)parseSpec, "UTF-8");
        this.expectedException.expect(CoreMatchers.instanceOf(IllegalStateException.class));
        this.expectedException.expectMessage("JavaScript is disabled");
        parser.startFileFromBeginning();
    }

    @Test
    public void testDisableJavaScript2() {
        JavaScriptParseSpec parseSpec = new JavaScriptParseSpec(new TimestampSpec("timestamp", "auto", null), new DimensionsSpec(DimensionsSpec.getDefaultSchemas((List)ImmutableList.of((Object)"dim1", (Object)"dim2"))), "func", new JavaScriptConfig(false));
        StringInputRowParser parser = new StringInputRowParser((ParseSpec)parseSpec, "UTF-8");
        this.expectedException.expect(CoreMatchers.instanceOf(IllegalStateException.class));
        this.expectedException.expectMessage("JavaScript is disabled");
        parser.parse("");
    }
}

