/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.data.input.impl;

import com.fasterxml.jackson.databind.InjectableValues;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import java.io.IOException;
import java.net.URI;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import nl.jqno.equalsverifier.EqualsVerifier;
import org.apache.druid.data.input.InputEntity;
import org.apache.druid.data.input.InputSource;
import org.apache.druid.data.input.impl.HttpEntity;
import org.apache.druid.data.input.impl.HttpInputSource;
import org.apache.druid.data.input.impl.HttpInputSourceConfig;
import org.apache.druid.data.input.impl.systemfield.SystemField;
import org.apache.druid.data.input.impl.systemfield.SystemFields;
import org.apache.druid.error.DruidException;
import org.apache.druid.metadata.DefaultPasswordProvider;
import org.apache.druid.metadata.PasswordProvider;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;

public class HttpInputSourceTest {
    @Rule
    public ExpectedException expectedException = ExpectedException.none();

    @Test
    public void testSerde() throws IOException {
        HttpInputSourceConfig httpInputSourceConfig = new HttpInputSourceConfig(null, null);
        ObjectMapper mapper = new ObjectMapper();
        mapper.setInjectableValues((InjectableValues)new InjectableValues.Std().addValue(HttpInputSourceConfig.class, (Object)httpInputSourceConfig));
        HttpInputSource source = new HttpInputSource((List)ImmutableList.of((Object)URI.create("http://test.com/http-test")), "myName", (PasswordProvider)new DefaultPasswordProvider("myPassword"), new SystemFields(EnumSet.of(SystemField.URI)), null, httpInputSourceConfig);
        byte[] json = mapper.writeValueAsBytes((Object)source);
        HttpInputSource fromJson = (HttpInputSource)mapper.readValue(json, InputSource.class);
        Assert.assertEquals((Object)source, (Object)fromJson);
    }

    @Test
    public void testConstructorAllowsOnlyDefaultProtocols() {
        new HttpInputSource((List)ImmutableList.of((Object)URI.create("http:///")), "myName", (PasswordProvider)new DefaultPasswordProvider("myPassword"), null, null, new HttpInputSourceConfig(null, null));
        new HttpInputSource((List)ImmutableList.of((Object)URI.create("https:///")), "myName", (PasswordProvider)new DefaultPasswordProvider("myPassword"), null, null, new HttpInputSourceConfig(null, null));
        this.expectedException.expect(IllegalArgumentException.class);
        this.expectedException.expectMessage("Only [http, https] protocols are allowed");
        new HttpInputSource((List)ImmutableList.of((Object)URI.create("my-protocol:///")), "myName", (PasswordProvider)new DefaultPasswordProvider("myPassword"), null, null, new HttpInputSourceConfig(null, null));
    }

    @Test
    public void testConstructorAllowsOnlyCustomProtocols() {
        HttpInputSourceConfig customConfig = new HttpInputSourceConfig((Set)ImmutableSet.of((Object)"druid"), null);
        new HttpInputSource((List)ImmutableList.of((Object)URI.create("druid:///")), "myName", (PasswordProvider)new DefaultPasswordProvider("myPassword"), null, null, customConfig);
        this.expectedException.expect(IllegalArgumentException.class);
        this.expectedException.expectMessage("Only [druid] protocols are allowed");
        new HttpInputSource((List)ImmutableList.of((Object)URI.create("https:///")), "myName", (PasswordProvider)new DefaultPasswordProvider("myPassword"), null, null, customConfig);
    }

    @Test
    public void testSystemFields() {
        HttpInputSourceConfig httpInputSourceConfig = new HttpInputSourceConfig(null, null);
        HttpInputSource inputSource = new HttpInputSource((List)ImmutableList.of((Object)URI.create("http://test.com/http-test")), "myName", (PasswordProvider)new DefaultPasswordProvider("myPassword"), new SystemFields(EnumSet.of(SystemField.URI, SystemField.PATH)), null, httpInputSourceConfig);
        Assert.assertEquals(EnumSet.of(SystemField.URI, SystemField.PATH), (Object)inputSource.getConfiguredSystemFields());
        HttpEntity entity = new HttpEntity(URI.create("https://example.com/foo"), null, null, null);
        Assert.assertEquals((Object)"https://example.com/foo", (Object)inputSource.getSystemFieldValue((InputEntity)entity, SystemField.URI));
        Assert.assertEquals((Object)"/foo", (Object)inputSource.getSystemFieldValue((InputEntity)entity, SystemField.PATH));
        Assert.assertEquals((Object)inputSource.getRequestHeaders(), Collections.emptyMap());
    }

    @Test
    public void testEmptyAllowedHeaders() {
        HttpInputSourceConfig httpInputSourceConfig = new HttpInputSourceConfig(null, new HashSet());
        this.expectedException.expect(DruidException.class);
        this.expectedException.expectMessage("Got forbidden header [r-Cookie], allowed headers are only [[]]. You can control the allowed headers by updating druid.ingestion.http.allowedHeaders");
        HttpInputSource inputSource = new HttpInputSource((List)ImmutableList.of((Object)URI.create("http://test.com/http-test")), "myName", (PasswordProvider)new DefaultPasswordProvider("myPassword"), new SystemFields(EnumSet.of(SystemField.URI, SystemField.PATH)), (Map)ImmutableMap.of((Object)"r-Cookie", (Object)"test", (Object)"Content-Type", (Object)"application/json"), httpInputSourceConfig);
    }

    @Test
    public void shouldFailOnForbiddenHeaders() {
        HttpInputSourceConfig httpInputSourceConfig = new HttpInputSourceConfig(null, (Set)Sets.newHashSet((Object[])new String[]{"R-cookie", "Content-type"}));
        this.expectedException.expect(DruidException.class);
        this.expectedException.expectMessage("Got forbidden header [G-Cookie], allowed headers are only [[r-cookie, content-type]]");
        new HttpInputSource((List)ImmutableList.of((Object)URI.create("http://test.com/http-test")), "myName", (PasswordProvider)new DefaultPasswordProvider("myPassword"), new SystemFields(EnumSet.of(SystemField.URI, SystemField.PATH)), (Map)ImmutableMap.of((Object)"G-Cookie", (Object)"test", (Object)"Content-Type", (Object)"application/json"), httpInputSourceConfig);
    }

    @Test
    public void testEquals() {
        EqualsVerifier.forClass(HttpInputSource.class).usingGetClass().verify();
    }
}

