/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.data.input;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import org.apache.druid.data.input.StringTuple;
import org.junit.Assert;
import org.junit.Test;

public class StringTupleTest {
    @Test
    public void testSize() {
        StringTuple tuple = StringTuple.create((String[])new String[]{"a", "b", "c"});
        Assert.assertEquals((long)3L, (long)tuple.size());
    }

    @Test
    public void testGet() {
        StringTuple tuple = StringTuple.create((String[])new String[]{"a", "b", "c"});
        Assert.assertEquals((Object)"a", (Object)tuple.get(0));
        Assert.assertEquals((Object)"b", (Object)tuple.get(1));
        Assert.assertEquals((Object)"c", (Object)tuple.get(2));
    }

    @Test
    public void testToArray() {
        StringTuple tuple = StringTuple.create((String[])new String[]{"a", "b", "c"});
        Assert.assertEquals((Object[])new String[]{"a", "b", "c"}, (Object[])tuple.toArray());
    }

    @Test
    public void testWithNullValues() {
        StringTuple tuple = StringTuple.create((String[])new String[]{"a", null, "b"});
        Assert.assertEquals((Object)"a", (Object)tuple.get(0));
        Assert.assertNull((Object)tuple.get(1));
        Assert.assertEquals((Object)"b", (Object)tuple.get(2));
        tuple = StringTuple.create((String[])new String[]{null, null});
        Assert.assertNull((Object)tuple.get(0));
        Assert.assertNull((Object)tuple.get(1));
        tuple = StringTuple.create((String[])new String[]{null});
        Assert.assertNull((Object)tuple.get(0));
    }

    @Test
    public void testSerde() throws IOException {
        StringTuple original = StringTuple.create((String[])new String[]{"a", "b", "c"});
        ObjectMapper mapper = new ObjectMapper();
        String json = mapper.writeValueAsString((Object)original);
        StringTuple deserialized = (StringTuple)mapper.readValue(json, StringTuple.class);
        Assert.assertEquals((Object)original, (Object)deserialized);
    }

    @Test
    public void testCompareTo() {
        StringTuple lhs = StringTuple.create((String[])new String[]{"c", "10"});
        Assert.assertEquals((long)0L, (long)lhs.compareTo(StringTuple.create((String[])new String[]{"c", "10"})));
        Assert.assertTrue((lhs.compareTo(null) > 0 ? 1 : 0) != 0);
        Assert.assertTrue((lhs.compareTo(StringTuple.create((String[])new String[]{null, null})) > 0 ? 1 : 0) != 0);
        Assert.assertTrue((lhs.compareTo(StringTuple.create((String[])new String[]{"c", "09"})) > 0 ? 1 : 0) != 0);
        Assert.assertTrue((lhs.compareTo(StringTuple.create((String[])new String[]{"b", "01"})) > 0 ? 1 : 0) != 0);
        Assert.assertTrue((lhs.compareTo(StringTuple.create((String[])new String[]{"c", "11"})) < 0 ? 1 : 0) != 0);
        Assert.assertTrue((lhs.compareTo(StringTuple.create((String[])new String[]{"d", "01"})) < 0 ? 1 : 0) != 0);
    }

    @Test
    public void testEquals() {
        Assert.assertEquals((Object)StringTuple.create((String[])new String[]{null}), (Object)StringTuple.create((String[])new String[]{null}));
        Assert.assertEquals((Object)StringTuple.create((String[])new String[]{"a"}), (Object)StringTuple.create((String[])new String[]{"a"}));
        Assert.assertEquals((Object)StringTuple.create((String[])new String[]{null, null, null}), (Object)StringTuple.create((String[])new String[]{null, null, null}));
        Assert.assertEquals((Object)StringTuple.create((String[])new String[]{"a", "10", "z"}), (Object)StringTuple.create((String[])new String[]{"a", "10", "z"}));
        Assert.assertEquals((Object)new StringTuple(new String[]{"a", "10", "z"}), (Object)StringTuple.create((String[])new String[]{"a", "10", "z"}));
        Assert.assertNotEquals((Object)StringTuple.create((String[])new String[]{null, null, null}), (Object)StringTuple.create((String[])new String[]{null, null}));
        Assert.assertNotEquals((Object)StringTuple.create((String[])new String[]{"a"}), (Object)StringTuple.create((String[])new String[]{null}));
        Assert.assertNotEquals((Object)StringTuple.create((String[])new String[]{"a", "b"}), (Object)StringTuple.create((String[])new String[]{"a", "c"}));
        Assert.assertNotEquals((Object)StringTuple.create((String[])new String[]{"a", "b"}), (Object)StringTuple.create((String[])new String[]{"c", "b"}));
    }
}

