/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.data.input;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.function.Function;
import java.util.stream.IntStream;
import nl.jqno.equalsverifier.EqualsVerifier;
import org.apache.druid.data.input.InputFileAttribute;
import org.apache.druid.data.input.MaxSizeSplitHintSpec;
import org.apache.druid.data.input.SplitHintSpec;
import org.apache.druid.java.util.common.HumanReadableBytes;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;

public class MaxSizeSplitHintSpecTest {
    @Rule
    public ExpectedException expectedException = ExpectedException.none();

    @Test
    public void testSerde() throws IOException {
        ObjectMapper mapper = new ObjectMapper();
        MaxSizeSplitHintSpec original = new MaxSizeSplitHintSpec(new HumanReadableBytes(1024L), Integer.valueOf(20000));
        byte[] bytes = mapper.writeValueAsBytes((Object)original);
        MaxSizeSplitHintSpec fromJson = (MaxSizeSplitHintSpec)mapper.readValue(bytes, SplitHintSpec.class);
        Assert.assertEquals((Object)original, (Object)fromJson);
    }

    @Test
    public void testReadFromJson() throws JsonProcessingException {
        ObjectMapper mapper = new ObjectMapper();
        String json = "{  \"type\":\"maxSize\",  \"maxSplitSize\":1024,  \"maxNumFiles\":20000}\n";
        MaxSizeSplitHintSpec fromJson = (MaxSizeSplitHintSpec)mapper.readValue("{  \"type\":\"maxSize\",  \"maxSplitSize\":1024,  \"maxNumFiles\":20000}\n", SplitHintSpec.class);
        Assert.assertEquals((Object)new MaxSizeSplitHintSpec(new HumanReadableBytes(1024L), Integer.valueOf(20000)), (Object)fromJson);
    }

    @Test
    public void testConstructorWith0MaxNumFiles() {
        this.expectedException.expect(IllegalArgumentException.class);
        this.expectedException.expectMessage("maxNumFiles should be larger than 0");
        new MaxSizeSplitHintSpec(null, Integer.valueOf(0));
    }

    @Test
    public void testConstructorWith0MaxSplitSize() {
        this.expectedException.expect(IllegalArgumentException.class);
        this.expectedException.expectMessage("maxSplitSize should be larger than 0");
        new MaxSizeSplitHintSpec(0L, null);
    }

    @Test
    public void testDefaults() {
        Assert.assertEquals((Object)MaxSizeSplitHintSpec.DEFAULT_MAX_SPLIT_SIZE, (Object)new MaxSizeSplitHintSpec(null, null).getMaxSplitSize());
        Assert.assertEquals((long)1000L, (long)new MaxSizeSplitHintSpec(null, null).getMaxNumFiles());
    }

    @Test
    public void testSplitSmallInputsGroupingIntoLargerSplits() {
        int eachInputSize = 3;
        MaxSizeSplitHintSpec splitHintSpec = new MaxSizeSplitHintSpec(new HumanReadableBytes(10L), Integer.valueOf(10000));
        Function<Integer, InputFileAttribute> inputAttributeExtractor = InputFileAttribute::new;
        ArrayList splits = Lists.newArrayList((Iterator)splitHintSpec.split((Iterator)IntStream.generate(() -> 3).limit(10L).iterator(), inputAttributeExtractor));
        Assert.assertEquals((long)4L, (long)splits.size());
        Assert.assertEquals((long)3L, (long)((List)splits.get(0)).size());
        Assert.assertEquals((long)3L, (long)((List)splits.get(1)).size());
        Assert.assertEquals((long)3L, (long)((List)splits.get(2)).size());
        Assert.assertEquals((long)1L, (long)((List)splits.get(3)).size());
    }

    @Test
    public void testSplitLargeInputsReturningSplitsOfSingleInput() {
        int eachInputSize = 15;
        MaxSizeSplitHintSpec splitHintSpec = new MaxSizeSplitHintSpec(new HumanReadableBytes(10L), Integer.valueOf(10000));
        Function<Integer, InputFileAttribute> inputAttributeExtractor = InputFileAttribute::new;
        ArrayList splits = Lists.newArrayList((Iterator)splitHintSpec.split((Iterator)IntStream.generate(() -> 15).limit(10L).iterator(), inputAttributeExtractor));
        Assert.assertEquals((long)10L, (long)splits.size());
        for (List split : splits) {
            Assert.assertEquals((long)1L, (long)split.size());
        }
    }

    @Test
    public void testSplitSmallInputsWithMaxNumFilesEachSplitShouldHaveLessFilesAssigned() {
        int eachInputSize = 3;
        MaxSizeSplitHintSpec splitHintSpec = new MaxSizeSplitHintSpec(new HumanReadableBytes("500M"), Integer.valueOf(3));
        Function<Integer, InputFileAttribute> inputAttributeExtractor = InputFileAttribute::new;
        ArrayList splits = Lists.newArrayList((Iterator)splitHintSpec.split((Iterator)IntStream.generate(() -> 3).limit(10L).iterator(), inputAttributeExtractor));
        Assert.assertEquals((long)4L, (long)splits.size());
        Assert.assertEquals((long)3L, (long)((List)splits.get(0)).size());
        Assert.assertEquals((long)3L, (long)((List)splits.get(1)).size());
        Assert.assertEquals((long)3L, (long)((List)splits.get(2)).size());
        Assert.assertEquals((long)1L, (long)((List)splits.get(3)).size());
    }

    @Test
    public void testEquals() {
        EqualsVerifier.forClass(MaxSizeSplitHintSpec.class).withNonnullFields(new String[]{"maxSplitSize"}).withNonnullFields(new String[]{"maxNumFiles"}).usingGetClass().verify();
    }
}

