/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.common.guava;

import com.google.common.primitives.Longs;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.common.util.concurrent.MoreExecutors;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Function;
import org.apache.druid.common.guava.GuavaUtils;
import org.apache.druid.java.util.common.concurrent.Execs;
import org.junit.Assert;
import org.junit.Test;

public class GuavaUtilsTest {
    @Test
    public void testParseLong() {
        Assert.assertNull((Object)Longs.tryParse((String)"+100"));
        Assert.assertNull((Object)GuavaUtils.tryParseLong((String)""));
        Assert.assertNull((Object)GuavaUtils.tryParseLong(null));
        Assert.assertNull((Object)GuavaUtils.tryParseLong((String)"+"));
        Assert.assertNull((Object)GuavaUtils.tryParseLong((String)"++100"));
        Assert.assertEquals((Object)Long.parseLong("+100"), (Object)GuavaUtils.tryParseLong((String)"+100"));
        Assert.assertEquals((Object)Long.parseLong("-100"), (Object)GuavaUtils.tryParseLong((String)"-100"));
        Assert.assertNotEquals((Object)new Long(100L), (Object)GuavaUtils.tryParseLong((String)"+101"));
    }

    @Test
    public void testGetEnumIfPresent() {
        Assert.assertEquals((Object)((Object)MyEnum.ONE), (Object)GuavaUtils.getEnumIfPresent(MyEnum.class, (String)"ONE"));
        Assert.assertEquals((Object)((Object)MyEnum.TWO), (Object)GuavaUtils.getEnumIfPresent(MyEnum.class, (String)"TWO"));
        Assert.assertEquals((Object)((Object)MyEnum.BUCKLE_MY_SHOE), (Object)GuavaUtils.getEnumIfPresent(MyEnum.class, (String)"BUCKLE_MY_SHOE"));
        Assert.assertEquals(null, (Object)GuavaUtils.getEnumIfPresent(MyEnum.class, (String)"buckle_my_shoe"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCancelAll() {
        int tasks = 3;
        ExecutorService service = Execs.multiThreaded((int)tasks, (String)"GuavaUtilsTest-%d");
        ListeningExecutorService exc = MoreExecutors.listeningDecorator((ExecutorService)service);
        try {
            final AtomicBoolean someoneFailed = new AtomicBoolean(false);
            ArrayList latches = new ArrayList(tasks);
            Function<Integer, List> function = taskCount -> {
                ArrayList<ListenableFuture> futures = new ArrayList<ListenableFuture>();
                for (int i = 0; i < taskCount; ++i) {
                    final CountDownLatch latch = new CountDownLatch(1);
                    latches.add(latch);
                    ListenableFuture future = exc.submit((Callable)new Callable<Object>(){

                        @Override
                        public Object call() throws RuntimeException, InterruptedException {
                            latch.await(60L, TimeUnit.SECONDS);
                            if (someoneFailed.compareAndSet(false, true)) {
                                throw new RuntimeException("This exception simulates an error");
                            }
                            return null;
                        }
                    });
                    futures.add(future);
                }
                return futures;
            };
            List futures = function.apply(tasks);
            Assert.assertEquals((long)tasks, (long)futures.stream().filter(f -> !f.isDone()).count());
            ((CountDownLatch)latches.get(tasks - 1)).countDown();
            ListenableFuture future = Futures.allAsList((Iterable)futures);
            ExecutionException thrown = (ExecutionException)Assert.assertThrows(ExecutionException.class, () -> future.get());
            Assert.assertEquals((Object)"This exception simulates an error", (Object)thrown.getCause().getMessage());
            GuavaUtils.cancelAll((boolean)true, (Future)future, (List)futures);
            Assert.assertEquals((long)0L, (long)futures.stream().filter(f -> !f.isDone()).count());
            for (CountDownLatch latch : latches) {
                latch.countDown();
            }
        }
        finally {
            exc.shutdownNow();
            service.shutdownNow();
        }
    }

    static enum MyEnum {
        ONE,
        TWO,
        BUCKLE_MY_SHOE;

    }
}

