/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.common.guava;

import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.SettableFuture;
import java.util.concurrent.ExecutionException;
import org.apache.druid.common.guava.FutureBox;
import org.junit.Test;
import org.junit.jupiter.api.Assertions;

public class FutureBoxTest {
    @Test
    public void test_immediateFutures() throws Exception {
        try (FutureBox box = new FutureBox();){
            Assertions.assertEquals((Object)"a", (Object)box.register(Futures.immediateFuture((Object)"a")).get());
            Assertions.assertThrows(ExecutionException.class, () -> box.register(Futures.immediateFailedFuture((Throwable)new RuntimeException())).get());
            Assertions.assertTrue((boolean)box.register(Futures.immediateCancelledFuture()).isCancelled());
            Assertions.assertEquals((int)0, (int)box.pendingCount());
        }
    }

    @Test
    public void test_register_thenStop() {
        FutureBox box = new FutureBox();
        SettableFuture settableFuture = SettableFuture.create();
        ListenableFuture retVal = box.register((ListenableFuture)settableFuture);
        Assertions.assertSame((Object)retVal, (Object)settableFuture);
        Assertions.assertEquals((int)1, (int)box.pendingCount());
        box.close();
        Assertions.assertEquals((int)0, (int)box.pendingCount());
        Assertions.assertTrue((boolean)settableFuture.isCancelled());
    }

    @Test
    public void test_stop_thenRegister() {
        FutureBox box = new FutureBox();
        SettableFuture settableFuture = SettableFuture.create();
        box.close();
        ListenableFuture retVal = box.register((ListenableFuture)settableFuture);
        Assertions.assertSame((Object)retVal, (Object)settableFuture);
        Assertions.assertEquals((int)0, (int)box.pendingCount());
        Assertions.assertTrue((boolean)settableFuture.isCancelled());
    }
}

