/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.common.config;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Suppliers;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.druid.common.config.ConfigManager;
import org.apache.druid.common.config.ConfigSerde;
import org.apache.druid.common.config.JacksonConfigManager;
import org.apache.druid.common.config.TestConfigManagerConfig;
import org.apache.druid.metadata.MetadataCASUpdate;
import org.apache.druid.metadata.MetadataStorageConnector;
import org.apache.druid.metadata.MetadataStorageTablesConfig;
import org.apache.druid.metadata.TestMetadataStorageConnector;
import org.apache.druid.metadata.TestMetadataStorageTablesConfig;
import org.junit.Assert;
import org.junit.Test;

public class ConfigManagerTest {
    private static final String CONFIG_KEY = "configX";
    private static final String TABLE_NAME = "config_table";
    private static final byte[] OLD_CONFIG = new byte[]{1, 2, 3};
    private static final TestConfig NEW_CONFIG = new TestConfig("2", "y", 2);
    private MetadataStorageConnector dbConnector;
    private MetadataStorageTablesConfig metadataStorageTablesConfig;
    private TestConfigManagerConfig configManagerConfig;
    private ConfigSerde<TestConfig> configConfigSerdeFromClass;
    private ConfigManager configManager;
    private JacksonConfigManager jacksonConfigManager;

    public void setup() {
        this.setup(new TestMetadataStorageConnector());
    }

    public void setup(TestMetadataStorageConnector dbConnector) {
        this.dbConnector = dbConnector;
        this.metadataStorageTablesConfig = new TestMetadataStorageTablesConfig(){

            public String getConfigTable() {
                return ConfigManagerTest.TABLE_NAME;
            }
        };
        this.configManagerConfig = new TestConfigManagerConfig();
        this.configManager = new ConfigManager(this.dbConnector, Suppliers.ofInstance((Object)this.metadataStorageTablesConfig), Suppliers.ofInstance((Object)((Object)this.configManagerConfig)));
        this.jacksonConfigManager = new JacksonConfigManager(this.configManager, new ObjectMapper(), null);
        this.configConfigSerdeFromClass = this.jacksonConfigManager.create(TestConfig.class, null);
    }

    @Test
    public void testSetNewObjectIsNull() {
        this.setup();
        ConfigManager.SetResult setResult = this.configManager.set(CONFIG_KEY, this.configConfigSerdeFromClass, null);
        Assert.assertFalse((boolean)setResult.isOk());
        Assert.assertFalse((boolean)setResult.isRetryable());
        Assert.assertTrue((boolean)(setResult.getException() instanceof IllegalAccessException));
    }

    @Test
    public void testSetConfigManagerNotStarted() {
        this.setup();
        ConfigManager.SetResult setResult = this.configManager.set(CONFIG_KEY, this.configConfigSerdeFromClass, (Object)NEW_CONFIG);
        Assert.assertFalse((boolean)setResult.isOk());
        Assert.assertFalse((boolean)setResult.isRetryable());
        Assert.assertTrue((boolean)(setResult.getException() instanceof IllegalStateException));
    }

    @Test
    public void testSetOldObjectNullShouldInsertWithoutSwap() {
        final AtomicBoolean called = new AtomicBoolean();
        this.setup(new TestMetadataStorageConnector(){

            @Override
            public Void insertOrUpdate(String tableName, String keyColumn, String valueColumn, String key, byte[] value) {
                Assert.assertFalse((boolean)called.getAndSet(true));
                Assert.assertEquals((Object)ConfigManagerTest.TABLE_NAME, (Object)tableName);
                Assert.assertEquals((Object)ConfigManagerTest.CONFIG_KEY, (Object)key);
                return null;
            }
        });
        try {
            this.configManager.start();
            ConfigManager.SetResult setResult = this.configManager.set(CONFIG_KEY, this.configConfigSerdeFromClass, null, (Object)NEW_CONFIG);
            Assert.assertTrue((boolean)setResult.isOk());
            Assert.assertTrue((boolean)called.get());
        }
        finally {
            this.configManager.stop();
        }
    }

    @Test
    public void testSetOldObjectNotNullShouldSwap() {
        final AtomicBoolean called = new AtomicBoolean();
        this.setup(new TestMetadataStorageConnector(){

            public boolean compareAndSwap(List<MetadataCASUpdate> updates) {
                Assert.assertFalse((boolean)called.getAndSet(true));
                Assert.assertEquals((long)1L, (long)updates.size());
                MetadataCASUpdate singularUpdate = updates.get(0);
                Assert.assertEquals((Object)ConfigManagerTest.TABLE_NAME, (Object)singularUpdate.getTableName());
                Assert.assertEquals((Object)"name", (Object)singularUpdate.getKeyColumn());
                Assert.assertEquals((Object)"payload", (Object)singularUpdate.getValueColumn());
                Assert.assertEquals((Object)ConfigManagerTest.CONFIG_KEY, (Object)singularUpdate.getKey());
                Assert.assertArrayEquals((byte[])OLD_CONFIG, (byte[])singularUpdate.getOldValue());
                Assert.assertArrayEquals((byte[])ConfigManagerTest.this.configConfigSerdeFromClass.serialize((Object)NEW_CONFIG), (byte[])singularUpdate.getNewValue());
                return true;
            }
        });
        try {
            this.configManager.start();
            ConfigManager.SetResult setResult = this.configManager.set(CONFIG_KEY, this.configConfigSerdeFromClass, OLD_CONFIG, (Object)NEW_CONFIG);
            Assert.assertTrue((boolean)setResult.isOk());
            Assert.assertTrue((boolean)called.get());
        }
        finally {
            this.configManager.stop();
        }
    }

    @Test
    public void testSetOldObjectNotNullButCompareAndSwapDisabledShouldInsertWithoutSwap() {
        final AtomicBoolean called = new AtomicBoolean();
        this.setup(new TestMetadataStorageConnector(){

            @Override
            public Void insertOrUpdate(String tableName, String keyColumn, String valueColumn, String key, byte[] value) {
                Assert.assertFalse((boolean)called.getAndSet(true));
                Assert.assertEquals((Object)ConfigManagerTest.TABLE_NAME, (Object)tableName);
                Assert.assertEquals((Object)ConfigManagerTest.CONFIG_KEY, (Object)key);
                return null;
            }
        });
        this.configManagerConfig.enableCompareAndSwap = false;
        try {
            this.configManager.start();
            ConfigManager.SetResult setResult = this.configManager.set(CONFIG_KEY, this.configConfigSerdeFromClass, OLD_CONFIG, (Object)NEW_CONFIG);
            Assert.assertTrue((boolean)setResult.isOk());
            Assert.assertTrue((boolean)called.get());
        }
        finally {
            this.configManager.stop();
        }
    }

    static class TestConfig {
        private final String version;
        private final String settingString;
        private final int settingInt;

        @JsonCreator
        public TestConfig(@JsonProperty(value="version") String version, @JsonProperty(value="settingString") String settingString, @JsonProperty(value="settingInt") int settingInt) {
            this.version = version;
            this.settingString = settingString;
            this.settingInt = settingInt;
        }

        public String getVersion() {
            return this.version;
        }

        public String getSettingString() {
            return this.settingString;
        }

        public int getSettingInt() {
            return this.settingInt;
        }
    }
}

