/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.collections.spatial.search;

import com.fasterxml.jackson.core.JsonProcessingException;
import java.util.Arrays;
import org.apache.druid.collections.spatial.RTreeUtils;
import org.apache.druid.collections.spatial.SpatialUtils;
import org.apache.druid.collections.spatial.search.Bound;
import org.apache.druid.collections.spatial.search.RadiusBound;
import org.apache.druid.jackson.DefaultObjectMapper;
import org.junit.Assert;
import org.junit.Test;

public class RadiusBoundTest {
    @Test
    public void testCacheKey() {
        float[] coords0 = new float[]{1.0f, 2.0f};
        float[] coords1 = new float[]{1.1f, 2.1f};
        Assert.assertArrayEquals((byte[])new RadiusBound(coords0, 3.0f, 10).getCacheKey(), (byte[])new RadiusBound(coords0, 3.0f, 10).getCacheKey());
        Assert.assertFalse((boolean)Arrays.equals(new RadiusBound(coords0, 3.0f, 10).getCacheKey(), new RadiusBound(coords1, 3.0f, 10).getCacheKey()));
        Assert.assertFalse((boolean)Arrays.equals(new RadiusBound(coords0, 3.0f, 10).getCacheKey(), new RadiusBound(coords0, 3.1f, 10).getCacheKey()));
        Assert.assertFalse((boolean)Arrays.equals(new RadiusBound(coords0, 3.0f, 10).getCacheKey(), new RadiusBound(coords0, 3.0f, 9).getCacheKey()));
    }

    @Test
    public void testContains() {
        float[][] geoOutsidePoints;
        float[][] geoInsidePoints;
        float circleCenterLat = 12.345679f;
        float circleCenterLon = 45.6789f;
        float circleRadius = 500.0f;
        int numberOfPoints = 1000;
        float[] center = new float[]{circleCenterLat, circleCenterLon};
        RadiusBound bound = new RadiusBound(center, circleRadius, 100, RadiusBound.RadiusUnit.meters);
        for (float[] geoPoint : geoInsidePoints = SpatialUtils.generateGeoCoordinatesAroundCircle(circleCenterLat, circleCenterLon, circleRadius, numberOfPoints, true)) {
            double distance = RTreeUtils.calculateHaversineDistance((double)geoPoint[0], (double)geoPoint[1], (double)center[0], (double)center[1]);
            Assert.assertTrue((distance < (double)circleRadius ? 1 : 0) != 0);
            Assert.assertTrue((boolean)bound.contains((Object)geoPoint));
            float[] floatPoint = new float[]{Float.parseFloat(String.valueOf(geoPoint[0])), Float.parseFloat(String.valueOf(geoPoint[1]))};
            Assert.assertTrue((boolean)bound.contains((Object)floatPoint));
        }
        for (float[] geoPoint : geoOutsidePoints = SpatialUtils.generateGeoCoordinatesAroundCircle(circleCenterLat, circleCenterLon, circleRadius, numberOfPoints, false)) {
            double haversineDistance = RTreeUtils.calculateHaversineDistance((double)geoPoint[0], (double)geoPoint[1], (double)center[0], (double)center[1]);
            Assert.assertTrue((haversineDistance > (double)circleRadius ? 1 : 0) != 0);
            Assert.assertFalse((boolean)bound.contains((Object)geoPoint));
            float[] floatPoint = new float[]{Float.parseFloat(String.valueOf(geoPoint[0])), Float.parseFloat(String.valueOf(geoPoint[1]))};
            Assert.assertFalse((boolean)bound.contains((Object)floatPoint));
        }
    }

    @Test
    public void deSerTest() throws JsonProcessingException {
        float circleCenterLat = 12.345679f;
        float circleCenterLon = 45.6789f;
        float circleRadius = 500.0f;
        float[] center = new float[]{circleCenterLat, circleCenterLon};
        RadiusBound bound = new RadiusBound(center, circleRadius, 100);
        DefaultObjectMapper objectMapper = DefaultObjectMapper.INSTANCE;
        Bound val = (Bound)objectMapper.readValue(objectMapper.writeValueAsString((Object)bound), Bound.class);
        Assert.assertEquals((Object)bound, (Object)val);
        RadiusBound bound1 = new RadiusBound(center, circleRadius, 100, RadiusBound.RadiusUnit.meters);
        Bound val1 = (Bound)objectMapper.readValue(objectMapper.writeValueAsString((Object)bound1), Bound.class);
        Assert.assertEquals((Object)bound1, (Object)val1);
    }
}

