/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.collections.spatial;

import java.util.Random;
import java.util.concurrent.ThreadLocalRandom;

public class SpatialUtils {
    private static Random random = ThreadLocalRandom.current();

    public static float[][] generateGeoCoordinatesAroundCircle(float circleCenterLat, float circleCenterLon, float circleRadius, int numberOfPoints, boolean shouldBeInside) {
        float[][] geoCoordinates = new float[numberOfPoints][2];
        for (int i = 0; i < numberOfPoints; ++i) {
            double angle = Math.PI * 2 * random.nextDouble();
            double distance = shouldBeInside ? (double)circleRadius * Math.sqrt(random.nextDouble()) - 1.0 : (double)circleRadius + 100.0 * random.nextDouble();
            double latitude = (double)circleCenterLat + distance * Math.cos(angle) / 111000.0;
            double longitude = (double)circleCenterLon + distance * Math.sin(angle) / (111000.0 * Math.cos(Math.toRadians(latitude)));
            geoCoordinates[i][0] = (float)latitude;
            geoCoordinates[i][1] = (float)longitude;
        }
        return geoCoordinates;
    }
}

