/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.collections.bitmap;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import org.apache.druid.collections.bitmap.ImmutableBitmap;
import org.apache.druid.collections.bitmap.RoaringBitmapFactory;
import org.apache.druid.collections.bitmap.WrappedRoaringBitmap;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.roaringbitmap.IntIterator;

@RunWith(value=Parameterized.class)
public class WrappedRoaringBitmapTest {
    private static final int[] DATA = new int[]{1, 3, 5, 7, 9, 10, 11, 100, 122};
    private final int cardinality;
    private WrappedRoaringBitmap bitmap;

    public WrappedRoaringBitmapTest(int cardinality) {
        this.cardinality = cardinality;
    }

    @Parameterized.Parameters
    public static List<Object[]> constructorFeeder() {
        ArrayList<Object[]> constructors = new ArrayList<Object[]>();
        for (int i = 0; i < DATA.length; ++i) {
            constructors.add(new Object[]{i});
        }
        return constructors;
    }

    @Before
    public void setUp() {
        this.bitmap = (WrappedRoaringBitmap)RoaringBitmapFactory.INSTANCE.makeEmptyMutableBitmap();
        for (int i = 0; i < this.cardinality; ++i) {
            this.bitmap.add(DATA[i]);
        }
    }

    @Test
    public void testGet() {
        for (int i = 0; i < DATA.length; ++i) {
            Assert.assertEquals((String)String.valueOf(i), (Object)(i < this.cardinality ? 1 : 0), (Object)this.bitmap.get(DATA[i]));
        }
        Assert.assertFalse((boolean)this.bitmap.get(-1));
        Assert.assertFalse((boolean)this.bitmap.get(Integer.MAX_VALUE));
    }

    @Test
    public void testSize() {
        Assert.assertEquals((long)this.cardinality, (long)this.bitmap.size());
    }

    @Test
    public void testRemove() {
        this.bitmap.remove(Integer.MAX_VALUE);
        Assert.assertEquals((long)this.cardinality, (long)this.bitmap.size());
        if (this.cardinality > 0) {
            this.bitmap.remove(DATA[0]);
            Assert.assertEquals((long)(this.cardinality - 1), (long)this.bitmap.size());
        }
    }

    @Test
    public void testClear() {
        this.bitmap.clear();
        Assert.assertEquals((long)0L, (long)this.bitmap.size());
    }

    @Test
    public void testIterator() {
        IntIterator iterator = this.bitmap.iterator();
        int i = 0;
        while (iterator.hasNext()) {
            int n = iterator.next();
            Assert.assertEquals((String)String.valueOf(i), (long)DATA[i], (long)n);
            ++i;
        }
        Assert.assertEquals((String)"number of elements", (long)i, (long)this.cardinality);
    }

    @Test
    public void testSerialize() {
        byte[] buffer = new byte[this.bitmap.getSizeInBytes()];
        ByteBuffer byteBuffer = ByteBuffer.wrap(buffer);
        this.bitmap.serialize(byteBuffer);
        byteBuffer.flip();
        ImmutableBitmap immutableBitmap = new RoaringBitmapFactory().mapImmutableBitmap(byteBuffer);
        Assert.assertEquals((long)this.cardinality, (long)immutableBitmap.size());
    }

    @Test
    public void testToByteArray() {
        ImmutableBitmap immutableBitmap = new RoaringBitmapFactory().mapImmutableBitmap(ByteBuffer.wrap(this.bitmap.toBytes()));
        Assert.assertEquals((long)this.cardinality, (long)immutableBitmap.size());
    }
}

