/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.collections;

import java.util.NoSuchElementException;
import java.util.concurrent.ArrayBlockingQueue;
import org.apache.druid.collections.QueueNonBlockingPool;
import org.apache.druid.collections.ResourceHolder;
import org.junit.Assert;
import org.junit.Test;

public class QueueNonBlockingPoolTest {
    @Test
    public void testTakeAllTwice() {
        ArrayBlockingQueue<String> queue = new ArrayBlockingQueue<String>(2);
        queue.add("foo");
        queue.add("bar");
        QueueNonBlockingPool pool = new QueueNonBlockingPool(queue);
        ResourceHolder obj1 = pool.take();
        Assert.assertEquals((Object)"foo", (Object)obj1.get());
        Assert.assertEquals((long)1L, (long)queue.size());
        ResourceHolder obj2 = pool.take();
        Assert.assertEquals((Object)"bar", (Object)obj2.get());
        Assert.assertEquals((long)0L, (long)queue.size());
        Assert.assertThrows(NoSuchElementException.class, () -> ((QueueNonBlockingPool)pool).take());
        obj2.close();
        Assert.assertEquals((long)1L, (long)queue.size());
        obj1.close();
        Assert.assertEquals((long)2L, (long)queue.size());
        ResourceHolder obj1b = pool.take();
        Assert.assertEquals((Object)"bar", (Object)obj1b.get());
        Assert.assertEquals((long)1L, (long)queue.size());
        ResourceHolder obj2b = pool.take();
        Assert.assertEquals((Object)"foo", (Object)obj2b.get());
        Assert.assertEquals((long)0L, (long)queue.size());
        Assert.assertThrows(NoSuchElementException.class, () -> ((QueueNonBlockingPool)pool).take());
    }
}

