/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.collections;

import com.google.common.collect.PeekingIterator;
import java.util.Comparator;
import java.util.NoSuchElementException;
import java.util.function.BinaryOperator;
import org.apache.druid.collections.CombiningIterator;
import org.easymock.EasyMock;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class CombiningIteratorTest {
    private CombiningIterator<String> testingIterator;
    private Comparator<String> comparator;
    private BinaryOperator<String> combiningFunction;
    private PeekingIterator<String> peekIterator;

    @Before
    public void setUp() {
        this.peekIterator = (PeekingIterator)EasyMock.createMock(PeekingIterator.class);
        this.comparator = (Comparator)EasyMock.createMock(Comparator.class);
        this.combiningFunction = (BinaryOperator)EasyMock.createMock(BinaryOperator.class);
        this.testingIterator = CombiningIterator.create(this.peekIterator, this.comparator, this.combiningFunction);
    }

    @After
    public void tearDown() {
        this.testingIterator = null;
    }

    @Test
    public void testHasNext() {
        boolean expected = true;
        EasyMock.expect((Object)this.peekIterator.hasNext()).andReturn((Object)expected);
        EasyMock.replay((Object[])new Object[]{this.peekIterator});
        boolean actual = this.testingIterator.hasNext();
        EasyMock.verify((Object[])new Object[]{this.peekIterator});
        Assert.assertEquals((String)"The hasNext function is broken", (Object)expected, (Object)actual);
    }

    @Test
    public void testFalseBranchNext() {
        boolean expected = true;
        EasyMock.expect((Object)this.peekIterator.hasNext()).andReturn((Object)expected);
        expected = false;
        EasyMock.expect((Object)this.peekIterator.hasNext()).andReturn((Object)expected);
        EasyMock.replay((Object[])new Object[]{this.peekIterator});
        Object res = this.testingIterator.next();
        EasyMock.verify((Object[])new Object[]{this.peekIterator});
        Assert.assertNull((String)"Should be null", (Object)res);
    }

    @Test
    public void testNext() {
        boolean expected = true;
        EasyMock.expect((Object)this.peekIterator.hasNext()).andReturn((Object)expected).times(4);
        String defaultString = "S1";
        String resString = "S2";
        EasyMock.expect((Object)((String)this.peekIterator.next())).andReturn((Object)defaultString);
        EasyMock.expect((Object)((String)this.combiningFunction.apply((String)EasyMock.eq((Object)defaultString), (String)EasyMock.isNull()))).andReturn((Object)resString);
        EasyMock.expect((Object)((String)this.peekIterator.next())).andReturn((Object)defaultString);
        EasyMock.expect((Object)this.comparator.compare((String)EasyMock.eq((Object)resString), (String)EasyMock.eq((Object)defaultString))).andReturn((Object)0);
        EasyMock.expect((Object)((String)this.peekIterator.next())).andReturn((Object)defaultString);
        EasyMock.expect((Object)((String)this.combiningFunction.apply((String)EasyMock.eq((Object)resString), (String)EasyMock.eq((Object)defaultString)))).andReturn((Object)resString);
        EasyMock.expect((Object)this.comparator.compare((String)EasyMock.eq((Object)resString), (String)EasyMock.eq((Object)defaultString))).andReturn((Object)1);
        EasyMock.replay((Object[])new Object[]{this.peekIterator});
        EasyMock.replay((Object[])new Object[]{this.combiningFunction});
        EasyMock.replay((Object[])new Object[]{this.comparator});
        String actual = (String)this.testingIterator.next();
        Assert.assertEquals((Object)resString, (Object)actual);
        EasyMock.verify((Object[])new Object[]{this.peekIterator});
        EasyMock.verify((Object[])new Object[]{this.comparator});
        EasyMock.verify((Object[])new Object[]{this.combiningFunction});
    }

    @Test(expected=NoSuchElementException.class)
    public void testExceptionInNext() {
        boolean expected = false;
        EasyMock.expect((Object)this.peekIterator.hasNext()).andReturn((Object)expected);
        EasyMock.replay((Object[])new Object[]{this.peekIterator});
        this.testingIterator.next();
        EasyMock.verify((Object[])new Object[]{this.peekIterator});
    }

    @Test(expected=UnsupportedOperationException.class)
    public void testRemove() {
        this.testingIterator.remove();
    }
}

