/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.collections;

import com.google.common.base.Suppliers;
import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import org.apache.druid.collections.CloseableDefaultBlockingPool;
import org.apache.druid.collections.ReferenceCountingResourceHolder;
import org.apache.druid.java.util.common.concurrent.Execs;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;

public class BlockingPoolTest {
    private ExecutorService service;
    private CloseableDefaultBlockingPool<Integer> pool;
    private CloseableDefaultBlockingPool<Integer> emptyPool;
    @Rule
    public ExpectedException expectedException = ExpectedException.none();

    @Before
    public void setup() {
        this.service = Execs.multiThreaded((int)2, (String)"blocking-pool-test");
        this.pool = new CloseableDefaultBlockingPool(Suppliers.ofInstance((Object)1), 10);
        this.emptyPool = new CloseableDefaultBlockingPool(Suppliers.ofInstance((Object)1), 0);
    }

    @After
    public void teardown() {
        this.pool.close();
        this.emptyPool.close();
        this.service.shutdownNow();
    }

    @Test
    public void testTakeFromEmptyPool() {
        this.expectedException.expect(IllegalStateException.class);
        this.expectedException.expectMessage("Pool was initialized with limit = 0, there are no objects to take.");
        this.emptyPool.takeBatch(1, 0L);
    }

    @Test
    public void testDrainFromEmptyPool() {
        this.expectedException.expect(IllegalStateException.class);
        this.expectedException.expectMessage("Pool was initialized with limit = 0, there are no objects to take.");
        this.emptyPool.takeBatch(1, 0L);
    }

    @Test(timeout=60000L)
    public void testTake() {
        ReferenceCountingResourceHolder holder = (ReferenceCountingResourceHolder)Iterables.getOnlyElement((Iterable)this.pool.takeBatch(1, 100L), null);
        Assert.assertNotNull((Object)holder);
        Assert.assertEquals((long)9L, (long)this.pool.getPoolSize());
        holder.close();
        Assert.assertEquals((long)10L, (long)this.pool.getPoolSize());
    }

    @Test(timeout=60000L)
    public void testTakeTimeout() {
        List batchHolder = this.pool.takeBatch(10, 100L);
        ReferenceCountingResourceHolder holder = (ReferenceCountingResourceHolder)Iterables.getOnlyElement((Iterable)this.pool.takeBatch(1, 100L), null);
        Assert.assertNull((Object)holder);
        batchHolder.forEach(ReferenceCountingResourceHolder::close);
    }

    @Test(timeout=60000L)
    public void testTakeBatch() {
        List holder = this.pool.takeBatch(6, 100L);
        Assert.assertNotNull((Object)holder);
        Assert.assertEquals((long)6L, (long)holder.size());
        Assert.assertEquals((long)4L, (long)this.pool.getPoolSize());
        holder.forEach(ReferenceCountingResourceHolder::close);
        Assert.assertEquals((long)10L, (long)this.pool.getPoolSize());
    }

    @Test(timeout=60000L)
    public void testWaitAndTakeBatch() throws InterruptedException, ExecutionException {
        List batchHolder = this.pool.takeBatch(10, 10L);
        Assert.assertNotNull((Object)batchHolder);
        Assert.assertEquals((long)10L, (long)batchHolder.size());
        Assert.assertEquals((long)0L, (long)this.pool.getPoolSize());
        Future<List> future = this.service.submit(() -> this.pool.takeBatch(8, 100L));
        Thread.sleep(20L);
        batchHolder.forEach(ReferenceCountingResourceHolder::close);
        batchHolder = future.get();
        Assert.assertNotNull((Object)batchHolder);
        Assert.assertEquals((long)8L, (long)batchHolder.size());
        Assert.assertEquals((long)2L, (long)this.pool.getPoolSize());
        batchHolder.forEach(ReferenceCountingResourceHolder::close);
        Assert.assertEquals((long)10L, (long)this.pool.getPoolSize());
    }

    @Test(timeout=60000L)
    public void testTakeBatchTooManyObjects() {
        List holder = this.pool.takeBatch(100, 100L);
        Assert.assertTrue((boolean)holder.isEmpty());
    }

    @Test(timeout=60000L)
    public void testConcurrentTake() throws ExecutionException, InterruptedException {
        int limit1 = this.pool.maxSize() / 2;
        int limit2 = this.pool.maxSize() - limit1 + 1;
        Future<List> f1 = this.service.submit(() -> {
            ArrayList<ReferenceCountingResourceHolder> result = new ArrayList<ReferenceCountingResourceHolder>();
            for (int i = 0; i < limit1; ++i) {
                result.add((ReferenceCountingResourceHolder)Iterables.getOnlyElement((Iterable)this.pool.takeBatch(1, 10L), null));
            }
            return result;
        });
        Future<List> f2 = this.service.submit(() -> {
            ArrayList<ReferenceCountingResourceHolder> result = new ArrayList<ReferenceCountingResourceHolder>();
            for (int i = 0; i < limit2; ++i) {
                result.add((ReferenceCountingResourceHolder)Iterables.getOnlyElement((Iterable)this.pool.takeBatch(1, 10L), null));
            }
            return result;
        });
        List r1 = f1.get();
        List r2 = f2.get();
        Assert.assertEquals((long)0L, (long)this.pool.getPoolSize());
        Assert.assertTrue((r1.contains(null) || r2.contains(null) ? 1 : 0) != 0);
        int nonNullCount = 0;
        for (ReferenceCountingResourceHolder holder : r1) {
            if (holder == null) continue;
            ++nonNullCount;
        }
        for (ReferenceCountingResourceHolder holder : r2) {
            if (holder == null) continue;
            ++nonNullCount;
        }
        Assert.assertEquals((long)this.pool.maxSize(), (long)nonNullCount);
        Future<?> future1 = this.service.submit(() -> {
            for (ReferenceCountingResourceHolder holder : r1) {
                if (holder == null) continue;
                holder.close();
            }
        });
        Future<?> future2 = this.service.submit(() -> {
            for (ReferenceCountingResourceHolder holder : r2) {
                if (holder == null) continue;
                holder.close();
            }
        });
        future1.get();
        future2.get();
        Assert.assertEquals((long)this.pool.maxSize(), (long)this.pool.getPoolSize());
    }

    @Test(timeout=60000L)
    public void testConcurrentTakeBatch() throws ExecutionException, InterruptedException {
        int batch1 = this.pool.maxSize() / 2;
        Callable<List> c1 = () -> this.pool.takeBatch(batch1, 10L);
        int batch2 = this.pool.maxSize() - batch1 + 1;
        Callable<List> c2 = () -> this.pool.takeBatch(batch2, 10L);
        Future<List> f1 = this.service.submit(c1);
        Future<List> f2 = this.service.submit(c2);
        List r1 = f1.get();
        List r2 = f2.get();
        if (!r1.isEmpty()) {
            Assert.assertTrue((boolean)r2.isEmpty());
            Assert.assertEquals((long)(this.pool.maxSize() - batch1), (long)this.pool.getPoolSize());
            Assert.assertEquals((long)batch1, (long)r1.size());
            r1.forEach(ReferenceCountingResourceHolder::close);
        } else {
            Assert.assertNotNull((Object)r2);
            Assert.assertEquals((long)(this.pool.maxSize() - batch2), (long)this.pool.getPoolSize());
            Assert.assertEquals((long)batch2, (long)r2.size());
            r2.forEach(ReferenceCountingResourceHolder::close);
        }
        Assert.assertEquals((long)this.pool.maxSize(), (long)this.pool.getPoolSize());
    }

    @Test(timeout=60000L)
    public void testConcurrentBatchClose() throws ExecutionException, InterruptedException {
        int batch1 = this.pool.maxSize() / 2;
        Callable<List> c1 = () -> this.pool.takeBatch(batch1, 10L);
        int batch2 = this.pool.maxSize() - batch1;
        Callable<List> c2 = () -> this.pool.takeBatch(batch2, 10L);
        Future<List> f1 = this.service.submit(c1);
        Future<List> f2 = this.service.submit(c2);
        List r1 = f1.get();
        List r2 = f2.get();
        Assert.assertNotNull((Object)r1);
        Assert.assertNotNull((Object)r2);
        Assert.assertEquals((long)batch1, (long)r1.size());
        Assert.assertEquals((long)batch2, (long)r2.size());
        Assert.assertEquals((long)0L, (long)this.pool.getPoolSize());
        Future<?> future1 = this.service.submit(() -> r1.forEach(ReferenceCountingResourceHolder::close));
        Future<?> future2 = this.service.submit(() -> r2.forEach(ReferenceCountingResourceHolder::close));
        future1.get();
        future2.get();
        Assert.assertEquals((long)this.pool.maxSize(), (long)this.pool.getPoolSize());
    }

    @Test(timeout=60000L)
    public void testConcurrentTakeBatchClose() throws ExecutionException, InterruptedException {
        List r1 = this.pool.takeBatch(1, 10L);
        Callable<List> c2 = () -> this.pool.takeBatch(10, 100L);
        Future<List> f2 = this.service.submit(c2);
        Future<?> f1 = this.service.submit(() -> {
            try {
                Thread.sleep(50L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            r1.forEach(ReferenceCountingResourceHolder::close);
        });
        List r2 = f2.get();
        f1.get();
        Assert.assertNotNull((Object)r2);
        Assert.assertEquals((long)10L, (long)r2.size());
        Assert.assertEquals((long)0L, (long)this.pool.getPoolSize());
        r2.forEach(ReferenceCountingResourceHolder::close);
        Assert.assertEquals((long)this.pool.maxSize(), (long)this.pool.getPoolSize());
    }
}

