/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.annotations;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.druid.annotations.SubclassesMustOverrideEqualsAndHashCode;
import org.junit.Assert;
import org.junit.Test;
import org.reflections.Reflections;
import org.reflections.util.ClasspathHelper;

public class SubclassesMustOverrideEqualsAndHashCodeTest {
    @Test
    public void testEqualsAndHashCode() throws NoSuchMethodException {
        Set urls = ClasspathHelper.forPackage((String)"org.apache.druid", (ClassLoader[])new ClassLoader[0]).stream().filter(url -> !url.toString().contains("/target/test-classes")).collect(Collectors.toSet());
        Reflections reflections = new Reflections(new Object[]{urls});
        Set classes = reflections.getTypesAnnotatedWith(SubclassesMustOverrideEqualsAndHashCode.class);
        HashSet<String> failed = new HashSet<String>();
        for (Class clazz : classes) {
            if (clazz.isInterface() || Modifier.isAbstract(clazz.getModifiers())) continue;
            Method m = clazz.getMethod("hashCode", new Class[0]);
            String className = clazz.getName();
            try {
                Assert.assertNotSame((String)(className + " does not implment hashCode"), Object.class, m.getDeclaringClass());
            }
            catch (AssertionError e) {
                failed.add(className);
            }
        }
        if (!failed.isEmpty()) {
            System.err.println("failed classes [" + failed.size() + "] : ");
            failed.forEach(c -> System.err.println("\t" + c));
            Assert.fail();
        }
    }
}

