/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.timeline.partition;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import nl.jqno.equalsverifier.EqualsVerifier;
import org.apache.druid.timeline.partition.PartialShardSpec;
import org.apache.druid.timeline.partition.ShardSpec;
import org.apache.druid.timeline.partition.ShardSpecTestUtils;
import org.apache.druid.timeline.partition.SingleDimensionPartialShardSpec;
import org.apache.druid.timeline.partition.SingleDimensionShardSpec;
import org.junit.Assert;
import org.junit.Test;

public class SingleDimensionPartialShardSpecTest {
    @Test
    public void testEquals() {
        EqualsVerifier.forClass(SingleDimensionPartialShardSpec.class).usingGetClass().withNonnullFields(new String[]{"partitionDimension", "bucketId", "numBuckets"}).verify();
    }

    @Test
    public void testSerde() throws IOException {
        SingleDimensionPartialShardSpec expected = new SingleDimensionPartialShardSpec("partitionKey", 3, "start", "end", 10);
        ObjectMapper mapper = ShardSpecTestUtils.initObjectMapper();
        byte[] json = mapper.writeValueAsBytes((Object)expected);
        SingleDimensionPartialShardSpec fromJson = (SingleDimensionPartialShardSpec)mapper.readValue(json, PartialShardSpec.class);
        Assert.assertEquals((Object)expected, (Object)fromJson);
    }

    @Test
    public void testComplete() {
        SingleDimensionPartialShardSpec partialShardSpec = new SingleDimensionPartialShardSpec("dim", 2, "end2", null, 3);
        ShardSpec shardSpec = partialShardSpec.complete(new ObjectMapper(), 1, 2);
        Assert.assertEquals((Object)new SingleDimensionShardSpec("dim", "end2", null, 1, Integer.valueOf(2)), (Object)shardSpec);
    }
}

