/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.timeline.partition;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ThreadLocalRandom;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import nl.jqno.equalsverifier.EqualsVerifier;
import org.apache.druid.timeline.partition.AtomicUpdateGroup;
import org.apache.druid.timeline.partition.NumberedOverwritingPartitionChunk;
import org.apache.druid.timeline.partition.NumberedPartitionChunk;
import org.apache.druid.timeline.partition.OvershadowableInteger;
import org.apache.druid.timeline.partition.OvershadowableManager;
import org.apache.druid.timeline.partition.PartitionChunk;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;

public class OvershadowableManagerTest {
    private static final String MAJOR_VERSION = "version";
    @Rule
    public ExpectedException expectedException = ExpectedException.none();
    private OvershadowableManager<OvershadowableInteger> manager;
    private int nextRootPartitionId;
    private int nextNonRootPartitionId;
    private List<PartitionChunk<OvershadowableInteger>> expectedVisibleChunks;
    private List<PartitionChunk<OvershadowableInteger>> expectedOvershadowedChunks;
    private List<PartitionChunk<OvershadowableInteger>> expectedStandbyChunks;

    @Before
    public void setup() {
        this.manager = new OvershadowableManager();
        this.nextRootPartitionId = 0;
        this.nextNonRootPartitionId = 32768;
        this.expectedVisibleChunks = new ArrayList<PartitionChunk<OvershadowableInteger>>();
        this.expectedOvershadowedChunks = new ArrayList<PartitionChunk<OvershadowableInteger>>();
        this.expectedStandbyChunks = new ArrayList<PartitionChunk<OvershadowableInteger>>();
    }

    @Test
    public void testCopyVisible() {
        this.manager.addChunk(this.newRootChunk());
        this.manager.addChunk(this.newRootChunk());
        this.manager.addChunk(this.newNonRootChunk(0, 2, 1, 3));
        this.manager.addChunk(this.newNonRootChunk(0, 2, 1, 3));
        this.manager.addChunk(this.newNonRootChunk(0, 2, 1, 3));
        this.manager.addChunk(this.newRootChunk());
        this.manager.addChunk(this.newRootChunk());
        this.manager.addChunk(this.newNonRootChunk(2, 4, 1, 3));
        OvershadowableManager copy = OvershadowableManager.copyVisible(this.manager);
        Assert.assertTrue((boolean)copy.getOvershadowedChunks().isEmpty());
        Assert.assertTrue((boolean)copy.getStandbyChunks().isEmpty());
        Assert.assertEquals((Object)Lists.newArrayList((Iterator)this.manager.visibleChunksIterator()), (Object)Lists.newArrayList((Iterator)copy.visibleChunksIterator()));
    }

    @Test
    public void testDeepCopy() {
        this.manager.addChunk(this.newRootChunk());
        this.manager.addChunk(this.newRootChunk());
        this.manager.addChunk(this.newNonRootChunk(0, 2, 1, 3));
        this.manager.addChunk(this.newNonRootChunk(0, 2, 1, 3));
        this.manager.addChunk(this.newNonRootChunk(0, 2, 1, 3));
        this.manager.addChunk(this.newRootChunk());
        this.manager.addChunk(this.newRootChunk());
        this.manager.addChunk(this.newNonRootChunk(2, 4, 1, 3));
        OvershadowableManager copy = OvershadowableManager.deepCopy(this.manager);
        Assert.assertEquals(this.manager, (Object)copy);
    }

    @Test
    public void testEqualAndHashCodeContract() {
        EqualsVerifier.forClass(OvershadowableManager.class).usingGetClass().verify();
    }

    @Test
    public void testFindOvershadowedBy() {
        ArrayList<NumberedOverwritingPartitionChunk<OvershadowableInteger>> expectedOvershadowedChunks = new ArrayList<NumberedOverwritingPartitionChunk<OvershadowableInteger>>();
        NumberedOverwritingPartitionChunk<OvershadowableInteger> chunk = this.newNonRootChunk(0, 2, 1, 1);
        this.manager.addChunk(chunk);
        chunk = this.newNonRootChunk(0, 3, 2, 1);
        this.manager.addChunk(chunk);
        chunk = this.newNonRootChunk(0, 5, 3, 1);
        this.manager.addChunk(chunk);
        chunk = this.newNonRootChunk(5, 8, 1, 1);
        expectedOvershadowedChunks.add(chunk);
        this.manager.addChunk(chunk);
        chunk = this.newNonRootChunk(8, 11, 2, 1);
        this.manager.addChunk(chunk);
        chunk = this.newNonRootChunk(5, 11, 3, 1);
        this.manager.addChunk(chunk);
        chunk = this.newNonRootChunk(0, 12, 5, 1);
        this.manager.addChunk(chunk);
        List overshadowedGroups = this.manager.findOvershadowedBy(OvershadowableManager.RootPartitionRange.of((int)2, (int)10), (short)10, OvershadowableManager.State.OVERSHADOWED);
        Assert.assertEquals(expectedOvershadowedChunks.stream().map(AtomicUpdateGroup::new).collect(Collectors.toList()), (Object)overshadowedGroups);
        overshadowedGroups = this.manager.findOvershadowedBy(OvershadowableManager.RootPartitionRange.of((int)2, (int)10), (short)10, OvershadowableManager.State.VISIBLE);
        Assert.assertEquals(Collections.emptyList(), (Object)overshadowedGroups);
    }

    @Test
    public void testFindOvershadows() {
        NumberedOverwritingPartitionChunk<OvershadowableInteger> chunk = this.newNonRootChunk(2, 6, 3, 1);
        this.manager.addChunk(chunk);
        chunk = this.newNonRootChunk(6, 8, 3, 1);
        this.manager.addChunk(chunk);
        NumberedOverwritingPartitionChunk<OvershadowableInteger> visibleChunk = chunk = this.newNonRootChunk(1, 8, 4, 1);
        this.manager.addChunk(chunk);
        List overshadowingGroups = this.manager.findOvershadows(OvershadowableManager.RootPartitionRange.of((int)1, (int)3), (short)1, OvershadowableManager.State.OVERSHADOWED);
        Assert.assertEquals(Collections.emptyList(), (Object)overshadowingGroups);
        overshadowingGroups = this.manager.findOvershadows(OvershadowableManager.RootPartitionRange.of((int)1, (int)3), (short)1, OvershadowableManager.State.VISIBLE);
        Assert.assertEquals((Object)ImmutableList.of((Object)new AtomicUpdateGroup(visibleChunk)), (Object)overshadowingGroups);
        overshadowingGroups = this.manager.findOvershadows(OvershadowableManager.RootPartitionRange.of((int)4, (int)7), (short)1, OvershadowableManager.State.OVERSHADOWED);
        Assert.assertEquals(Collections.emptyList(), (Object)overshadowingGroups);
        overshadowingGroups = this.manager.findOvershadows(OvershadowableManager.RootPartitionRange.of((int)4, (int)7), (short)1, OvershadowableManager.State.VISIBLE);
        Assert.assertEquals((Object)ImmutableList.of((Object)new AtomicUpdateGroup(visibleChunk)), (Object)overshadowingGroups);
    }

    @Test
    public void testAddRootChunkToEmptyManager() {
        Assert.assertTrue((boolean)this.manager.isEmpty());
        NumberedPartitionChunk<OvershadowableInteger> chunk = this.newRootChunk();
        Assert.assertTrue((boolean)this.addVisibleToManager((PartitionChunk<OvershadowableInteger>)chunk));
        this.assertManagerState();
        Assert.assertTrue((boolean)this.manager.isComplete());
        Assert.assertFalse((boolean)this.manager.addChunk(chunk));
        chunk = this.newRootChunk();
        Assert.assertTrue((boolean)this.addVisibleToManager((PartitionChunk<OvershadowableInteger>)chunk));
        this.assertManagerState();
        Assert.assertTrue((boolean)this.manager.isComplete());
    }

    @Test
    public void testAddNonRootChunkToEmptyManager() {
        Assert.assertTrue((boolean)this.manager.isEmpty());
        NumberedOverwritingPartitionChunk<OvershadowableInteger> chunk = this.newNonRootChunk(10, 12, 1, 3);
        Assert.assertTrue((boolean)this.addVisibleToManager((PartitionChunk<OvershadowableInteger>)chunk));
        this.assertManagerState();
        Assert.assertFalse((boolean)this.manager.isComplete());
        chunk = this.newNonRootChunk(10, 12, 1, 3);
        Assert.assertTrue((boolean)this.addVisibleToManager((PartitionChunk<OvershadowableInteger>)chunk));
        this.assertManagerState();
        Assert.assertFalse((boolean)this.manager.isComplete());
        chunk = this.newNonRootChunk(10, 12, 1, 3);
        Assert.assertTrue((boolean)this.addVisibleToManager((PartitionChunk<OvershadowableInteger>)chunk));
        this.assertManagerState();
        Assert.assertTrue((boolean)this.manager.isComplete());
        this.expectedException.expect(IllegalStateException.class);
        this.expectedException.expectMessage("Can't add chunk");
        chunk = this.newNonRootChunk(10, 12, 1, 3);
        this.addVisibleToManager((PartitionChunk<OvershadowableInteger>)chunk);
    }

    @Test
    public void testRemoveFromEmptyManager() {
        Assert.assertTrue((boolean)this.manager.isEmpty());
        NumberedPartitionChunk<OvershadowableInteger> chunk = this.newRootChunk();
        Assert.assertNull((Object)this.manager.removeChunk(chunk));
    }

    @Test
    public void testAddOvershadowedChunkToCompletePartition() {
        NumberedOverwritingPartitionChunk<OvershadowableInteger> chunk = this.newNonRootChunk(0, 3, 1, 2);
        Assert.assertTrue((boolean)this.addVisibleToManager((PartitionChunk<OvershadowableInteger>)chunk));
        this.assertManagerState();
        chunk = this.newNonRootChunk(0, 3, 1, 2);
        Assert.assertTrue((boolean)this.addVisibleToManager((PartitionChunk<OvershadowableInteger>)chunk));
        this.assertManagerState();
        this.nextRootPartitionId = 1;
        chunk = this.newRootChunk();
        Assert.assertTrue((boolean)this.manager.addChunk(chunk));
        this.expectedOvershadowedChunks.add((PartitionChunk<OvershadowableInteger>)chunk);
        this.assertManagerState();
    }

    @Test
    public void testAddOvershadowedChunkToIncompletePartition() {
        NumberedOverwritingPartitionChunk<OvershadowableInteger> chunk = this.newNonRootChunk(0, 3, 1, 2);
        Assert.assertTrue((boolean)this.addVisibleToManager((PartitionChunk<OvershadowableInteger>)chunk));
        this.assertManagerState();
        this.nextRootPartitionId = 1;
        chunk = this.newRootChunk();
        this.expectedOvershadowedChunks.add((PartitionChunk<OvershadowableInteger>)chunk);
        Assert.assertTrue((boolean)this.manager.addChunk(chunk));
        this.assertManagerState();
    }

    @Test
    public void testAddStandbyChunksToCompletePartition() {
        NumberedPartitionChunk<OvershadowableInteger> chunk;
        for (int i = 0; i < 3; ++i) {
            chunk = this.newRootChunk();
            Assert.assertTrue((boolean)this.addVisibleToManager((PartitionChunk<OvershadowableInteger>)chunk));
            this.assertManagerState();
        }
        chunk = this.newNonRootChunk(0, 3, 1, 2);
        this.expectedStandbyChunks.add((PartitionChunk<OvershadowableInteger>)chunk);
        Assert.assertTrue((boolean)this.manager.addChunk(chunk));
        this.assertManagerState();
        chunk = this.newNonRootChunk(0, 3, 1, 2);
        this.expectedOvershadowedChunks.addAll(this.expectedVisibleChunks);
        this.expectedVisibleChunks.clear();
        this.expectedVisibleChunks.addAll(this.expectedStandbyChunks);
        this.expectedStandbyChunks.clear();
        Assert.assertTrue((boolean)this.addVisibleToManager((PartitionChunk<OvershadowableInteger>)chunk));
        this.assertManagerState();
    }

    @Test
    public void testAddStandbyChunksToIncompletePartition() {
        NumberedOverwritingPartitionChunk<OvershadowableInteger> chunk = this.newNonRootChunk(0, 3, 1, 2);
        Assert.assertTrue((boolean)this.addVisibleToManager((PartitionChunk<OvershadowableInteger>)chunk));
        this.assertManagerState();
        chunk = this.newNonRootChunk(0, 3, 2, 3);
        this.expectedOvershadowedChunks.add(this.expectedVisibleChunks.remove(0));
        Assert.assertTrue((boolean)this.addVisibleToManager((PartitionChunk<OvershadowableInteger>)chunk));
        this.assertManagerState();
        chunk = this.newNonRootChunk(0, 3, 2, 3);
        Assert.assertTrue((boolean)this.addVisibleToManager((PartitionChunk<OvershadowableInteger>)chunk));
        this.assertManagerState();
    }

    @Test
    public void testRemoveUnknownChunk() {
        NumberedPartitionChunk<OvershadowableInteger> chunk = this.newRootChunk();
        Assert.assertTrue((boolean)this.addVisibleToManager((PartitionChunk<OvershadowableInteger>)chunk));
        this.assertManagerState();
        chunk = this.newRootChunk();
        Assert.assertNull((Object)this.manager.removeChunk(chunk));
        this.assertManagerState();
    }

    @Test
    public void testRemoveChunksUntilEmpty() {
        NumberedPartitionChunk<OvershadowableInteger> chunk;
        for (int i = 0; i < 10; ++i) {
            chunk = this.newRootChunk();
            Assert.assertTrue((boolean)this.addVisibleToManager((PartitionChunk<OvershadowableInteger>)chunk));
            this.assertManagerState();
        }
        while (this.expectedVisibleChunks.size() > 0) {
            chunk = this.expectedVisibleChunks.remove(ThreadLocalRandom.current().nextInt(this.expectedVisibleChunks.size()));
            Assert.assertEquals(chunk, (Object)this.manager.removeChunk(chunk));
            this.assertManagerState();
        }
        Assert.assertTrue((boolean)this.manager.isEmpty());
    }

    @Test
    public void testRemoveStandbyChunk() {
        NumberedPartitionChunk<OvershadowableInteger> chunk;
        for (int i = 0; i < 3; ++i) {
            chunk = this.newRootChunk();
            Assert.assertTrue((boolean)this.addVisibleToManager((PartitionChunk<OvershadowableInteger>)chunk));
            this.assertManagerState();
        }
        chunk = this.newNonRootChunk(0, 3, 1, 3);
        this.expectedStandbyChunks.add((PartitionChunk<OvershadowableInteger>)chunk);
        Assert.assertTrue((boolean)this.manager.addChunk(chunk));
        this.assertManagerState();
        chunk = this.newNonRootChunk(0, 3, 1, 3);
        this.expectedStandbyChunks.add((PartitionChunk<OvershadowableInteger>)chunk);
        Assert.assertTrue((boolean)this.manager.addChunk(chunk));
        this.assertManagerState();
        chunk = this.expectedStandbyChunks.remove(0);
        Assert.assertEquals(chunk, (Object)this.manager.removeChunk(chunk));
        this.assertManagerState();
    }

    @Test
    public void testRemoveVisibleChunkAndFallBackToStandby() {
        NumberedPartitionChunk<OvershadowableInteger> chunk = this.newRootChunk();
        Assert.assertTrue((boolean)this.addVisibleToManager((PartitionChunk<OvershadowableInteger>)chunk));
        this.assertManagerState();
        chunk = this.newRootChunk();
        Assert.assertTrue((boolean)this.addVisibleToManager((PartitionChunk<OvershadowableInteger>)chunk));
        this.assertManagerState();
        chunk = this.newNonRootChunk(0, 2, 1, 3);
        this.expectedStandbyChunks.add((PartitionChunk<OvershadowableInteger>)chunk);
        Assert.assertTrue((boolean)this.manager.addChunk(chunk));
        this.assertManagerState();
        chunk = this.newNonRootChunk(0, 2, 1, 3);
        this.expectedStandbyChunks.add((PartitionChunk<OvershadowableInteger>)chunk);
        Assert.assertTrue((boolean)this.manager.addChunk(chunk));
        this.assertManagerState();
        chunk = this.expectedVisibleChunks.remove(0);
        Assert.assertEquals(chunk, (Object)this.manager.removeChunk(chunk));
        this.expectedOvershadowedChunks.addAll(this.expectedVisibleChunks);
        this.expectedVisibleChunks.clear();
        this.expectedVisibleChunks.addAll(this.expectedStandbyChunks);
        this.expectedStandbyChunks.clear();
        this.assertManagerState();
    }

    @Test
    public void testAddCompleteOvershadowedToInCompletePartition() {
        NumberedOverwritingPartitionChunk<OvershadowableInteger> chunk = this.newNonRootChunk(0, 2, 1, 3);
        Assert.assertTrue((boolean)this.addVisibleToManager((PartitionChunk<OvershadowableInteger>)chunk));
        this.assertManagerState();
        chunk = this.newNonRootChunk(0, 2, 1, 3);
        Assert.assertTrue((boolean)this.addVisibleToManager((PartitionChunk<OvershadowableInteger>)chunk));
        this.assertManagerState();
        chunk = this.newRootChunk();
        this.expectedOvershadowedChunks.add((PartitionChunk<OvershadowableInteger>)chunk);
        Assert.assertTrue((boolean)this.manager.addChunk(chunk));
        this.assertManagerState();
        chunk = this.newRootChunk();
        this.expectedStandbyChunks.addAll(this.expectedVisibleChunks);
        this.expectedVisibleChunks.clear();
        this.expectedVisibleChunks.add(this.expectedOvershadowedChunks.remove(0));
        Assert.assertTrue((boolean)this.addVisibleToManager((PartitionChunk<OvershadowableInteger>)chunk));
        this.assertManagerState();
    }

    @Test
    public void testAddCompleteOvershadowedToCompletePartition() {
        NumberedOverwritingPartitionChunk<OvershadowableInteger> chunk = this.newNonRootChunk(0, 2, 1, 2);
        Assert.assertTrue((boolean)this.addVisibleToManager((PartitionChunk<OvershadowableInteger>)chunk));
        this.assertManagerState();
        chunk = this.newNonRootChunk(0, 2, 1, 2);
        Assert.assertTrue((boolean)this.addVisibleToManager((PartitionChunk<OvershadowableInteger>)chunk));
        this.assertManagerState();
        chunk = this.newRootChunk();
        this.expectedOvershadowedChunks.add((PartitionChunk<OvershadowableInteger>)chunk);
        Assert.assertTrue((boolean)this.manager.addChunk(chunk));
        this.assertManagerState();
        chunk = this.newRootChunk();
        this.expectedOvershadowedChunks.add((PartitionChunk<OvershadowableInteger>)chunk);
        Assert.assertTrue((boolean)this.manager.addChunk(chunk));
        this.assertManagerState();
    }

    @Test
    public void testRemoveChunkFromOvershadowd() {
        this.nextRootPartitionId = 1;
        NumberedPartitionChunk<OvershadowableInteger> chunk = this.newRootChunk();
        Assert.assertTrue((boolean)this.addVisibleToManager((PartitionChunk<OvershadowableInteger>)chunk));
        this.assertManagerState();
        chunk = this.newNonRootChunk(0, 2, 1, 2);
        this.expectedOvershadowedChunks.add(this.expectedVisibleChunks.remove(0));
        Assert.assertTrue((boolean)this.addVisibleToManager((PartitionChunk<OvershadowableInteger>)chunk));
        this.assertManagerState();
        chunk = this.expectedOvershadowedChunks.remove(0);
        Assert.assertEquals(chunk, (Object)this.manager.removeChunk(chunk));
        this.assertManagerState();
    }

    @Test
    public void testRemoveChunkFromCompleteParition() {
        this.nextRootPartitionId = 1;
        NumberedPartitionChunk<OvershadowableInteger> chunk = this.newRootChunk();
        Assert.assertTrue((boolean)this.addVisibleToManager((PartitionChunk<OvershadowableInteger>)chunk));
        this.assertManagerState();
        chunk = this.newNonRootChunk(0, 2, 1, 2);
        this.expectedOvershadowedChunks.add(this.expectedVisibleChunks.remove(0));
        Assert.assertTrue((boolean)this.addVisibleToManager((PartitionChunk<OvershadowableInteger>)chunk));
        this.assertManagerState();
        chunk = this.newNonRootChunk(0, 2, 1, 2);
        Assert.assertTrue((boolean)this.addVisibleToManager((PartitionChunk<OvershadowableInteger>)chunk));
        this.assertManagerState();
        chunk = this.expectedVisibleChunks.remove(0);
        Assert.assertEquals(chunk, (Object)this.manager.removeChunk(chunk));
        this.assertManagerState();
        chunk = this.expectedVisibleChunks.remove(0);
        this.expectedVisibleChunks.addAll(this.expectedOvershadowedChunks);
        this.expectedOvershadowedChunks.clear();
        Assert.assertEquals(chunk, (Object)this.manager.removeChunk(chunk));
        this.assertManagerState();
    }

    @Test
    public void testRemoveChunkFromCompletePartitionFallBackToOvershadowed() {
        NumberedPartitionChunk<OvershadowableInteger> chunk = this.newRootChunk();
        Assert.assertTrue((boolean)this.addVisibleToManager((PartitionChunk<OvershadowableInteger>)chunk));
        this.assertManagerState();
        chunk = this.newRootChunk();
        Assert.assertTrue((boolean)this.addVisibleToManager((PartitionChunk<OvershadowableInteger>)chunk));
        this.assertManagerState();
        chunk = this.newNonRootChunk(0, 2, 1, 2);
        this.expectedStandbyChunks.add((PartitionChunk<OvershadowableInteger>)chunk);
        Assert.assertTrue((boolean)this.manager.addChunk(chunk));
        this.assertManagerState();
        chunk = this.newNonRootChunk(0, 2, 1, 2);
        this.expectedOvershadowedChunks.addAll(this.expectedVisibleChunks);
        this.expectedVisibleChunks.clear();
        this.expectedVisibleChunks.add(this.expectedStandbyChunks.remove(0));
        Assert.assertTrue((boolean)this.addVisibleToManager((PartitionChunk<OvershadowableInteger>)chunk));
        this.assertManagerState();
        chunk = this.expectedVisibleChunks.remove(0);
        this.expectedStandbyChunks.addAll(this.expectedVisibleChunks);
        this.expectedVisibleChunks.clear();
        this.expectedVisibleChunks.addAll(this.expectedOvershadowedChunks);
        this.expectedOvershadowedChunks.clear();
        Assert.assertEquals(chunk, (Object)this.manager.removeChunk(chunk));
        this.assertManagerState();
    }

    @Test
    public void testAddCompleteOvershadowedToCompletePartition2() {
        List<PartitionChunk<OvershadowableInteger>> chunks = this.newNonRootChunks(2, 0, 2, 1, 3);
        this.expectedOvershadowedChunks.addAll(chunks);
        chunks.forEach(arg_0 -> this.manager.addChunk(arg_0));
        chunks = this.newNonRootChunks(2, 2, 5, 1, 3);
        this.expectedOvershadowedChunks.addAll(chunks);
        chunks.forEach(arg_0 -> this.manager.addChunk(arg_0));
        chunks = this.newNonRootChunks(2, 5, 8, 1, 3);
        this.expectedOvershadowedChunks.addAll(chunks);
        chunks.forEach(arg_0 -> this.manager.addChunk(arg_0));
        chunks = this.newNonRootChunks(2, 8, 10, 1, 3);
        this.expectedOvershadowedChunks.addAll(chunks);
        chunks.forEach(arg_0 -> this.manager.addChunk(arg_0));
        chunks = this.newNonRootChunks(2, 0, 5, 2, 3);
        this.expectedOvershadowedChunks.addAll(chunks);
        chunks.forEach(arg_0 -> this.manager.addChunk(arg_0));
        chunks = this.newNonRootChunks(2, 0, 8, 3, 3);
        this.expectedOvershadowedChunks.addAll(chunks);
        chunks.forEach(arg_0 -> this.manager.addChunk(arg_0));
        chunks = this.newNonRootChunks(2, 0, 10, 4, 2);
        this.expectedVisibleChunks.addAll(chunks);
        chunks.forEach(arg_0 -> this.manager.addChunk(arg_0));
        chunks = this.newNonRootChunks(1, 0, 10, 5, 2);
        this.expectedStandbyChunks.addAll(chunks);
        chunks.forEach(arg_0 -> this.manager.addChunk(arg_0));
        this.assertManagerState();
        chunks = this.newNonRootChunks(1, 0, 5, 2, 3);
        this.expectedOvershadowedChunks.addAll(chunks);
        chunks.forEach(arg_0 -> this.manager.addChunk(arg_0));
        chunks = this.newNonRootChunks(1, 5, 8, 1, 3);
        this.expectedOvershadowedChunks.addAll(chunks);
        chunks.forEach(arg_0 -> this.manager.addChunk(arg_0));
        chunks = this.newNonRootChunks(1, 8, 10, 1, 3);
        this.expectedOvershadowedChunks.addAll(chunks);
        chunks.forEach(arg_0 -> this.manager.addChunk(arg_0));
        this.assertManagerState();
        PartitionChunk<OvershadowableInteger> chunkToRemove = this.expectedVisibleChunks.remove(0);
        this.expectedStandbyChunks.addAll(this.expectedVisibleChunks);
        this.expectedVisibleChunks.clear();
        Iterator<PartitionChunk<OvershadowableInteger>> iterator = this.expectedOvershadowedChunks.iterator();
        while (iterator.hasNext()) {
            PartitionChunk<OvershadowableInteger> chunk = iterator.next();
            if (((OvershadowableInteger)chunk.getObject()).getStartRootPartitionId() == 0 && ((OvershadowableInteger)chunk.getObject()).getMinorVersion() == 2 || ((OvershadowableInteger)chunk.getObject()).getStartRootPartitionId() == 5 && ((OvershadowableInteger)chunk.getObject()).getMinorVersion() == 1 || ((OvershadowableInteger)chunk.getObject()).getStartRootPartitionId() == 8 && ((OvershadowableInteger)chunk.getObject()).getMinorVersion() == 1) {
                this.expectedVisibleChunks.add(chunk);
                iterator.remove();
                continue;
            }
            if (!(((OvershadowableInteger)chunk.getObject()).getStartRootPartitionId() == 0 && ((OvershadowableInteger)chunk.getObject()).getMinorVersion() > 2 || ((OvershadowableInteger)chunk.getObject()).getStartRootPartitionId() == 5 && ((OvershadowableInteger)chunk.getObject()).getMinorVersion() > 1) && (((OvershadowableInteger)chunk.getObject()).getStartRootPartitionId() != 8 || ((OvershadowableInteger)chunk.getObject()).getMinorVersion() <= 1)) continue;
            this.expectedStandbyChunks.add(chunk);
            iterator.remove();
        }
        Assert.assertEquals(chunkToRemove, (Object)this.manager.removeChunk(chunkToRemove));
        this.assertManagerState();
    }

    @Test
    public void testAddCompleteStandbyToCompletePartition() {
        List<PartitionChunk<OvershadowableInteger>> chunks = this.newNonRootChunks(2, 0, 2, 1, 3);
        this.expectedOvershadowedChunks.addAll(chunks);
        chunks.forEach(arg_0 -> this.manager.addChunk(arg_0));
        chunks = this.newNonRootChunks(2, 2, 5, 1, 3);
        this.expectedOvershadowedChunks.addAll(chunks);
        chunks.forEach(arg_0 -> this.manager.addChunk(arg_0));
        chunks = this.newNonRootChunks(2, 5, 8, 1, 3);
        this.expectedOvershadowedChunks.addAll(chunks);
        chunks.forEach(arg_0 -> this.manager.addChunk(arg_0));
        chunks = this.newNonRootChunks(2, 8, 10, 1, 2);
        this.expectedOvershadowedChunks.addAll(chunks);
        chunks.forEach(arg_0 -> this.manager.addChunk(arg_0));
        chunks = this.newNonRootChunks(2, 0, 5, 2, 2);
        this.expectedVisibleChunks.addAll(chunks);
        chunks.forEach(arg_0 -> this.manager.addChunk(arg_0));
        chunks = this.newNonRootChunks(2, 5, 10, 2, 2);
        this.expectedVisibleChunks.addAll(chunks);
        chunks.forEach(arg_0 -> this.manager.addChunk(arg_0));
        chunks = this.newNonRootChunks(2, 0, 5, 3, 3);
        this.expectedStandbyChunks.addAll(chunks);
        chunks.forEach(arg_0 -> this.manager.addChunk(arg_0));
        chunks = this.newNonRootChunks(2, 5, 10, 3, 3);
        this.expectedStandbyChunks.addAll(chunks);
        chunks.forEach(arg_0 -> this.manager.addChunk(arg_0));
        chunks = this.newNonRootChunks(2, 0, 5, 4, 3);
        this.expectedStandbyChunks.addAll(chunks);
        chunks.forEach(arg_0 -> this.manager.addChunk(arg_0));
        chunks = this.newNonRootChunks(2, 0, 10, 5, 3);
        this.expectedStandbyChunks.addAll(chunks);
        chunks.forEach(arg_0 -> this.manager.addChunk(arg_0));
        this.assertManagerState();
        this.expectedOvershadowedChunks.addAll(this.expectedVisibleChunks);
        this.expectedVisibleChunks.clear();
        chunks = this.newNonRootChunks(1, 0, 5, 4, 3);
        chunks.forEach(this::addVisibleToManager);
        chunks = this.newNonRootChunks(1, 5, 10, 3, 3);
        chunks.forEach(this::addVisibleToManager);
        Iterator<PartitionChunk<OvershadowableInteger>> iterator = this.expectedStandbyChunks.iterator();
        while (iterator.hasNext()) {
            PartitionChunk<OvershadowableInteger> chunk = iterator.next();
            if (((OvershadowableInteger)chunk.getObject()).getStartRootPartitionId() == 0 && ((OvershadowableInteger)chunk.getObject()).getMinorVersion() == 4 || ((OvershadowableInteger)chunk.getObject()).getStartRootPartitionId() == 5 && ((OvershadowableInteger)chunk.getObject()).getMinorVersion() == 3) {
                this.expectedVisibleChunks.add(chunk);
                iterator.remove();
                continue;
            }
            if ((((OvershadowableInteger)chunk.getObject()).getStartRootPartitionId() != 0 || ((OvershadowableInteger)chunk.getObject()).getMinorVersion() >= 4) && (((OvershadowableInteger)chunk.getObject()).getStartRootPartitionId() != 5 || ((OvershadowableInteger)chunk.getObject()).getMinorVersion() >= 3)) continue;
            this.expectedOvershadowedChunks.add(chunk);
            iterator.remove();
        }
        this.assertManagerState();
    }

    @Test
    public void testFallBackToStandby2() {
        List<PartitionChunk<OvershadowableInteger>> chunks = this.newNonRootChunks(2, 0, 2, 1, 3);
        this.expectedOvershadowedChunks.addAll(chunks);
        chunks.forEach(arg_0 -> this.manager.addChunk(arg_0));
        chunks = this.newNonRootChunks(2, 0, 2, 2, 2);
        this.expectedVisibleChunks.addAll(chunks);
        chunks.forEach(arg_0 -> this.manager.addChunk(arg_0));
        chunks = this.newNonRootChunks(2, 0, 2, 3, 3);
        this.expectedStandbyChunks.addAll(chunks);
        chunks.forEach(arg_0 -> this.manager.addChunk(arg_0));
        chunks = this.newNonRootChunks(2, 0, 2, 4, 3);
        this.expectedStandbyChunks.addAll(chunks);
        chunks.forEach(arg_0 -> this.manager.addChunk(arg_0));
        chunks = this.newNonRootChunks(2, 0, 2, 5, 3);
        this.expectedStandbyChunks.addAll(chunks);
        chunks.forEach(arg_0 -> this.manager.addChunk(arg_0));
        this.assertManagerState();
        PartitionChunk<OvershadowableInteger> chunkToRemove = this.expectedVisibleChunks.remove(0);
        this.expectedOvershadowedChunks.addAll(this.expectedVisibleChunks);
        this.expectedVisibleChunks.clear();
        Iterator<PartitionChunk<OvershadowableInteger>> iterator = this.expectedStandbyChunks.iterator();
        while (iterator.hasNext()) {
            PartitionChunk<OvershadowableInteger> chunk = iterator.next();
            if (((OvershadowableInteger)chunk.getObject()).getMinorVersion() == 5) {
                this.expectedVisibleChunks.add(chunk);
                iterator.remove();
                continue;
            }
            this.expectedOvershadowedChunks.add(chunk);
            iterator.remove();
        }
        Assert.assertEquals(chunkToRemove, (Object)this.manager.removeChunk(chunkToRemove));
        this.assertManagerState();
    }

    @Test
    public void testAddAndOverwriteAndAdd() {
        NumberedOverwritingPartitionChunk<OvershadowableInteger> chunk;
        int i;
        for (int i2 = 0; i2 < 5; ++i2) {
            NumberedPartitionChunk<OvershadowableInteger> chunk2 = this.newRootChunk();
            Assert.assertTrue((boolean)this.addVisibleToManager((PartitionChunk<OvershadowableInteger>)chunk2));
        }
        this.assertManagerState();
        int rootStartPartitionIdToOverwrite = this.expectedVisibleChunks.get(1).getChunkNumber();
        int rootEndPartitionIdToOverwrite = this.expectedVisibleChunks.get(3).getChunkNumber();
        for (i = 0; i < 2; ++i) {
            chunk = this.newNonRootChunk(rootStartPartitionIdToOverwrite, rootEndPartitionIdToOverwrite, 3, 2);
            Assert.assertTrue((boolean)this.manager.addChunk(chunk));
            if (i == 0) {
                this.expectedStandbyChunks.add((PartitionChunk<OvershadowableInteger>)chunk);
            }
            if (i == 1) {
                this.expectedOvershadowedChunks.addAll(this.expectedVisibleChunks.subList(1, 3));
                this.expectedVisibleChunks.subList(1, 3).clear();
                this.expectedVisibleChunks.addAll(this.expectedStandbyChunks);
                this.expectedVisibleChunks.add((PartitionChunk<OvershadowableInteger>)chunk);
                this.expectedStandbyChunks.clear();
            }
            this.assertManagerState();
        }
        for (i = 0; i < 3; ++i) {
            chunk = this.newRootChunk();
            Assert.assertTrue((boolean)this.addVisibleToManager((PartitionChunk<OvershadowableInteger>)chunk));
        }
        this.assertManagerState();
        for (i = 0; i < 2; ++i) {
            chunk = this.newNonRootChunk(rootStartPartitionIdToOverwrite, rootEndPartitionIdToOverwrite, 2, 2);
            this.expectedOvershadowedChunks.add((PartitionChunk<OvershadowableInteger>)chunk);
            Assert.assertTrue((boolean)this.manager.addChunk(chunk));
            this.assertManagerState();
        }
    }

    @Test
    public void testRemoveOvershadowed() {
        for (int i2 = 0; i2 < 5; ++i2) {
            NumberedPartitionChunk<OvershadowableInteger> chunk = this.newRootChunk();
            Assert.assertTrue((boolean)this.addVisibleToManager((PartitionChunk<OvershadowableInteger>)chunk));
        }
        int rootStartPartitionIdToOverwrite = this.expectedVisibleChunks.get(1).getChunkNumber();
        int rootEndPartitionIdToOverwrite = this.expectedVisibleChunks.get(3).getChunkNumber();
        for (int i3 = 0; i3 < 2; ++i3) {
            NumberedOverwritingPartitionChunk<OvershadowableInteger> chunk = this.newNonRootChunk(rootStartPartitionIdToOverwrite, rootEndPartitionIdToOverwrite, 1, 2);
            Assert.assertTrue((boolean)this.addVisibleToManager((PartitionChunk<OvershadowableInteger>)chunk));
        }
        this.expectedOvershadowedChunks.addAll(this.expectedVisibleChunks.subList(1, 3));
        IntStream.range(0, 2).forEach(i -> this.expectedVisibleChunks.remove(1));
        this.assertManagerState();
        PartitionChunk<OvershadowableInteger> chunk = this.expectedOvershadowedChunks.remove(0);
        Assert.assertEquals(chunk, (Object)this.manager.removeChunk(chunk));
        this.assertManagerState();
        for (PartitionChunk<OvershadowableInteger> visibleChunk : this.expectedVisibleChunks) {
            if (visibleChunk.getChunkNumber() < 32768) continue;
            Assert.assertEquals(visibleChunk, this.removeVisibleFromManager(visibleChunk));
            break;
        }
        this.assertManagerState();
    }

    @Test
    public void testRemoveOvershadowingVisible() {
        for (int i2 = 0; i2 < 5; ++i2) {
            NumberedPartitionChunk<OvershadowableInteger> chunk = this.newRootChunk();
            Assert.assertTrue((boolean)this.addVisibleToManager((PartitionChunk<OvershadowableInteger>)chunk));
        }
        int rootStartPartitionIdToOverwrite = this.expectedVisibleChunks.get(1).getChunkNumber();
        int rootEndPartitionIdToOverwrite = this.expectedVisibleChunks.get(3).getChunkNumber();
        for (int i3 = 0; i3 < 2; ++i3) {
            NumberedOverwritingPartitionChunk<OvershadowableInteger> chunk = this.newNonRootChunk(rootStartPartitionIdToOverwrite, rootEndPartitionIdToOverwrite, 1, 2);
            Assert.assertTrue((boolean)this.addVisibleToManager((PartitionChunk<OvershadowableInteger>)chunk));
        }
        this.expectedOvershadowedChunks.addAll(this.expectedVisibleChunks.subList(1, 3));
        IntStream.range(0, 2).forEach(i -> this.expectedVisibleChunks.remove(1));
        this.assertManagerState();
        boolean removed = false;
        Iterator<PartitionChunk<OvershadowableInteger>> iterator = this.expectedVisibleChunks.iterator();
        while (iterator.hasNext()) {
            PartitionChunk<OvershadowableInteger> visibleChunk = iterator.next();
            if (visibleChunk.getChunkNumber() < 32768) continue;
            iterator.remove();
            if (!removed) {
                this.manager.removeChunk(visibleChunk);
                removed = true;
                continue;
            }
            this.expectedStandbyChunks.add(visibleChunk);
        }
        this.expectedVisibleChunks.addAll(this.expectedOvershadowedChunks);
        this.expectedOvershadowedChunks.clear();
        this.assertManagerState();
    }

    @Test
    public void testFallBackToStandbyOnRemove() {
        NumberedPartitionChunk<OvershadowableInteger> chunk = this.newRootChunk();
        Assert.assertTrue((boolean)this.addVisibleToManager((PartitionChunk<OvershadowableInteger>)chunk));
        this.assertManagerState();
        chunk = this.newNonRootChunk(0, 1, 1, 3);
        this.expectedStandbyChunks.add((PartitionChunk<OvershadowableInteger>)chunk);
        Assert.assertTrue((boolean)this.manager.addChunk(chunk));
        this.assertManagerState();
        chunk = this.newNonRootChunk(0, 1, 2, 2);
        this.expectedStandbyChunks.add((PartitionChunk<OvershadowableInteger>)chunk);
        Assert.assertTrue((boolean)this.manager.addChunk(chunk));
        this.assertManagerState();
        chunk = this.expectedVisibleChunks.remove(0);
        this.expectedVisibleChunks.add(this.expectedStandbyChunks.remove(1));
        this.expectedOvershadowedChunks.add(this.expectedStandbyChunks.remove(0));
        Assert.assertEquals(chunk, (Object)this.manager.removeChunk(chunk));
        this.assertManagerState();
    }

    @Test
    public void testFallBackToOvershadowedOnRemove() {
        NumberedOverwritingPartitionChunk<OvershadowableInteger> chunk;
        int i;
        for (i = 0; i < 2; ++i) {
            chunk = this.newNonRootChunk(10, 20, 5, 3);
            Assert.assertTrue((boolean)this.addVisibleToManager((PartitionChunk<OvershadowableInteger>)chunk));
        }
        this.assertManagerState();
        for (i = 0; i < 2; ++i) {
            chunk = this.newNonRootChunk(10, 20, 4, 3);
            this.expectedOvershadowedChunks.add((PartitionChunk<OvershadowableInteger>)chunk);
            Assert.assertTrue((boolean)this.manager.addChunk(chunk));
            chunk = this.newNonRootChunk(10, 20, 3, 3);
            this.expectedOvershadowedChunks.add((PartitionChunk<OvershadowableInteger>)chunk);
            Assert.assertTrue((boolean)this.manager.addChunk(chunk));
        }
        this.assertManagerState();
        chunk = this.expectedVisibleChunks.remove(0);
        Assert.assertEquals(chunk, (Object)this.manager.removeChunk(chunk));
        this.assertManagerState();
        chunk = this.expectedVisibleChunks.remove(0);
        this.expectedOvershadowedChunks.stream().filter(c -> ((OvershadowableInteger)c.getObject()).getMinorVersion() == 4).forEach(c -> this.expectedVisibleChunks.add((PartitionChunk<OvershadowableInteger>)c));
        this.expectedOvershadowedChunks.removeAll(this.expectedVisibleChunks);
        Assert.assertEquals(chunk, (Object)this.manager.removeChunk(chunk));
        this.assertManagerState();
    }

    @Test
    public void testAddIncompleteAtomicUpdateGroups() {
        NumberedOverwritingPartitionChunk<OvershadowableInteger> chunk = this.newNonRootChunk(0, 1, 1, 3);
        Assert.assertTrue((boolean)this.addVisibleToManager((PartitionChunk<OvershadowableInteger>)chunk));
        this.assertManagerState();
        chunk = this.newNonRootChunk(0, 1, 2, 2);
        this.expectedOvershadowedChunks.add(this.expectedVisibleChunks.remove(0));
        Assert.assertTrue((boolean)this.addVisibleToManager((PartitionChunk<OvershadowableInteger>)chunk));
        this.assertManagerState();
        chunk = this.newNonRootChunk(0, 1, 3, 5);
        this.expectedOvershadowedChunks.add(this.expectedVisibleChunks.remove(0));
        Assert.assertTrue((boolean)this.addVisibleToManager((PartitionChunk<OvershadowableInteger>)chunk));
        this.assertManagerState();
        chunk = this.newNonRootChunk(0, 1, 2, 2);
        this.expectedStandbyChunks.add(this.expectedVisibleChunks.remove(0));
        this.expectedVisibleChunks.add(this.expectedOvershadowedChunks.remove(this.expectedOvershadowedChunks.size() - 1));
        Assert.assertTrue((boolean)this.addVisibleToManager((PartitionChunk<OvershadowableInteger>)chunk));
        this.assertManagerState();
    }

    @Test
    public void testMissingStartRootPartitionId() {
        int i;
        this.nextRootPartitionId = 2;
        NumberedPartitionChunk<OvershadowableInteger> chunk = this.newRootChunk();
        Assert.assertTrue((boolean)this.addVisibleToManager((PartitionChunk<OvershadowableInteger>)chunk));
        this.assertManagerState();
        this.expectedOvershadowedChunks.addAll(this.expectedVisibleChunks);
        this.expectedVisibleChunks.clear();
        for (i = 0; i < 2; ++i) {
            chunk = this.newNonRootChunk(0, 3, 1, 2);
            Assert.assertTrue((boolean)this.addVisibleToManager((PartitionChunk<OvershadowableInteger>)chunk));
        }
        this.assertManagerState();
        for (i = 0; i < 2; ++i) {
            chunk = this.expectedVisibleChunks.remove(0);
            Assert.assertEquals(chunk, (Object)this.manager.removeChunk(chunk));
        }
        this.expectedVisibleChunks.addAll(this.expectedOvershadowedChunks);
        this.expectedOvershadowedChunks.clear();
        this.assertManagerState();
    }

    private boolean addVisibleToManager(PartitionChunk<OvershadowableInteger> chunk) {
        this.expectedVisibleChunks.add(chunk);
        return this.manager.addChunk(chunk);
    }

    private PartitionChunk<OvershadowableInteger> removeVisibleFromManager(PartitionChunk<OvershadowableInteger> chunk) {
        this.expectedVisibleChunks.remove(chunk);
        return this.manager.removeChunk(chunk);
    }

    private void assertManagerState() {
        Assert.assertEquals((String)"Mismatched visible chunks", new HashSet<PartitionChunk<OvershadowableInteger>>(this.expectedVisibleChunks), (Object)Sets.newHashSet((Iterator)this.manager.visibleChunksIterator()));
        Assert.assertEquals((String)"Mismatched overshadowed chunks", new HashSet<PartitionChunk<OvershadowableInteger>>(this.expectedOvershadowedChunks), new HashSet(this.manager.getOvershadowedChunks()));
        Assert.assertEquals((String)"Mismatched standby chunks", new HashSet<PartitionChunk<OvershadowableInteger>>(this.expectedStandbyChunks), new HashSet(this.manager.getStandbyChunks()));
    }

    private List<PartitionChunk<OvershadowableInteger>> newNonRootChunks(int n, int startPartitionId, int endPartitionId, int minorVersion, int atomicUpdateGroupSize) {
        return IntStream.range(0, n).mapToObj(i -> this.newNonRootChunk(startPartitionId, endPartitionId, minorVersion, atomicUpdateGroupSize)).collect(Collectors.toList());
    }

    private NumberedPartitionChunk<OvershadowableInteger> newRootChunk() {
        int partitionId = this.nextRootPartitionId();
        return new NumberedPartitionChunk(partitionId, 0, (Object)new OvershadowableInteger(MAJOR_VERSION, partitionId, 0));
    }

    private NumberedOverwritingPartitionChunk<OvershadowableInteger> newNonRootChunk(int startRootPartitionId, int endRootPartitionId, int minorVersion, int atomicUpdateGroupSize) {
        int partitionId = this.nextNonRootPartitionId();
        return new NumberedOverwritingPartitionChunk(partitionId, (Object)new OvershadowableInteger(MAJOR_VERSION, partitionId, 0, startRootPartitionId, endRootPartitionId, minorVersion, atomicUpdateGroupSize));
    }

    private int nextRootPartitionId() {
        return this.nextRootPartitionId++;
    }

    private int nextNonRootPartitionId() {
        return this.nextNonRootPartitionId++;
    }
}

