/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.timeline.partition;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.InjectableValues;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.jsontype.NamedType;
import com.google.common.collect.ImmutableList;
import java.util.List;
import nl.jqno.equalsverifier.EqualsVerifier;
import org.apache.druid.timeline.partition.BuildingHashBasedNumberedShardSpec;
import org.apache.druid.timeline.partition.HashBasedNumberedShardSpec;
import org.apache.druid.timeline.partition.HashPartitionFunction;
import org.apache.druid.timeline.partition.NumberedPartitionChunk;
import org.apache.druid.timeline.partition.ShardSpec;
import org.apache.druid.timeline.partition.ShardSpecTestUtils;
import org.junit.Assert;
import org.junit.Test;

public class BuildingHashBasedNumberedShardSpecTest {
    private final ObjectMapper mapper = ShardSpecTestUtils.initObjectMapper();

    @Test
    public void testConvert() {
        Assert.assertEquals((Object)new HashBasedNumberedShardSpec(5, 10, Integer.valueOf(5), Integer.valueOf(12), (List)ImmutableList.of((Object)"dim"), HashPartitionFunction.MURMUR3_32_ABS, this.mapper), (Object)new BuildingHashBasedNumberedShardSpec(5, 5, 12, (List)ImmutableList.of((Object)"dim"), HashPartitionFunction.MURMUR3_32_ABS, this.mapper).convert(10));
    }

    @Test
    public void testCreateChunk() {
        Assert.assertEquals((Object)new NumberedPartitionChunk(5, 0, (Object)"test"), (Object)new BuildingHashBasedNumberedShardSpec(5, 5, 12, (List)ImmutableList.of((Object)"dim"), HashPartitionFunction.MURMUR3_32_ABS, this.mapper).createChunk((Object)"test"));
    }

    @Test
    public void testSerde() throws JsonProcessingException {
        this.mapper.registerSubtypes(new NamedType[]{new NamedType(BuildingHashBasedNumberedShardSpec.class, "building_hashed")});
        this.mapper.setInjectableValues((InjectableValues)new InjectableValues.Std().addValue(ObjectMapper.class, (Object)this.mapper));
        BuildingHashBasedNumberedShardSpec original = new BuildingHashBasedNumberedShardSpec(3, 5, 12, (List)ImmutableList.of((Object)"dim"), HashPartitionFunction.MURMUR3_32_ABS, this.mapper);
        String json = this.mapper.writeValueAsString((Object)original);
        ShardSpec shardSpec = (ShardSpec)this.mapper.readValue(json, ShardSpec.class);
        Assert.assertEquals((Object)"building_hashed", (Object)shardSpec.getType());
        BuildingHashBasedNumberedShardSpec fromJson = (BuildingHashBasedNumberedShardSpec)shardSpec;
        Assert.assertEquals((Object)original, (Object)fromJson);
    }

    @Test
    public void testEquals() {
        EqualsVerifier.forClass(BuildingHashBasedNumberedShardSpec.class).withIgnoredFields(new String[]{"jsonMapper"}).withPrefabValues(ObjectMapper.class, (Object)new ObjectMapper(), (Object)new ObjectMapper()).usingGetClass().verify();
    }
}

