/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.storage.local;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.UUID;
import org.apache.druid.java.util.common.IAE;
import org.apache.druid.storage.StorageConnector;
import org.apache.druid.storage.local.LocalFileStorageConnectorProvider;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.junit.rules.TemporaryFolder;

public class LocalFileStorageConnectorTest {
    @Rule
    public TemporaryFolder temporaryFolder = new TemporaryFolder();
    @Rule
    public ExpectedException expectedException = ExpectedException.none();
    private File storageDir;
    private StorageConnector storageConnector;

    @Before
    public void init() throws IOException {
        this.storageDir = this.temporaryFolder.newFolder();
        this.storageConnector = new LocalFileStorageConnectorProvider(this.storageDir).createStorageConnector(null);
    }

    @Test
    public void sanityCheck() throws IOException {
        String uuid = UUID.randomUUID().toString();
        this.createAndPopulateFile(uuid);
        Assert.assertTrue((boolean)this.storageConnector.pathExists(uuid));
        Assert.assertTrue((boolean)new File(this.storageDir.getAbsolutePath(), uuid).exists());
        this.checkContents(uuid);
        this.storageConnector.deleteFile(uuid);
        Assert.assertFalse((boolean)new File(this.storageDir.getAbsolutePath(), uuid).exists());
    }

    @Test
    public void deleteRecursivelyTest() throws IOException {
        String topLevelDir = "top" + String.valueOf(UUID.randomUUID());
        String uuid_base = topLevelDir + "/" + String.valueOf(UUID.randomUUID());
        String uuid1 = uuid_base + "/" + String.valueOf(UUID.randomUUID());
        String uuid2 = uuid_base + "/" + String.valueOf(UUID.randomUUID());
        this.createAndPopulateFile(uuid1);
        this.createAndPopulateFile(uuid2);
        Assert.assertTrue((boolean)this.storageConnector.pathExists(uuid1));
        Assert.assertTrue((boolean)this.storageConnector.pathExists(uuid2));
        this.checkContents(uuid1);
        this.checkContents(uuid2);
        File baseFile = new File(this.storageDir.getAbsolutePath(), uuid_base);
        Assert.assertTrue((boolean)baseFile.exists());
        Assert.assertTrue((boolean)baseFile.isDirectory());
        Assert.assertEquals((long)2L, (long)baseFile.listFiles().length);
        this.storageConnector.deleteRecursively(uuid_base);
        Assert.assertFalse((boolean)baseFile.exists());
        Assert.assertTrue((boolean)new File(this.storageDir.getAbsolutePath(), topLevelDir).exists());
    }

    @Test
    public void batchDelete() throws IOException {
        String uuid1 = UUID.randomUUID().toString();
        String uuid2 = UUID.randomUUID().toString();
        this.createAndPopulateFile(uuid1);
        this.createAndPopulateFile(uuid2);
        this.storageConnector.deleteFiles((Iterable)ImmutableList.of((Object)uuid1, (Object)uuid2));
        Assert.assertFalse((boolean)new File(this.storageDir.getAbsolutePath(), uuid1).exists());
        Assert.assertFalse((boolean)new File(this.storageDir.getAbsolutePath(), uuid2).exists());
    }

    @Test
    public void incorrectBasePath() throws IOException {
        File file = this.temporaryFolder.newFile();
        this.expectedException.expect(IAE.class);
        LocalFileStorageConnectorProvider storageConnectorProvider = new LocalFileStorageConnectorProvider(file);
        storageConnectorProvider.createStorageConnector(null);
    }

    @Test
    public void listFilesTest() throws Exception {
        String topLevelDir = "top" + String.valueOf(UUID.randomUUID());
        String uuid_base = topLevelDir + "/" + String.valueOf(UUID.randomUUID());
        String uuid1 = uuid_base + "/" + String.valueOf(UUID.randomUUID());
        String uuid2 = uuid_base + "/" + String.valueOf(UUID.randomUUID());
        this.createAndPopulateFile(uuid1);
        this.createAndPopulateFile(uuid2);
        ArrayList topLevelDirContents = Lists.newArrayList((Iterator)this.storageConnector.listDir(topLevelDir));
        ImmutableList expectedTopLevelDirContents = ImmutableList.of((Object)new File(uuid_base).getName());
        Assert.assertEquals((Object)expectedTopLevelDirContents, (Object)topLevelDirContents);
        HashSet nextLevelDirContents = Sets.newHashSet((Iterator)this.storageConnector.listDir(uuid_base));
        ImmutableSet expectedNextLevelDirContents = ImmutableSet.of((Object)new File(uuid1).getName(), (Object)new File(uuid2).getName());
        Assert.assertEquals((Object)expectedNextLevelDirContents, (Object)nextLevelDirContents);
        Assert.assertThrows(IAE.class, () -> this.storageConnector.listDir("unknown_top_path"));
        Assert.assertThrows(IAE.class, () -> this.storageConnector.listDir(uuid1));
    }

    @Test
    public void testReadRange() throws Exception {
        String uuid = UUID.randomUUID().toString();
        String data = "Hello";
        try (OutputStream outputStream = this.storageConnector.write(uuid);){
            outputStream.write(data.getBytes(StandardCharsets.UTF_8));
        }
        for (int start = 0; start < data.length(); ++start) {
            for (int length = 1; length <= data.length() - start; ++length) {
                InputStream is = this.storageConnector.readRange(uuid, (long)start, (long)length);
                byte[] dataBytes = new byte[length];
                Assert.assertEquals((long)is.read(dataBytes), (long)length);
                Assert.assertEquals((long)is.read(), (long)-1L);
                Assert.assertEquals((Object)data.substring(start, start + length), (Object)new String(dataBytes, StandardCharsets.UTF_8));
            }
        }
        InputStream is = this.storageConnector.readRange(uuid, 0L, 0L);
        byte[] dataBytes = new byte[]{};
        Assert.assertEquals((long)is.read(dataBytes), (long)-1L);
        Assert.assertEquals((Object)data.substring(0, 0), (Object)new String(dataBytes, StandardCharsets.UTF_8));
    }

    private void checkContents(String uuid) throws IOException {
        try (InputStream inputStream = this.storageConnector.read(uuid);){
            Assert.assertEquals((long)1L, (long)inputStream.read());
            Assert.assertEquals((long)0L, (long)inputStream.available());
        }
    }

    private void createAndPopulateFile(String uuid) throws IOException {
        try (OutputStream os = this.storageConnector.write(uuid);){
            os.write(1);
        }
    }
}

