/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.writeout;

import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import org.apache.druid.java.util.common.IAE;
import org.apache.druid.java.util.common.io.Closer;
import org.apache.druid.segment.writeout.FileWriteOutBytes;
import org.easymock.EasyMock;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class FileWriteOutBytesTest {
    private FileWriteOutBytes fileWriteOutBytes;
    private FileChannel mockFileChannel;
    private File mockFile;

    @Before
    public void setUp() {
        this.mockFileChannel = (FileChannel)EasyMock.mock(FileChannel.class);
        this.mockFile = (File)EasyMock.mock(File.class);
        this.fileWriteOutBytes = new FileWriteOutBytes(this.mockFile, this.mockFileChannel, Closer.create());
    }

    @Test
    public void write32KiBIntsShouldNotFlush() throws IOException {
        EasyMock.expect((Object)this.mockFileChannel.write((ByteBuffer)EasyMock.anyObject(ByteBuffer.class))).andAnswer(() -> {
            ByteBuffer buffer = (ByteBuffer)EasyMock.getCurrentArguments()[0];
            int remaining = buffer.remaining();
            buffer.position(remaining);
            return remaining;
        }).times(1);
        EasyMock.replay((Object[])new Object[]{this.mockFileChannel});
        int writeBytes = 32768;
        int numOfInt = 8192;
        for (int i = 0; i < 8192; ++i) {
            this.fileWriteOutBytes.writeInt(i);
        }
        this.fileWriteOutBytes.write(1);
        EasyMock.verify((Object[])new Object[]{this.mockFileChannel});
    }

    @Test
    public void writeShouldIncrementSize() throws IOException {
        this.fileWriteOutBytes.write(1);
        Assert.assertEquals((long)1L, (long)this.fileWriteOutBytes.size());
    }

    @Test
    public void writeIntShouldIncrementSize() throws IOException {
        this.fileWriteOutBytes.writeInt(1);
        Assert.assertEquals((long)4L, (long)this.fileWriteOutBytes.size());
    }

    @Test
    public void writeBufferLargerThanCapacityShouldIncrementSizeCorrectly() throws IOException {
        EasyMock.expect((Object)this.mockFileChannel.write((ByteBuffer)EasyMock.anyObject(ByteBuffer.class))).andAnswer(() -> {
            ByteBuffer buffer = (ByteBuffer)EasyMock.getCurrentArguments()[0];
            int remaining = buffer.remaining();
            buffer.position(remaining);
            return remaining;
        }).times(1);
        EasyMock.replay((Object[])new Object[]{this.mockFileChannel});
        ByteBuffer src = ByteBuffer.allocate(32769);
        this.fileWriteOutBytes.write(src);
        Assert.assertEquals((long)src.capacity(), (long)this.fileWriteOutBytes.size());
        EasyMock.verify((Object[])new Object[]{this.mockFileChannel});
    }

    @Test
    public void writeBufferLargerThanCapacityWritesDirectlyToFileShouldIncrementSizeCorrectly() throws IOException {
        EasyMock.expect((Object)this.mockFileChannel.write((ByteBuffer)EasyMock.anyObject(ByteBuffer.class))).andAnswer(() -> {
            ByteBuffer buffer = (ByteBuffer)EasyMock.getCurrentArguments()[0];
            int remaining = buffer.remaining();
            buffer.position(remaining);
            return remaining;
        }).once();
        EasyMock.replay((Object[])new Object[]{this.mockFileChannel});
        ByteBuffer src = ByteBuffer.allocate(65537);
        this.fileWriteOutBytes.write(src);
        Assert.assertEquals((long)65537L, (long)this.fileWriteOutBytes.size());
    }

    @Test
    public void writeBufferSmallerThanCapacityShouldIncrementSizeCorrectly() throws IOException {
        ByteBuffer src = ByteBuffer.allocate(32768);
        this.fileWriteOutBytes.write(src);
        Assert.assertEquals((long)src.capacity(), (long)this.fileWriteOutBytes.size());
    }

    @Test
    public void sizeDoesNotFlush() throws IOException {
        EasyMock.expect((Object)this.mockFileChannel.write((ByteBuffer)EasyMock.anyObject(ByteBuffer.class))).andThrow((Throwable)((Object)new AssertionError((Object)"file channel should not have been written to.")));
        EasyMock.replay((Object[])new Object[]{this.mockFileChannel});
        long size = this.fileWriteOutBytes.size();
        Assert.assertEquals((long)0L, (long)size);
        this.fileWriteOutBytes.writeInt(10);
        size = this.fileWriteOutBytes.size();
        Assert.assertEquals((long)4L, (long)size);
    }

    @Test
    public void testReadFullyWorks() throws IOException {
        int fileSize = 32768;
        int numOfInt = fileSize / 4;
        ByteBuffer destination = ByteBuffer.allocate(4);
        ByteBuffer underlying = ByteBuffer.allocate(fileSize);
        EasyMock.expect((Object)this.mockFileChannel.write((ByteBuffer)EasyMock.anyObject(ByteBuffer.class))).andAnswer(() -> {
            ByteBuffer buffer = (ByteBuffer)EasyMock.getCurrentArguments()[0];
            underlying.position(0);
            underlying.put(buffer);
            return 0;
        }).times(1);
        EasyMock.expect((Object)this.mockFileChannel.read((ByteBuffer)EasyMock.eq((Object)destination), EasyMock.eq((long)400L))).andAnswer(() -> {
            ByteBuffer buffer = (ByteBuffer)EasyMock.getCurrentArguments()[0];
            long pos = (Long)EasyMock.getCurrentArguments()[1];
            buffer.putInt(underlying.getInt((int)pos));
            return 4;
        }).times(1);
        EasyMock.replay((Object[])new Object[]{this.mockFileChannel});
        for (int i = 0; i < numOfInt; ++i) {
            this.fileWriteOutBytes.writeInt(i);
        }
        Assert.assertEquals((long)underlying.capacity(), (long)this.fileWriteOutBytes.size());
        destination.position(0);
        this.fileWriteOutBytes.readFully(400L, destination);
        destination.position(0);
        Assert.assertEquals((long)100L, (long)destination.getInt());
        EasyMock.verify((Object[])new Object[]{this.mockFileChannel});
    }

    @Test
    public void testReadFullyOutOfBoundsDoesnt() throws IOException {
        int fileSize = 32768;
        int numOfInt = fileSize / 4;
        ByteBuffer destination = ByteBuffer.allocate(4);
        EasyMock.replay((Object[])new Object[]{this.mockFileChannel});
        for (int i = 0; i < numOfInt; ++i) {
            this.fileWriteOutBytes.writeInt(i);
        }
        Assert.assertEquals((long)fileSize, (long)this.fileWriteOutBytes.size());
        destination.position(0);
        Assert.assertThrows(IAE.class, () -> this.fileWriteOutBytes.readFully(33000L, destination));
        EasyMock.verify((Object[])new Object[]{this.mockFileChannel});
    }

    @Test
    public void testIOExceptionHasFileInfo() throws Exception {
        IOException cause = new IOException("Too many bytes");
        EasyMock.expect((Object)this.mockFileChannel.write((ByteBuffer)EasyMock.anyObject(ByteBuffer.class))).andThrow((Throwable)cause);
        EasyMock.expect((Object)this.mockFile.getAbsolutePath()).andReturn((Object)"/tmp/file");
        EasyMock.replay((Object[])new Object[]{this.mockFileChannel, this.mockFile});
        this.fileWriteOutBytes.writeInt(10);
        this.fileWriteOutBytes.write(new byte[30]);
        IOException actual = (IOException)Assert.assertThrows(IOException.class, () -> this.fileWriteOutBytes.flush());
        Assert.assertEquals((String)String.valueOf(actual.getCause()), (Object)actual.getCause(), (Object)cause);
        Assert.assertEquals((String)actual.getMessage(), (Object)actual.getMessage(), (Object)"Failed to write to file: /tmp/file. Current size of file: 34");
    }
}

