/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.vector;

import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Set;
import org.apache.druid.collections.IntSetTestUtility;
import org.apache.druid.collections.bitmap.ImmutableBitmap;
import org.apache.druid.collections.bitmap.MutableBitmap;
import org.apache.druid.collections.bitmap.WrappedBitSetBitmap;
import org.apache.druid.collections.bitmap.WrappedConciseBitmap;
import org.apache.druid.collections.bitmap.WrappedImmutableConciseBitmap;
import org.apache.druid.collections.bitmap.WrappedRoaringBitmap;
import org.apache.druid.extendedset.intset.ConciseSet;
import org.apache.druid.extendedset.intset.ImmutableConciseSet;
import org.apache.druid.segment.vector.BitmapVectorOffset;
import org.apache.druid.segment.vector.NoFilterVectorOffset;
import org.apache.druid.segment.vector.ReadableVectorOffset;
import org.apache.druid.segment.vector.VectorSelectorUtils;
import org.junit.Assert;
import org.junit.Test;
import org.roaringbitmap.PeekableIntIterator;

public class VectorSelectorUtilsTest {
    private static final Set<Integer> NULLS = IntSetTestUtility.getSetBits();
    private static final Set<Integer> NULLS_PATTERN = VectorSelectorUtilsTest.alternatngPattern(10, 12);

    @Test
    public void testBitSetNullVector() {
        WrappedBitSetBitmap bitmap = new WrappedBitSetBitmap();
        VectorSelectorUtilsTest.populate((MutableBitmap)bitmap, NULLS);
        this.assertNullVector((ImmutableBitmap)bitmap, NULLS);
        WrappedBitSetBitmap bitmap2 = new WrappedBitSetBitmap();
        VectorSelectorUtilsTest.populate((MutableBitmap)bitmap2, NULLS_PATTERN);
        this.assertNullVector((ImmutableBitmap)bitmap2, NULLS_PATTERN);
    }

    @Test
    public void testConciseMutableNullVector() {
        WrappedConciseBitmap bitmap = new WrappedConciseBitmap();
        VectorSelectorUtilsTest.populate((MutableBitmap)bitmap, NULLS);
        this.assertNullVector((ImmutableBitmap)bitmap, NULLS);
        WrappedConciseBitmap bitmap2 = new WrappedConciseBitmap();
        VectorSelectorUtilsTest.populate((MutableBitmap)bitmap2, NULLS_PATTERN);
        this.assertNullVector((ImmutableBitmap)bitmap2, NULLS_PATTERN);
    }

    @Test
    public void testConciseImmutableNullVector() {
        WrappedConciseBitmap bitmap = new WrappedConciseBitmap();
        VectorSelectorUtilsTest.populate((MutableBitmap)bitmap, NULLS);
        WrappedImmutableConciseBitmap immutable = new WrappedImmutableConciseBitmap(ImmutableConciseSet.newImmutableFromMutable((ConciseSet)bitmap.getBitmap()));
        this.assertNullVector((ImmutableBitmap)immutable, NULLS);
        WrappedConciseBitmap bitmap2 = new WrappedConciseBitmap();
        VectorSelectorUtilsTest.populate((MutableBitmap)bitmap2, NULLS_PATTERN);
        WrappedImmutableConciseBitmap immutable2 = new WrappedImmutableConciseBitmap(ImmutableConciseSet.newImmutableFromMutable((ConciseSet)bitmap2.getBitmap()));
        this.assertNullVector((ImmutableBitmap)immutable2, NULLS_PATTERN);
    }

    @Test
    public void testRoaringMutableNullVector() {
        WrappedRoaringBitmap bitmap = new WrappedRoaringBitmap();
        VectorSelectorUtilsTest.populate((MutableBitmap)bitmap, NULLS);
        this.assertNullVector((ImmutableBitmap)bitmap, NULLS);
        WrappedRoaringBitmap bitmap2 = new WrappedRoaringBitmap();
        VectorSelectorUtilsTest.populate((MutableBitmap)bitmap2, NULLS_PATTERN);
        this.assertNullVector((ImmutableBitmap)bitmap2, NULLS_PATTERN);
    }

    @Test
    public void testRoaringImmutableNullVector() {
        WrappedRoaringBitmap bitmap = new WrappedRoaringBitmap();
        VectorSelectorUtilsTest.populate((MutableBitmap)bitmap, NULLS);
        this.assertNullVector(bitmap.toImmutableBitmap(), NULLS);
        WrappedRoaringBitmap bitmap2 = new WrappedRoaringBitmap();
        VectorSelectorUtilsTest.populate((MutableBitmap)bitmap2, NULLS_PATTERN);
        this.assertNullVector(bitmap2.toImmutableBitmap(), NULLS_PATTERN);
    }

    public static void populate(MutableBitmap bitmap, Set<Integer> setBits) {
        for (int i : setBits) {
            bitmap.add(i);
        }
    }

    private static Set<Integer> alternatngPattern(int smallSize, int rowCount) {
        ArrayList<Integer> bits = new ArrayList<Integer>();
        boolean flipped = true;
        for (int i = 0; i < rowCount; ++i) {
            if (i > 0 && i % smallSize == 0) {
                boolean bl = flipped = !flipped;
            }
            if (!flipped) continue;
            bits.add(i);
        }
        return Sets.newTreeSet(bits);
    }

    private void assertNullVector(ImmutableBitmap bitmap, Set<Integer> nulls) {
        PeekableIntIterator iterator = bitmap.peekableIterator();
        int vectorSize = 32;
        boolean[] nullVector = new boolean[32];
        NoFilterVectorOffset someOffset = new NoFilterVectorOffset(32, 0, 32);
        VectorSelectorUtils.populateNullVector((boolean[])nullVector, (ReadableVectorOffset)someOffset, (PeekableIntIterator)iterator);
        for (int i = 0; i < 32; ++i) {
            Assert.assertEquals((Object)nulls.contains(i), (Object)nullVector[i]);
        }
        iterator = bitmap.peekableIterator();
        int smallerVectorSize = 8;
        boolean[] smallVector = null;
        for (int offset = 0; offset < 32; offset += 8) {
            NoFilterVectorOffset smallOffset = new NoFilterVectorOffset(8, offset, offset + 8);
            smallVector = VectorSelectorUtils.populateNullVector(smallVector, (ReadableVectorOffset)smallOffset, (PeekableIntIterator)iterator);
            for (int i = 0; i < 8; ++i) {
                if (smallVector == null) {
                    Assert.assertFalse((boolean)nulls.contains(offset + i));
                    continue;
                }
                Assert.assertEquals((Object)nulls.contains(offset + i), (Object)smallVector[i]);
            }
        }
        iterator = bitmap.peekableIterator();
        BitmapVectorOffset allTheNulls = new BitmapVectorOffset(nulls.size(), bitmap, 0, 32);
        smallVector = VectorSelectorUtils.populateNullVector((boolean[])smallVector, (ReadableVectorOffset)allTheNulls, (PeekableIntIterator)iterator);
        for (int i = 0; i < nulls.size(); ++i) {
            Assert.assertTrue((boolean)smallVector[i]);
        }
    }
}

