/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.serde.cell;

import com.google.common.primitives.Ints;
import java.nio.ByteBuffer;
import java.nio.channels.WritableByteChannel;
import java.util.List;
import org.apache.druid.segment.serde.cell.ByteWriterTestHelper;
import org.apache.druid.segment.serde.cell.BytesReadWriteTest;
import org.apache.druid.segment.serde.cell.BytesReadWriteTestBase;
import org.apache.druid.segment.serde.cell.BytesReadWriteTestCases;
import org.apache.druid.segment.serde.cell.CellReader;
import org.apache.druid.segment.serde.cell.CellWriter;
import org.apache.druid.segment.serde.cell.CellWriterToBytesWriter;
import org.apache.druid.segment.serde.cell.TestCaseResult;
import org.apache.druid.segment.writeout.HeapByteBufferWriteOutBytes;
import org.apache.druid.segment.writeout.OnHeapMemorySegmentWriteOutMedium;
import org.apache.druid.segment.writeout.SegmentWriteOutMedium;
import org.junit.Assert;
import org.junit.Test;

public class CellWriterReaderTest
extends BytesReadWriteTestBase {
    public CellWriterReaderTest() {
        super(new CellWriterToBytesWriter.Builder(new CellWriter.Builder((SegmentWriteOutMedium)new OnHeapMemorySegmentWriteOutMedium())), ByteWriterTestHelper.ValidationFunctionBuilder.CELL_READER_VALIDATION_FUNCTION_FACTORY, new BytesReadWriteTestCases().setTestCaseValue(BytesReadWriteTest::testSingleLong, TestCaseResult.of(62)).setTestCaseValue(BytesReadWriteTest::testEmptyByteArray, TestCaseResult.of(46)).setTestCaseValue(BytesReadWriteTest::testNull, TestCaseResult.of(46)).setTestCaseValue(BytesReadWriteTest::testSingleWriteBytes, TestCaseResult.of(4151)).setTestCaseValue(BytesReadWriteTest::testSingleMultiBlockWriteBytes, TestCaseResult.of(1049204)).setTestCaseValue(BytesReadWriteTest::testSingleMultiBlockWriteBytesWithPrelude, TestCaseResult.of(1053277)).setTestCaseValue(BytesReadWriteTest::testVariableSizedCompressablePayloads, TestCaseResult.of(1655)).setTestCaseValue(BytesReadWriteTest::testOutliersInNormalDataCompressablePayloads, TestCaseResult.of(7368)).setTestCaseValue(BytesReadWriteTest::testOutliersInNormalDataUncompressablePayloads, TestCaseResult.of(575673)).setTestCaseValue(BytesReadWriteTest::testSingleUncompressableBlock, TestCaseResult.of(65750)).setTestCaseValue(BytesReadWriteTest::testSingleWriteByteBufferZSTD, TestCaseResult.of(845)).setTestCaseValue(BytesReadWriteTest::testSingleWriteByteBufferAlternateByteBufferProvider, TestCaseResult.of(1552)).setTestCaseValue(BytesReadWriteTest::testRandomBlockAccess, TestCaseResult.of(3126618)));
    }

    @Test
    public void testBasic() throws Exception {
        long size;
        List<ByteBuffer> byteBufferList = this.getTestHelper().generateRaggedPayloadBuffer(500, 2048, 25, 65536, 2, 10240);
        HeapByteBufferWriteOutBytes writableChannel = new HeapByteBufferWriteOutBytes();
        try (CellWriter cellWriter = CellWriter.builder((SegmentWriteOutMedium)new OnHeapMemorySegmentWriteOutMedium()).build();){
            for (ByteBuffer byteBuffer : byteBufferList) {
                cellWriter.write(byteBuffer);
            }
            cellWriter.close();
            cellWriter.writeTo((WritableByteChannel)writableChannel, null);
            size = cellWriter.getSerializedSize();
        }
        ByteBuffer storedByteBuffer = ByteBuffer.allocate(Ints.checkedCast((long)size));
        writableChannel.readFully(0L, storedByteBuffer);
        storedByteBuffer.flip();
        try (CellReader cellReader = CellReader.builder((ByteBuffer)storedByteBuffer).build();){
            for (int i = 0; i < byteBufferList.size(); ++i) {
                ByteBuffer buffer = byteBufferList.get(i);
                ByteBuffer readCell = cellReader.getCell(i);
                Assert.assertEquals((Object)buffer, (Object)readCell);
            }
        }
    }
}

