/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.serde.cell;

import com.google.common.primitives.Ints;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.WritableByteChannel;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import javax.annotation.Nonnull;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.segment.data.CompressionStrategy;
import org.apache.druid.segment.serde.cell.BlockCompressedPayloadReader;
import org.apache.druid.segment.serde.cell.ByteBufferProvider;
import org.apache.druid.segment.serde.cell.BytesWriter;
import org.apache.druid.segment.serde.cell.BytesWriterBuilder;
import org.apache.druid.segment.serde.cell.CellReader;
import org.apache.druid.segment.serde.cell.NativeClearedByteBufferProvider;
import org.apache.druid.segment.serde.cell.PayloadEntrySpan;
import org.apache.druid.segment.writeout.HeapByteBufferWriteOutBytes;
import org.junit.Assert;

public class ByteWriterTestHelper {
    private static final ByteBuffer EMPTY_BYTE_BUFFER = ByteBuffer.wrap(new byte[0]);
    private final BytesWriterBuilder bytesWriterBuilder;
    private final ValidationFunctionBuilder validationFunctionBuilder;
    private CompressionStrategy compressionStrategy = CompressionStrategy.LZ4;
    private ByteBufferProvider byteBufferProvider = NativeClearedByteBufferProvider.INSTANCE;

    public ByteWriterTestHelper(BytesWriterBuilder bytesWriterBuilder, ValidationFunctionBuilder validationFunctionBuilder) {
        this.bytesWriterBuilder = bytesWriterBuilder;
        this.validationFunctionBuilder = validationFunctionBuilder;
    }

    public ByteWriterTestHelper setCompressionStrategy(CompressionStrategy compressionStrategy) {
        this.compressionStrategy = compressionStrategy;
        this.bytesWriterBuilder.setCompressionStrategy(compressionStrategy);
        return this;
    }

    public ByteWriterTestHelper setByteBufferProvider(ByteBufferProvider byteBufferProvider) {
        this.byteBufferProvider = byteBufferProvider;
        this.bytesWriterBuilder.setByteBufferProvider(byteBufferProvider);
        return this;
    }

    public ByteBuffer writePayloadAsByteArray(ByteBuffer payload) throws IOException {
        return this.writePayload(payload, BufferWriterAsBytes.INSTANCE);
    }

    public ByteBuffer writePayloadAsByteBuffer(ByteBuffer payload) throws IOException {
        return this.writePayload(payload, BufferWriterAsBuffer.INSTANCE);
    }

    public List<ByteBuffer> generateRaggedPayloadBuffer(int baseMin, int baseMax, int stepSize, int largeSize, int largeCount) {
        return this.generateRaggedPayloadBuffer(baseMin, baseMax, stepSize, largeSize, largeCount, Integer.MAX_VALUE);
    }

    public List<ByteBuffer> generateRaggedPayloadBuffer(int baseMin, int baseMax, int stepSize, int largeSize, int largeCount, int modulo) {
        ArrayList<ByteBuffer> byteBufferList = new ArrayList<ByteBuffer>();
        for (int i = baseMin; i < baseMax; i += stepSize) {
            byteBufferList.add(this.generateIntPayloads(baseMin + i, modulo));
        }
        for (int j = 0; j < largeCount; ++j) {
            byteBufferList.add(this.generateIntPayloads(largeSize, modulo));
            for (int i = baseMin; i < baseMax; i += stepSize) {
                byteBufferList.add(this.generateIntPayloads(baseMin + i, modulo));
            }
        }
        return byteBufferList;
    }

    public void validateRead(List<ByteBuffer> byteBufferList) throws Exception {
        ValidationFunction validationFunction = this.validationFunctionBuilder.build(this);
        validationFunction.validateBufferList(byteBufferList);
    }

    public void validateReadAndSize(List<ByteBuffer> byteBufferList, int expectedSize) throws Exception {
        ValidationFunction validationFunction = this.validationFunctionBuilder.build(this);
        ByteBuffer masterByteBuffer = validationFunction.validateBufferList(byteBufferList);
        int actualSize = masterByteBuffer.limit();
        if (expectedSize > -1) {
            Assert.assertEquals((long)expectedSize, (long)actualSize);
        }
    }

    public ByteBuffer writePayload(ByteBuffer sourcePayLoad, BufferWriter bufferWriter) throws IOException {
        return this.writePayloadList(Collections.singletonList(sourcePayLoad), bufferWriter);
    }

    public ByteBuffer writePayloadList(List<ByteBuffer> payloadList) throws IOException {
        return this.writePayloadList(payloadList, BufferWriterAsBuffer.INSTANCE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ByteBuffer writePayloadList(List<ByteBuffer> payloadList, BufferWriter bufferWriter) throws IOException {
        try (BytesWriter bytesWriter = this.bytesWriterBuilder.build();){
            for (ByteBuffer payload : payloadList) {
                bufferWriter.writeTo(bytesWriter, payload);
            }
        }
        HeapByteBufferWriteOutBytes bufferWriteOutBytes = new HeapByteBufferWriteOutBytes();
        bytesWriter.transferTo((WritableByteChannel)bufferWriteOutBytes);
        int payloadSerializedSize = Ints.checkedCast((long)bytesWriter.getSerializedSize());
        ByteBuffer masterByteBuffer = ByteBuffer.allocate(payloadSerializedSize).order(ByteOrder.nativeOrder());
        bufferWriteOutBytes.readFully(0L, masterByteBuffer);
        masterByteBuffer.flip();
        Assert.assertEquals((long)bytesWriter.getSerializedSize(), (long)masterByteBuffer.limit());
        return masterByteBuffer;
    }

    public ByteBuffer generateIntPayloads(int intCount) {
        return this.generateIntPayloads(intCount, Integer.MAX_VALUE);
    }

    public ByteBuffer generateIntPayloads(int intCount, int modulo) {
        ByteBuffer payload = ByteBuffer.allocate(4 * intCount).order(ByteOrder.nativeOrder());
        for (int i = intCount - 1; i >= 0; --i) {
            payload.putInt(i % modulo);
        }
        payload.flip();
        return payload;
    }

    @Nonnull
    public ByteBuffer generateBufferWithLongs(int longCount) {
        ByteBuffer longPayload = ByteBuffer.allocate(8 * longCount).order(ByteOrder.nativeOrder());
        for (int i = 0; i < longCount; ++i) {
            longPayload.putLong(longCount - i - 1);
        }
        longPayload.flip();
        return longPayload;
    }

    public ByteBuffer validateBufferWriteAndReadBlockCompressed(List<ByteBuffer> bufferList, boolean useRandom) throws IOException {
        long position = 0L;
        ArrayList<PayloadEntrySpan> payloadReadList = new ArrayList<PayloadEntrySpan>();
        for (ByteBuffer byteBuffer : bufferList) {
            int expectedSize = byteBuffer == null ? 0 : byteBuffer.limit();
            payloadReadList.add(new PayloadEntrySpan(position, expectedSize));
            position += (long)expectedSize;
        }
        ByteBuffer masterByteBuffer = this.writePayloadList(bufferList, new BufferWriterAsBytes());
        return this.readAndValidatePayloads(bufferList, useRandom, payloadReadList, masterByteBuffer);
    }

    @Nonnull
    private ByteBuffer readAndValidatePayloads(List<ByteBuffer> bufferList, boolean useRandom, List<PayloadEntrySpan> payloadReadList, ByteBuffer masterByteBuffer) throws IOException {
        try (BlockCompressedPayloadReader payloadReader = BlockCompressedPayloadReader.create((ByteBuffer)masterByteBuffer, (ByteBufferProvider)this.byteBufferProvider, (CompressionStrategy.Decompressor)this.compressionStrategy.getDecompressor());){
            ArrayList<Integer> positions = new ArrayList<Integer>(bufferList.size());
            for (int i = 0; i < bufferList.size(); ++i) {
                positions.add(i);
            }
            Random random = new Random(0L);
            if (useRandom) {
                Collections.shuffle(positions, random);
            }
            Object object = positions.iterator();
            while (object.hasNext()) {
                int index = (Integer)object.next();
                ByteBuffer expectedByteBuffer = bufferList.get(index);
                PayloadEntrySpan payloadEntrySpan = payloadReadList.get(index);
                ByteBuffer readByteBuffer = payloadReader.read(payloadEntrySpan.getStart(), payloadEntrySpan.getSize());
                if (expectedByteBuffer == null) {
                    Assert.assertEquals((String)StringUtils.format((String)"expected empty buffer %s", (Object[])new Object[]{index}), (Object)EMPTY_BYTE_BUFFER, (Object)readByteBuffer);
                    continue;
                }
                Assert.assertEquals((String)StringUtils.format((String)"failure on buffer %s", (Object[])new Object[]{index}), (Object)expectedByteBuffer, (Object)readByteBuffer);
            }
            object = masterByteBuffer;
            return object;
        }
    }

    public ByteBuffer validateBufferWriteAndReadCells(List<ByteBuffer> bufferList, boolean useRandomRead) throws IOException {
        ByteBuffer masterByteBuffer = this.writePayloadList(bufferList, new BufferWriterAsBytes());
        return this.readAndValidateCells(bufferList, useRandomRead, masterByteBuffer);
    }

    @Nonnull
    private ByteBuffer readAndValidateCells(List<ByteBuffer> bufferList, boolean useRandomRead, ByteBuffer masterByteBuffer) throws IOException {
        try (CellReader cellReader = new CellReader.Builder(masterByteBuffer).setByteBufferProvider(this.byteBufferProvider).setCompressionStrategy(this.compressionStrategy).build();){
            ArrayList<Integer> positions = new ArrayList<Integer>(bufferList.size());
            for (int i = 0; i < bufferList.size(); ++i) {
                positions.add(i);
            }
            Random random = new Random(0L);
            if (useRandomRead) {
                Collections.shuffle(positions, random);
            }
            Object object = positions.iterator();
            while (object.hasNext()) {
                int index = (Integer)object.next();
                ByteBuffer expectedByteBuffer = bufferList.get(index);
                ByteBuffer readByteBuffer = cellReader.getCell(index);
                if (expectedByteBuffer == null) {
                    Assert.assertEquals((String)StringUtils.format((String)"failure on buffer %s", (Object[])new Object[]{index}), (long)0L, (long)readByteBuffer.remaining());
                    continue;
                }
                Assert.assertEquals((String)StringUtils.format((String)"failure on buffer %s", (Object[])new Object[]{index}), (Object)expectedByteBuffer, (Object)readByteBuffer);
            }
            object = masterByteBuffer;
            return object;
        }
    }

    public ByteWriterTestHelper setUseRandomReadOrder(boolean useReadRandom) {
        this.validationFunctionBuilder.setReadRandom(useReadRandom);
        return this;
    }

    public static interface ValidationFunctionBuilder {
        public static final ValidationFunctionBuilder PAYLOAD_WRITER_VALIDATION_FUNCTION_FACTORY = new PayloadWriterValidationFunctionBuilder();
        public static final ValidationFunctionBuilder CELL_READER_VALIDATION_FUNCTION_FACTORY = new CellReaderValidationFunctionBuilder();

        public ValidationFunction build(ByteWriterTestHelper var1);

        public ValidationFunctionBuilder setReadRandom(boolean var1);
    }

    public static class BufferWriterAsBytes
    implements BufferWriter {
        public static final BufferWriterAsBytes INSTANCE = new BufferWriterAsBytes();

        @Override
        public void writeTo(BytesWriter writer, ByteBuffer payload) throws IOException {
            if (payload == null) {
                writer.write((byte[])null);
            } else {
                writer.write(payload.array());
            }
        }
    }

    public static interface BufferWriter {
        public void writeTo(BytesWriter var1, ByteBuffer var2) throws IOException;
    }

    public static class BufferWriterAsBuffer
    implements BufferWriter {
        public static final BufferWriterAsBuffer INSTANCE = new BufferWriterAsBuffer();

        @Override
        public void writeTo(BytesWriter writer, ByteBuffer payload) throws IOException {
            writer.write(payload);
        }
    }

    public static interface ValidationFunction {
        public ByteBuffer validateBufferList(List<ByteBuffer> var1) throws Exception;
    }

    public static class CellReaderValidationFunctionBuilder
    implements ValidationFunctionBuilder {
        private boolean useRandomRead;

        @Override
        public ValidationFunction build(ByteWriterTestHelper testHelper) {
            return bufferList -> testHelper.validateBufferWriteAndReadCells(bufferList, this.useRandomRead);
        }

        @Override
        public ValidationFunctionBuilder setReadRandom(boolean useRandomRead) {
            this.useRandomRead = useRandomRead;
            return this;
        }
    }

    public static class PayloadWriterValidationFunctionBuilder
    implements ValidationFunctionBuilder {
        private boolean useRandomRead;

        @Override
        public ValidationFunctionBuilder setReadRandom(boolean useRandomRead) {
            this.useRandomRead = useRandomRead;
            return this;
        }

        @Override
        public ValidationFunction build(ByteWriterTestHelper testHelper) {
            return bufferList -> testHelper.validateBufferWriteAndReadBlockCompressed(bufferList, this.useRandomRead);
        }
    }
}

