/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.incremental;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.ImmutableList;
import java.util.List;
import nl.jqno.equalsverifier.EqualsVerifier;
import org.apache.druid.data.input.impl.AggregateProjectionSpec;
import org.apache.druid.data.input.impl.DimensionsSpec;
import org.apache.druid.data.input.impl.LongDimensionSchema;
import org.apache.druid.data.input.impl.StringDimensionSchema;
import org.apache.druid.error.DruidException;
import org.apache.druid.query.aggregation.AggregatorFactory;
import org.apache.druid.query.aggregation.DoubleSumAggregatorFactory;
import org.apache.druid.query.aggregation.LongSumAggregatorFactory;
import org.apache.druid.query.expression.TestExprMacroTable;
import org.apache.druid.segment.IndexBuilder;
import org.apache.druid.segment.TestHelper;
import org.apache.druid.segment.VirtualColumn;
import org.apache.druid.segment.VirtualColumns;
import org.apache.druid.segment.column.ColumnType;
import org.apache.druid.segment.incremental.IncrementalIndexSchema;
import org.apache.druid.segment.incremental.OnheapIncrementalIndex;
import org.apache.druid.segment.virtual.ExpressionVirtualColumn;
import org.junit.Assert;
import org.junit.Test;

public class OnheapIncrementalIndexTest {
    private static final ObjectMapper MAPPER = TestHelper.makeJsonMapper();

    @Test
    public void testSpecSerde() throws JsonProcessingException {
        OnheapIncrementalIndex.Spec spec = new OnheapIncrementalIndex.Spec(Boolean.valueOf(true));
        Assert.assertEquals((Object)spec, (Object)MAPPER.readValue(MAPPER.writeValueAsString((Object)spec), OnheapIncrementalIndex.Spec.class));
    }

    @Test
    public void testSpecEqualsAndHashCode() {
        EqualsVerifier.forClass(OnheapIncrementalIndex.Spec.class).usingGetClass().verify();
    }

    @Test
    public void testBadProjectionMismatchedDimensionTypes() {
        Throwable t = Assert.assertThrows(DruidException.class, () -> IndexBuilder.create().schema(IncrementalIndexSchema.builder().withDimensionsSpec(DimensionsSpec.builder().setDimensions((List)ImmutableList.of((Object)new StringDimensionSchema("string"), (Object)new LongDimensionSchema("long"))).build()).withProjections((List)ImmutableList.of((Object)new AggregateProjectionSpec("mismatched dims", VirtualColumns.EMPTY, (List)ImmutableList.of((Object)new LongDimensionSchema("string")), null))).build()).buildIncrementalIndex());
        Assert.assertEquals((Object)"projection[mismatched dims] contains dimension[string] with different type[LONG] than type[STRING] in base table", (Object)t.getMessage());
    }

    @Test
    public void testBadProjectionVirtualColumnNoDimension() {
        Throwable t = Assert.assertThrows(DruidException.class, () -> IndexBuilder.create().schema(IncrementalIndexSchema.builder().withDimensionsSpec(DimensionsSpec.builder().setDimensions((List)ImmutableList.of((Object)new StringDimensionSchema("string"), (Object)new LongDimensionSchema("long"))).build()).withProjections((List)ImmutableList.of((Object)new AggregateProjectionSpec("sad virtual column", VirtualColumns.create((VirtualColumn[])new VirtualColumn[]{new ExpressionVirtualColumn("v0", "double", ColumnType.DOUBLE, TestExprMacroTable.INSTANCE)}), (List)ImmutableList.of((Object)new LongDimensionSchema("long")), null))).build()).buildIncrementalIndex());
        Assert.assertEquals((Object)"projection[sad virtual column] contains virtual column[v0] that references an input[double] which is not a dimension in the base table", (Object)t.getMessage());
    }

    @Test
    public void testBadProjectionRollupMismatchedAggType() {
        Throwable t = Assert.assertThrows(DruidException.class, () -> IndexBuilder.create().schema(IncrementalIndexSchema.builder().withDimensionsSpec(DimensionsSpec.builder().setDimensions((List)ImmutableList.of((Object)new StringDimensionSchema("string"), (Object)new LongDimensionSchema("long"))).build()).withRollup(true).withMetrics(new AggregatorFactory[]{new DoubleSumAggregatorFactory("sum_double", "sum_double")}).withProjections((List)ImmutableList.of((Object)new AggregateProjectionSpec("mismatched agg", VirtualColumns.EMPTY, (List)ImmutableList.of((Object)new StringDimensionSchema("string")), new AggregatorFactory[]{new LongSumAggregatorFactory("sum_double", "sum_double")}))).build()).buildIncrementalIndex());
        Assert.assertEquals((Object)"projection[mismatched agg] contains aggregator[sum_double] that is not the 'combining' aggregator of base table aggregator[sum_double]", (Object)t.getMessage());
    }

    @Test
    public void testBadProjectionRollupBadAggInput() {
        Throwable t = Assert.assertThrows(DruidException.class, () -> IndexBuilder.create().schema(IncrementalIndexSchema.builder().withDimensionsSpec(DimensionsSpec.builder().setDimensions((List)ImmutableList.of((Object)new StringDimensionSchema("string"), (Object)new LongDimensionSchema("long"))).build()).withRollup(true).withMetrics(new AggregatorFactory[]{new DoubleSumAggregatorFactory("double", "double")}).withProjections((List)ImmutableList.of((Object)new AggregateProjectionSpec("renamed agg", VirtualColumns.EMPTY, (List)ImmutableList.of((Object)new StringDimensionSchema("string")), new AggregatorFactory[]{new LongSumAggregatorFactory("sum_long", "long"), new DoubleSumAggregatorFactory("sum_double", "double")}))).build()).buildIncrementalIndex());
        Assert.assertEquals((Object)"projection[renamed agg] contains aggregator[sum_double] that references aggregator[double] in base table but this is not supported, projection aggregators which reference base table aggregates must be 'combining' aggregators with the same name as the base table column", (Object)t.getMessage());
    }

    @Test
    public void testBadProjectionVirtualColumnAggInput() {
        Throwable t = Assert.assertThrows(DruidException.class, () -> IndexBuilder.create().schema(IncrementalIndexSchema.builder().withDimensionsSpec(DimensionsSpec.builder().setDimensions((List)ImmutableList.of((Object)new StringDimensionSchema("string"), (Object)new LongDimensionSchema("long"))).build()).withProjections((List)ImmutableList.of((Object)new AggregateProjectionSpec("sad agg virtual column", VirtualColumns.create((VirtualColumn[])new VirtualColumn[]{new ExpressionVirtualColumn("v0", "long + 100", ColumnType.LONG, TestExprMacroTable.INSTANCE)}), (List)ImmutableList.of((Object)new LongDimensionSchema("long")), new AggregatorFactory[]{new LongSumAggregatorFactory("v0_sum", "v0")}))).build()).buildIncrementalIndex());
        Assert.assertEquals((Object)"projection[sad agg virtual column] contains aggregator[v0_sum] that is has required field[v0] which is a virtual column, this is not yet supported", (Object)t.getMessage());
    }
}

