/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.data;

import com.carrotsearch.junitbenchmarks.AbstractBenchmark;
import com.carrotsearch.junitbenchmarks.BenchmarkOptions;
import com.carrotsearch.junitbenchmarks.Clock;
import com.google.common.collect.ImmutableList;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Random;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.druid.java.util.common.StringUtils;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class BenchmarkIndexibleWrites
extends AbstractBenchmark {
    private final ConcurrentIndexible<Integer> concurrentIndexible;
    private final Integer concurrentThreads = 4;
    private final Integer totalIndexSize = 0x100000;

    @Parameterized.Parameters
    public static Collection<Object[]> getParameters() {
        return ImmutableList.of((Object)new Object[]{new ConcurrentStandardMap()}, (Object)new Object[]{new ConcurrentExpandable()});
    }

    public BenchmarkIndexibleWrites(ConcurrentIndexible<Integer> concurrentIndexible) {
        this.concurrentIndexible = concurrentIndexible;
    }

    @BenchmarkOptions(warmupRounds=100, benchmarkRounds=100, clock=Clock.REAL_TIME, callgc=true)
    @Ignore
    @Test
    public void testConcurrentWrites() throws ExecutionException, InterruptedException {
        int i;
        ListeningExecutorService executorService = MoreExecutors.listeningDecorator((ExecutorService)Executors.newFixedThreadPool(this.concurrentThreads, new ThreadFactoryBuilder().setDaemon(false).setNameFormat("indexible-writes-benchmark-%d").build()));
        final AtomicInteger index = new AtomicInteger(0);
        ArrayList<ListenableFuture> futures = new ArrayList<ListenableFuture>();
        final Integer loops = this.totalIndexSize / this.concurrentThreads;
        for (i = 0; i < this.concurrentThreads; ++i) {
            futures.add(executorService.submit(new Runnable(){

                @Override
                public void run() {
                    for (int i = 0; i < loops; ++i) {
                        Integer idx = index.getAndIncrement();
                        BenchmarkIndexibleWrites.this.concurrentIndexible.set(idx, idx);
                    }
                }
            }));
        }
        Futures.allAsList(futures).get();
        Assert.assertTrue((String)StringUtils.format((String)"Index too small %d, expected %d across %d loops", (Object[])new Object[]{index.get(), this.totalIndexSize, loops}), (index.get() >= this.totalIndexSize ? 1 : 0) != 0);
        for (i = 0; i < index.get(); ++i) {
            Assert.assertEquals((long)i, (long)this.concurrentIndexible.get(i).intValue());
        }
        this.concurrentIndexible.clear();
        futures.clear();
        executorService.shutdown();
    }

    @BenchmarkOptions(warmupRounds=100, benchmarkRounds=100, clock=Clock.REAL_TIME, callgc=true)
    @Ignore
    @Test
    public void testConcurrentReads() throws ExecutionException, InterruptedException {
        int i;
        ListeningExecutorService executorService = MoreExecutors.listeningDecorator((ExecutorService)Executors.newFixedThreadPool(this.concurrentThreads, new ThreadFactoryBuilder().setDaemon(false).setNameFormat("indexible-writes-benchmark-reader-%d").build()));
        AtomicInteger index = new AtomicInteger(0);
        final AtomicInteger queryableIndex = new AtomicInteger(0);
        ArrayList<ListenableFuture> futures = new ArrayList<ListenableFuture>();
        Integer loops = this.totalIndexSize / this.concurrentThreads;
        final AtomicBoolean done = new AtomicBoolean(false);
        final CountDownLatch start = new CountDownLatch(1);
        for (int i2 = 0; i2 < this.concurrentThreads; ++i2) {
            futures.add(executorService.submit(new Runnable(){

                @Override
                public void run() {
                    try {
                        start.await();
                    }
                    catch (InterruptedException e) {
                        throw new RuntimeException(e);
                    }
                    ThreadLocalRandom rndGen = ThreadLocalRandom.current();
                    while (!done.get()) {
                        Integer idx = ((Random)rndGen).nextInt(queryableIndex.get() + 1);
                        Assert.assertEquals((Object)idx, (Object)BenchmarkIndexibleWrites.this.concurrentIndexible.get(idx));
                    }
                }
            }));
        }
        Integer idx = index.getAndIncrement();
        this.concurrentIndexible.set(idx, idx);
        start.countDown();
        for (i = 1; i < this.totalIndexSize; ++i) {
            Integer idx2 = index.getAndIncrement();
            this.concurrentIndexible.set(idx2, idx2);
            queryableIndex.incrementAndGet();
        }
        done.set(true);
        Futures.allAsList(futures).get();
        executorService.shutdown();
        Assert.assertTrue((String)StringUtils.format((String)"Index too small %d, expected %d across %d loops", (Object[])new Object[]{index.get(), this.totalIndexSize, loops}), (index.get() >= this.totalIndexSize ? 1 : 0) != 0);
        for (i = 0; i < index.get(); ++i) {
            Assert.assertEquals((long)i, (long)this.concurrentIndexible.get(i).intValue());
        }
        this.concurrentIndexible.clear();
        futures.clear();
    }

    private static class ConcurrentStandardMap<V>
    implements ConcurrentIndexible<V> {
        private final ConcurrentHashMap<Integer, V> delegate = new ConcurrentHashMap();

        private ConcurrentStandardMap() {
        }

        @Override
        public void set(Integer index, V object) {
            this.delegate.put(index, object);
        }

        @Override
        public V get(Integer index) {
            return this.delegate.get(index);
        }

        @Override
        public void clear() {
            this.delegate.clear();
        }
    }

    private static class ConcurrentExpandable<V>
    implements ConcurrentIndexible<V> {
        private static Integer INIT_SIZE = 1024;
        private final AtomicReference<V[]> reference = new AtomicReference();
        private final AtomicLong resizeCount = new AtomicLong(0L);
        private final Integer initSize;
        private final Object resizeMutex = new Object();

        public ConcurrentExpandable() {
            this(INIT_SIZE);
        }

        public ConcurrentExpandable(Integer initSize) {
            this.reference.set(new Object[initSize.intValue()]);
            this.initSize = initSize;
        }

        @Override
        public V get(Integer index) {
            return this.reference.get()[index];
        }

        @Override
        public void clear() {
            this.reference.set(new Object[this.initSize.intValue()]);
        }

        private static Boolean wasCopying(Long val) {
            return (val & 1L) > 0L;
        }

        @Override
        public void set(Integer index, V object) {
            Long post;
            Long pre;
            this.ensureCapacity(index + 1);
            do {
                pre = this.resizeCount.get();
                this.reference.get()[index.intValue()] = object;
                post = this.resizeCount.get();
            } while (ConcurrentExpandable.wasCopying(pre).booleanValue() || ConcurrentExpandable.wasCopying(post).booleanValue() || !pre.equals(post));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void ensureCapacity(int capacity) {
            Object object = this.resizeMutex;
            synchronized (object) {
                if (this.reference.get().length < capacity) {
                    this.resizeCount.incrementAndGet();
                    this.reference.set(Arrays.copyOf(this.reference.get(), this.reference.get().length << 1));
                    this.resizeCount.incrementAndGet();
                }
            }
        }
    }

    private static interface ConcurrentIndexible<V> {
        public void set(Integer var1, V var2);

        public V get(Integer var1);

        public void clear();
    }
}

