/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment;

import java.util.LinkedHashMap;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.druid.java.util.common.UOE;
import org.apache.druid.segment.ColumnSelector;
import org.apache.druid.segment.column.ColumnCapabilities;
import org.apache.druid.segment.column.ColumnHolder;

public class TestColumnSelector
implements ColumnSelector {
    private final Map<String, ColumnHolder> holders = new LinkedHashMap<String, ColumnHolder>();
    private final Map<String, ColumnCapabilities> capabilitiesMap = new LinkedHashMap<String, ColumnCapabilities>();

    public TestColumnSelector addHolder(String name, ColumnHolder holder) {
        this.holders.put(name, holder);
        return this;
    }

    public TestColumnSelector addCapabilities(String name, ColumnCapabilities capability) {
        this.capabilitiesMap.put(name, capability);
        return this;
    }

    @Nullable
    public ColumnHolder getColumnHolder(String columnName) {
        return this.getFromMap(this.holders, columnName, "holder");
    }

    @Nullable
    public ColumnCapabilities getColumnCapabilities(String column) {
        return this.getFromMap(this.capabilitiesMap, column, "capability");
    }

    private <T> T getFromMap(Map<String, T> map, String key, String name) {
        if (!map.containsKey(key)) {
            throw new UOE("%s[%s] wasn't registered, but was asked for, register first (null is okay)", new Object[]{name, key});
        }
        return map.get(key);
    }
}

