/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment;

import com.google.common.collect.ImmutableList;
import java.io.Closeable;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.druid.collections.BlockingPool;
import org.apache.druid.collections.CloseableDefaultBlockingPool;
import org.apache.druid.collections.CloseableStupidPool;
import org.apache.druid.java.util.common.Intervals;
import org.apache.druid.java.util.common.Pair;
import org.apache.druid.java.util.common.granularity.Granularities;
import org.apache.druid.java.util.common.guava.Sequence;
import org.apache.druid.query.DruidProcessingConfig;
import org.apache.druid.query.Druids;
import org.apache.druid.query.IterableRowsCursorHelper;
import org.apache.druid.query.Result;
import org.apache.druid.query.aggregation.AggregatorFactory;
import org.apache.druid.query.aggregation.CountAggregatorFactory;
import org.apache.druid.query.groupby.GroupByQuery;
import org.apache.druid.query.groupby.GroupByQueryConfig;
import org.apache.druid.query.groupby.GroupByResourcesReservationPool;
import org.apache.druid.query.groupby.GroupByStatsProvider;
import org.apache.druid.query.groupby.GroupingEngine;
import org.apache.druid.query.groupby.ResultRow;
import org.apache.druid.query.timeseries.TimeseriesQuery;
import org.apache.druid.query.timeseries.TimeseriesQueryEngine;
import org.apache.druid.query.timeseries.TimeseriesResultValue;
import org.apache.druid.query.topn.DimensionAndMetricValueExtractor;
import org.apache.druid.query.topn.TopNQuery;
import org.apache.druid.query.topn.TopNQueryBuilder;
import org.apache.druid.query.topn.TopNQueryEngine;
import org.apache.druid.query.topn.TopNResultValue;
import org.apache.druid.segment.CloserRule;
import org.apache.druid.segment.Cursor;
import org.apache.druid.segment.CursorBuildSpec;
import org.apache.druid.segment.CursorFactory;
import org.apache.druid.segment.CursorHolder;
import org.apache.druid.segment.QueryableIndex;
import org.apache.druid.segment.Segment;
import org.apache.druid.segment.TestHelper;
import org.apache.druid.segment.column.ColumnCapabilities;
import org.apache.druid.segment.column.ColumnType;
import org.apache.druid.segment.column.RowSignature;
import org.apache.druid.testing.InitializedNullHandlingTest;
import org.apache.druid.timeline.SegmentId;
import org.apache.druid.utils.CloseableUtils;
import org.joda.time.Interval;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;

public class CursorHolderPreaggTest
extends InitializedNullHandlingTest {
    private CloseableStupidPool<ByteBuffer> bufferPool;
    private GroupingEngine groupingEngine;
    private TopNQueryEngine topNQueryEngine;
    private TimeseriesQueryEngine timeseriesQueryEngine;
    private CursorFactory cursorFactory;
    private Segment segment;
    @Rule
    public final CloserRule closer = new CloserRule(false);

    @Before
    public void setup() {
        this.bufferPool = this.closer.closeLater(new CloseableStupidPool("CursorHolderPreaggTest-bufferPool", () -> ByteBuffer.allocate(50000)));
        this.topNQueryEngine = new TopNQueryEngine(this.bufferPool);
        this.timeseriesQueryEngine = new TimeseriesQueryEngine(this.bufferPool);
        CloseableDefaultBlockingPool mergePool = new CloseableDefaultBlockingPool(() -> ByteBuffer.allocate(50000), 4);
        GroupByStatsProvider groupByStatsProvider = new GroupByStatsProvider();
        this.groupingEngine = new GroupingEngine(new DruidProcessingConfig(), GroupByQueryConfig::new, new GroupByResourcesReservationPool((BlockingPool)this.closer.closeLater(mergePool), new GroupByQueryConfig()), TestHelper.makeJsonMapper(), TestHelper.makeSmileMapper(), (query, future) -> {}, groupByStatsProvider);
        this.cursorFactory = new CursorFactory(){
            private final RowSignature rowSignature = RowSignature.builder().add("a", ColumnType.STRING).add("b", ColumnType.STRING).add("cnt", ColumnType.LONG).build();
            private final Pair<Cursor, Closeable> cursorAndCloser = IterableRowsCursorHelper.getCursorFromIterable((Iterable)ImmutableList.of((Object)new Object[]{"a", "aa", 5L}, (Object)new Object[]{"a", "aa", 6L}, (Object)new Object[]{"b", "bb", 7L}), (RowSignature)this.rowSignature);

            public CursorHolder makeCursorHolder(final CursorBuildSpec spec) {
                return new CursorHolder(){

                    @Nullable
                    public Cursor asCursor() {
                        return (Cursor)cursorAndCloser.lhs;
                    }

                    public boolean isPreAggregated() {
                        return true;
                    }

                    @Nullable
                    public List<AggregatorFactory> getAggregatorsForPreAggregated() {
                        return spec.getAggregators().stream().map(AggregatorFactory::getCombiningFactory).collect(Collectors.toList());
                    }

                    public void close() {
                        CloseableUtils.closeAndWrapExceptions((Closeable)((Closeable)cursorAndCloser.rhs));
                    }
                };
            }

            public RowSignature getRowSignature() {
                return this.rowSignature;
            }

            @Nullable
            public ColumnCapabilities getColumnCapabilities(String column) {
                return this.rowSignature.getColumnCapabilities(column);
            }
        };
        this.segment = new Segment(){

            public SegmentId getId() {
                return SegmentId.dummy((String)"test");
            }

            public Interval getDataInterval() {
                return Intervals.ETERNITY;
            }

            @Nullable
            public QueryableIndex asQueryableIndex() {
                return null;
            }

            public CursorFactory asCursorFactory() {
                return CursorHolderPreaggTest.this.cursorFactory;
            }

            public void close() {
            }
        };
    }

    @Test
    public void testTopn() {
        TopNQuery topNQuery = new TopNQueryBuilder().dataSource("test").granularity(Granularities.ALL).intervals((List)ImmutableList.of((Object)Intervals.ETERNITY)).dimension("a").aggregators(new AggregatorFactory[]{new CountAggregatorFactory("cnt")}).metric("cnt").threshold(10).build();
        Sequence results = this.topNQueryEngine.query(topNQuery, this.segment, null);
        List rows = results.toList();
        Assert.assertEquals((long)1L, (long)rows.size());
        Assert.assertEquals((long)2L, (long)((TopNResultValue)((Result)rows.get(0)).getValue()).getValue().size());
        Assert.assertEquals((long)11L, (long)((DimensionAndMetricValueExtractor)((TopNResultValue)((Result)rows.get(0)).getValue()).getValue().get(0)).getLongMetric("cnt"));
        Assert.assertEquals((long)7L, (long)((DimensionAndMetricValueExtractor)((TopNResultValue)((Result)rows.get(0)).getValue()).getValue().get(1)).getLongMetric("cnt"));
    }

    @Test
    public void testGroupBy() {
        GroupByQuery query = GroupByQuery.builder().setDataSource("test").setGranularity(Granularities.ALL).setInterval(Intervals.ETERNITY).addDimension("a").addDimension("b").addAggregator((AggregatorFactory)new CountAggregatorFactory("cnt")).build();
        Sequence results = this.groupingEngine.process(query, this.cursorFactory, null, this.bufferPool, null);
        List rows = results.toList();
        Assert.assertEquals((long)2L, (long)rows.size());
        Assert.assertArrayEquals((Object[])new Object[]{"a", "aa", 11L}, (Object[])((ResultRow)rows.get(0)).getArray());
        Assert.assertArrayEquals((Object[])new Object[]{"b", "bb", 7L}, (Object[])((ResultRow)rows.get(1)).getArray());
    }

    @Test
    public void testTimeseries() {
        TimeseriesQuery timeseriesQuery = Druids.newTimeseriesQueryBuilder().dataSource("test").intervals((List)ImmutableList.of((Object)Intervals.ETERNITY)).granularity(Granularities.ALL).aggregators(new AggregatorFactory[]{new CountAggregatorFactory("cnt")}).build();
        Sequence results = this.timeseriesQueryEngine.process(timeseriesQuery, this.cursorFactory, null, null);
        List rows = results.toList();
        Assert.assertEquals((long)1L, (long)rows.size());
        Assert.assertEquals((long)18L, (long)((TimeseriesResultValue)((Result)rows.get(0)).getValue()).getLongMetric("cnt"));
    }
}

