/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import it.unimi.dsi.fastutil.objects.ObjectAVLTreeSet;
import java.util.Arrays;
import java.util.Collections;
import nl.jqno.equalsverifier.EqualsVerifier;
import org.apache.druid.error.DruidException;
import org.apache.druid.java.util.common.granularity.Granularities;
import org.apache.druid.java.util.common.granularity.Granularity;
import org.apache.druid.query.OrderBy;
import org.apache.druid.query.aggregation.AggregatorFactory;
import org.apache.druid.query.aggregation.CountAggregatorFactory;
import org.apache.druid.query.aggregation.LongSumAggregatorFactory;
import org.apache.druid.segment.AggregateProjectionMetadata;
import org.apache.druid.segment.TestHelper;
import org.apache.druid.segment.VirtualColumn;
import org.apache.druid.segment.VirtualColumns;
import org.apache.druid.testing.InitializedNullHandlingTest;
import org.junit.Assert;
import org.junit.Test;

public class AggregateProjectionMetadataTest
extends InitializedNullHandlingTest {
    private static final ObjectMapper JSON_MAPPER = TestHelper.makeJsonMapper();

    @Test
    public void testSerde() throws JsonProcessingException {
        AggregateProjectionMetadata spec = new AggregateProjectionMetadata(new AggregateProjectionMetadata.Schema("some_projection", "time", VirtualColumns.create((VirtualColumn[])new VirtualColumn[]{Granularities.toVirtualColumn((Granularity)Granularities.HOUR, (String)"time")}), Arrays.asList("a", "b", "time", "c", "d"), new AggregatorFactory[]{new CountAggregatorFactory("count"), new LongSumAggregatorFactory("e", "e")}, Arrays.asList(OrderBy.ascending((String)"a"), OrderBy.ascending((String)"b"), OrderBy.ascending((String)"time"), OrderBy.ascending((String)"c"), OrderBy.ascending((String)"d"))), 12345);
        Assert.assertEquals((Object)spec, (Object)JSON_MAPPER.readValue(JSON_MAPPER.writeValueAsString((Object)spec), AggregateProjectionMetadata.class));
    }

    @Test
    public void testComparator() {
        ObjectAVLTreeSet metadataBest = new ObjectAVLTreeSet(AggregateProjectionMetadata.COMPARATOR);
        AggregateProjectionMetadata good = new AggregateProjectionMetadata(new AggregateProjectionMetadata.Schema("good", "theTime", VirtualColumns.create((VirtualColumn[])new VirtualColumn[]{Granularities.toVirtualColumn((Granularity)Granularities.HOUR, (String)"theTime")}), Arrays.asList("theTime", "a", "b", "c"), new AggregatorFactory[]{new CountAggregatorFactory("chocula")}, Arrays.asList(OrderBy.ascending((String)"theTime"), OrderBy.ascending((String)"a"), OrderBy.ascending((String)"b"), OrderBy.ascending((String)"c"))), 123);
        AggregateProjectionMetadata better = new AggregateProjectionMetadata(new AggregateProjectionMetadata.Schema("better", "theTime", VirtualColumns.create((VirtualColumn[])new VirtualColumn[]{Granularities.toVirtualColumn((Granularity)Granularities.HOUR, (String)"theTime")}), Arrays.asList("c", "d", "theTime"), new AggregatorFactory[]{new CountAggregatorFactory("chocula"), new LongSumAggregatorFactory("e", "e")}, Arrays.asList(OrderBy.ascending((String)"c"), OrderBy.ascending((String)"d"), OrderBy.ascending((String)"theTime"))), 123);
        AggregateProjectionMetadata best = new AggregateProjectionMetadata(new AggregateProjectionMetadata.Schema("better", null, VirtualColumns.EMPTY, Arrays.asList("f", "g"), new AggregatorFactory[0], Arrays.asList(OrderBy.ascending((String)"f"), OrderBy.ascending((String)"g"))), 10);
        metadataBest.add(good);
        metadataBest.add(better);
        metadataBest.add(best);
        Assert.assertEquals((Object)best, metadataBest.first());
        Assert.assertEquals((Object)good, metadataBest.last());
    }

    @Test
    public void testInvalidGrouping() {
        Throwable t = Assert.assertThrows(DruidException.class, () -> new AggregateProjectionMetadata(new AggregateProjectionMetadata.Schema("other_projection", null, null, null, null, null), 0));
        Assert.assertEquals((Object)"groupingColumns and aggregators must not both be null or empty", (Object)t.getMessage());
        t = Assert.assertThrows(DruidException.class, () -> new AggregateProjectionMetadata(new AggregateProjectionMetadata.Schema("other_projection", null, null, Collections.emptyList(), null, null), 0));
        Assert.assertEquals((Object)"groupingColumns and aggregators must not both be null or empty", (Object)t.getMessage());
    }

    @Test
    public void testEqualsAndHashcode() {
        EqualsVerifier.forClass(AggregateProjectionMetadata.class).usingGetClass().verify();
    }

    @Test
    public void testEqualsAndHashcodeSchema() {
        EqualsVerifier.forClass(AggregateProjectionMetadata.Schema.class).withIgnoredFields(new String[]{"orderingWithTimeSubstitution", "timeColumnPosition", "granularity"}).usingGetClass().verify();
    }
}

