/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.topn;

import com.carrotsearch.junitbenchmarks.AbstractBenchmark;
import com.carrotsearch.junitbenchmarks.BenchmarkOptions;
import com.google.common.base.Supplier;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.druid.collections.NonBlockingPool;
import org.apache.druid.collections.StupidPool;
import org.apache.druid.query.Query;
import org.apache.druid.query.QueryPlus;
import org.apache.druid.query.QueryRunner;
import org.apache.druid.query.QueryRunnerTestHelper;
import org.apache.druid.query.aggregation.DoubleMaxAggregatorFactory;
import org.apache.druid.query.aggregation.DoubleMinAggregatorFactory;
import org.apache.druid.query.aggregation.PostAggregator;
import org.apache.druid.query.aggregation.SimpleDoubleAggregatorFactory;
import org.apache.druid.query.topn.TopNQuery;
import org.apache.druid.query.topn.TopNQueryBuilder;
import org.apache.druid.query.topn.TopNQueryConfig;
import org.apache.druid.query.topn.TopNQueryQueryToolChest;
import org.apache.druid.query.topn.TopNQueryRunnerFactory;
import org.apache.druid.segment.IncrementalIndexSegment;
import org.apache.druid.segment.QueryableIndexSegment;
import org.apache.druid.segment.Segment;
import org.apache.druid.segment.TestIndex;
import org.apache.druid.timeline.SegmentId;
import org.junit.BeforeClass;
import org.junit.Ignore;
import org.junit.Test;

@Ignore
public class TopNQueryRunnerBenchmark
extends AbstractBenchmark {
    private static final String MARKET_DIMENSION = "market";
    private static final SegmentId SEGMENT_ID = SegmentId.dummy((String)"testSegment");
    private static final TopNQuery QUERY = new TopNQueryBuilder().dataSource("testing").granularity(QueryRunnerTestHelper.ALL_GRAN).dimension("market").metric("index").threshold(4).intervals(QueryRunnerTestHelper.FULL_ON_INTERVAL_SPEC).aggregators((List)Lists.newArrayList((Iterable)Iterables.concat(QueryRunnerTestHelper.COMMON_DOUBLE_AGGREGATORS, (Iterable)Lists.newArrayList((Object[])new SimpleDoubleAggregatorFactory[]{new DoubleMaxAggregatorFactory("maxIndex", "index"), new DoubleMinAggregatorFactory("minIndex", "index")})))).postAggregators(new PostAggregator[]{QueryRunnerTestHelper.ADD_ROWS_INDEX_CONSTANT}).build();
    private static final Map<TestCases, QueryRunner> TEST_CASE_MAP = new HashMap<TestCases, QueryRunner>();

    @BeforeClass
    public static void setUp() {
        TopNQueryRunnerFactory factory = new TopNQueryRunnerFactory((NonBlockingPool)new StupidPool("TopNQueryRunnerFactory-directBufferPool", (Supplier)new Supplier<ByteBuffer>(){

            public ByteBuffer get() {
                return ByteBuffer.allocateDirect(2000);
            }
        }), new TopNQueryQueryToolChest(new TopNQueryConfig()), QueryRunnerTestHelper.NOOP_QUERYWATCHER);
        TEST_CASE_MAP.put(TestCases.rtIndex, QueryRunnerTestHelper.makeQueryRunner(factory, (Segment)new IncrementalIndexSegment(TestIndex.getIncrementalTestIndex(), SEGMENT_ID), null));
        TEST_CASE_MAP.put(TestCases.mMappedTestIndex, QueryRunnerTestHelper.makeQueryRunner(factory, (Segment)new QueryableIndexSegment(TestIndex.getMMappedTestIndex(), SEGMENT_ID), null));
        TEST_CASE_MAP.put(TestCases.mergedRealtimeIndex, QueryRunnerTestHelper.makeQueryRunner(factory, (Segment)new QueryableIndexSegment(TestIndex.mergedRealtimeIndex(), SEGMENT_ID), null));
    }

    @BenchmarkOptions(warmupRounds=10000, benchmarkRounds=10000)
    @Test
    public void testmMapped() {
        TEST_CASE_MAP.get((Object)TestCases.mMappedTestIndex).run(QueryPlus.wrap((Query)QUERY));
    }

    @Ignore
    @BenchmarkOptions(warmupRounds=10000, benchmarkRounds=10000)
    @Test
    public void testrtIndex() {
        TEST_CASE_MAP.get((Object)TestCases.rtIndex).run(QueryPlus.wrap((Query)QUERY));
    }

    @Ignore
    @BenchmarkOptions(warmupRounds=10000, benchmarkRounds=10000)
    @Test
    public void testMerged() {
        TEST_CASE_MAP.get((Object)TestCases.mergedRealtimeIndex).run(QueryPlus.wrap((Query)QUERY));
    }

    @Ignore
    @BenchmarkOptions(warmupRounds=10000, benchmarkRounds=10000)
    @Test
    public void testOffHeap() {
        TEST_CASE_MAP.get((Object)TestCases.rtIndexOffheap).run(QueryPlus.wrap((Query)QUERY));
    }

    public static enum TestCases {
        rtIndex,
        mMappedTestIndex,
        mergedRealtimeIndex,
        rtIndexOffheap;

    }
}

