/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.topn;

import java.util.Collections;
import org.apache.druid.java.util.common.Intervals;
import org.apache.druid.query.PerSegmentQueryOptimizationContext;
import org.apache.druid.query.SegmentDescriptor;
import org.apache.druid.query.aggregation.AggregatorFactory;
import org.apache.druid.query.aggregation.FilteredAggregatorFactory;
import org.apache.druid.query.aggregation.LongSumAggregatorFactory;
import org.apache.druid.query.aggregation.SuppressedAggregatorFactory;
import org.apache.druid.query.filter.DimFilter;
import org.apache.druid.query.filter.IntervalDimFilter;
import org.joda.time.Interval;
import org.junit.Assert;
import org.junit.Test;

public class PerSegmentQueryOptimizeTest {
    @Test
    public void testFilteredAggregatorOptimize() {
        LongSumAggregatorFactory longSumAggregatorFactory = new LongSumAggregatorFactory("test", "test");
        FilteredAggregatorFactory aggregatorFactory = new FilteredAggregatorFactory((AggregatorFactory)longSumAggregatorFactory, (DimFilter)new IntervalDimFilter("__time", Collections.singletonList(Intervals.utc((long)1000L, (long)2000L)), null));
        Interval exclude = Intervals.utc((long)2000L, (long)3000L);
        Interval include = Intervals.utc((long)1500L, (long)1600L);
        Interval partial = Intervals.utc((long)1500L, (long)2500L);
        AggregatorFactory excludedAgg = aggregatorFactory.optimizeForSegment(this.getOptimizationContext(exclude));
        SuppressedAggregatorFactory expectedSuppressedAgg = new SuppressedAggregatorFactory((AggregatorFactory)longSumAggregatorFactory);
        Assert.assertEquals((Object)expectedSuppressedAgg, (Object)excludedAgg);
        AggregatorFactory includedAgg = aggregatorFactory.optimizeForSegment(this.getOptimizationContext(include));
        Assert.assertEquals((Object)longSumAggregatorFactory, (Object)includedAgg);
        AggregatorFactory partialAgg = aggregatorFactory.optimizeForSegment(this.getOptimizationContext(partial));
        FilteredAggregatorFactory expectedPartialFilteredAgg = new FilteredAggregatorFactory((AggregatorFactory)longSumAggregatorFactory, (DimFilter)new IntervalDimFilter("__time", Collections.singletonList(Intervals.utc((long)1500L, (long)2000L)), null));
        Assert.assertEquals((Object)expectedPartialFilteredAgg, (Object)partialAgg);
    }

    @Test
    public void testFilteredAggregatorDontOptimizeOnNonTimeColumn() {
        LongSumAggregatorFactory longSumAggregatorFactory = new LongSumAggregatorFactory("test", "test");
        FilteredAggregatorFactory aggregatorFactory = new FilteredAggregatorFactory((AggregatorFactory)longSumAggregatorFactory, (DimFilter)new IntervalDimFilter("not_time", Collections.singletonList(Intervals.utc((long)1000L, (long)2000L)), null));
        Interval exclude = Intervals.utc((long)2000L, (long)3000L);
        Interval include = Intervals.utc((long)1500L, (long)1600L);
        Interval partial = Intervals.utc((long)1500L, (long)2500L);
        AggregatorFactory excludedAgg = aggregatorFactory.optimizeForSegment(this.getOptimizationContext(exclude));
        Assert.assertEquals((Object)aggregatorFactory, (Object)excludedAgg);
        AggregatorFactory includedAgg = aggregatorFactory.optimizeForSegment(this.getOptimizationContext(include));
        Assert.assertEquals((Object)aggregatorFactory, (Object)includedAgg);
        AggregatorFactory partialAgg = aggregatorFactory.optimizeForSegment(this.getOptimizationContext(partial));
        Assert.assertEquals((Object)aggregatorFactory, (Object)partialAgg);
    }

    private PerSegmentQueryOptimizationContext getOptimizationContext(Interval segmentInterval) {
        return new PerSegmentQueryOptimizationContext(new SegmentDescriptor(segmentInterval, "0", 0));
    }
}

