/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.search;

import com.google.common.collect.ImmutableList;
import java.util.Arrays;
import java.util.List;
import org.apache.druid.jackson.DefaultObjectMapper;
import org.apache.druid.java.util.common.DateTimes;
import org.apache.druid.java.util.common.Intervals;
import org.apache.druid.java.util.common.granularity.Granularities;
import org.apache.druid.query.CacheStrategy;
import org.apache.druid.query.DataSource;
import org.apache.druid.query.Druids;
import org.apache.druid.query.Query;
import org.apache.druid.query.Result;
import org.apache.druid.query.TableDataSource;
import org.apache.druid.query.dimension.DimensionSpec;
import org.apache.druid.query.expression.TestExprMacroTable;
import org.apache.druid.query.search.FragmentSearchQuerySpec;
import org.apache.druid.query.search.SearchHit;
import org.apache.druid.query.search.SearchQuery;
import org.apache.druid.query.search.SearchQueryQueryToolChest;
import org.apache.druid.query.search.SearchQuerySpec;
import org.apache.druid.query.search.SearchResultValue;
import org.apache.druid.query.spec.MultipleIntervalSegmentSpec;
import org.apache.druid.query.spec.QuerySegmentSpec;
import org.apache.druid.segment.VirtualColumns;
import org.apache.druid.segment.column.ColumnType;
import org.apache.druid.segment.virtual.ExpressionVirtualColumn;
import org.apache.druid.testing.InitializedNullHandlingTest;
import org.junit.Assert;
import org.junit.Test;

public class SearchQueryQueryToolChestTest
extends InitializedNullHandlingTest {
    @Test
    public void testCacheStrategy() throws Exception {
        CacheStrategy strategy = new SearchQueryQueryToolChest(null, null).getCacheStrategy(new SearchQuery((DataSource)new TableDataSource("dummy"), null, Granularities.ALL, 1, (QuerySegmentSpec)new MultipleIntervalSegmentSpec((List)ImmutableList.of((Object)Intervals.of((String)"2015-01-01/2015-01-02"))), (List)ImmutableList.of((Object)((DimensionSpec)Druids.DIMENSION_IDENTITY.apply((Object)"dim1"))), VirtualColumns.EMPTY, (SearchQuerySpec)new FragmentSearchQuerySpec((List)ImmutableList.of((Object)"a", (Object)"b")), null, null));
        Result result = new Result(DateTimes.utc((long)123L), (Object)new SearchResultValue((List)ImmutableList.of((Object)new SearchHit("dim1", "a"))));
        Object preparedValue = strategy.prepareForSegmentLevelCache().apply((Object)result);
        DefaultObjectMapper objectMapper = new DefaultObjectMapper();
        Object fromCacheValue = objectMapper.readValue(objectMapper.writeValueAsBytes(preparedValue), strategy.getCacheObjectClazz());
        Result fromCacheResult = (Result)strategy.pullFromSegmentLevelCache().apply(fromCacheValue);
        Assert.assertEquals((Object)result, (Object)fromCacheResult);
    }

    @Test
    public void testCacheStrategyVirtualColumns() {
        SearchQueryQueryToolChest toolChest = new SearchQueryQueryToolChest(null, null);
        SearchQuery query1 = new SearchQuery((DataSource)new TableDataSource("dummy"), null, Granularities.ALL, 1, (QuerySegmentSpec)new MultipleIntervalSegmentSpec((List)ImmutableList.of((Object)Intervals.of((String)"2015-01-01/2015-01-02"))), (List)ImmutableList.of((Object)((DimensionSpec)Druids.DIMENSION_IDENTITY.apply((Object)"v0"))), VirtualColumns.create((List)ImmutableList.of((Object)new ExpressionVirtualColumn("v0", "concat(dim1, 'foo')", ColumnType.STRING, TestExprMacroTable.INSTANCE))), (SearchQuerySpec)new FragmentSearchQuerySpec((List)ImmutableList.of((Object)"a", (Object)"b")), null, null);
        SearchQuery query2 = new SearchQuery((DataSource)new TableDataSource("dummy"), null, Granularities.ALL, 1, (QuerySegmentSpec)new MultipleIntervalSegmentSpec((List)ImmutableList.of((Object)Intervals.of((String)"2015-01-01/2015-01-02"))), (List)ImmutableList.of((Object)((DimensionSpec)Druids.DIMENSION_IDENTITY.apply((Object)"v0"))), VirtualColumns.create((List)ImmutableList.of((Object)new ExpressionVirtualColumn("v0", "concat(dim2, 'foo')", ColumnType.STRING, TestExprMacroTable.INSTANCE))), (SearchQuerySpec)new FragmentSearchQuerySpec((List)ImmutableList.of((Object)"a", (Object)"b")), null, null);
        SearchQuery query3 = new SearchQuery((DataSource)new TableDataSource("dummy"), null, Granularities.ALL, 1, (QuerySegmentSpec)new MultipleIntervalSegmentSpec((List)ImmutableList.of((Object)Intervals.of((String)"2015-01-01/2015-01-02"))), (List)ImmutableList.of((Object)((DimensionSpec)Druids.DIMENSION_IDENTITY.apply((Object)"v0"))), VirtualColumns.create((List)ImmutableList.of((Object)new ExpressionVirtualColumn("v0", "concat(dim1, 'foo')", ColumnType.STRING, TestExprMacroTable.INSTANCE))), (SearchQuerySpec)new FragmentSearchQuerySpec((List)ImmutableList.of((Object)"a", (Object)"b")), null, null);
        Assert.assertArrayEquals((byte[])toolChest.getCacheStrategy(query1).computeCacheKey((Query)query1), (byte[])toolChest.getCacheStrategy(query1).computeCacheKey((Query)query1));
        Assert.assertArrayEquals((byte[])toolChest.getCacheStrategy(query2).computeCacheKey((Query)query2), (byte[])toolChest.getCacheStrategy(query2).computeCacheKey((Query)query2));
        Assert.assertArrayEquals((byte[])toolChest.getCacheStrategy(query1).computeCacheKey((Query)query1), (byte[])toolChest.getCacheStrategy(query3).computeCacheKey((Query)query3));
        Assert.assertFalse((boolean)Arrays.equals(toolChest.getCacheStrategy(query1).computeCacheKey((Query)query1), toolChest.getCacheStrategy(query2).computeCacheKey((Query)query2)));
    }
}

