/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.scan;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSortedSet;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.ExecutorService;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.druid.java.util.common.DateTimes;
import org.apache.druid.java.util.common.Intervals;
import org.apache.druid.java.util.common.Pair;
import org.apache.druid.java.util.common.concurrent.Execs;
import org.apache.druid.java.util.common.guava.MergeSequence;
import org.apache.druid.java.util.common.guava.Sequence;
import org.apache.druid.java.util.common.guava.Sequences;
import org.apache.druid.query.DefaultGenericQueryMetricsFactory;
import org.apache.druid.query.Druids;
import org.apache.druid.query.Order;
import org.apache.druid.query.Query;
import org.apache.druid.query.QueryPlus;
import org.apache.druid.query.QueryRunner;
import org.apache.druid.query.context.ResponseContext;
import org.apache.druid.query.scan.ScanQuery;
import org.apache.druid.query.scan.ScanQueryConfig;
import org.apache.druid.query.scan.ScanQueryEngine;
import org.apache.druid.query.scan.ScanQueryQueryToolChest;
import org.apache.druid.query.scan.ScanQueryRunnerFactory;
import org.apache.druid.query.scan.ScanResultValue;
import org.apache.druid.query.spec.MultipleIntervalSegmentSpec;
import org.apache.druid.query.spec.MultipleSpecificSegmentSpec;
import org.apache.druid.query.spec.QuerySegmentSpec;
import org.apache.druid.segment.RowAdapter;
import org.apache.druid.segment.RowBasedSegment;
import org.apache.druid.segment.column.ColumnType;
import org.apache.druid.segment.column.RowSignature;
import org.apache.druid.testing.InitializedNullHandlingTest;
import org.apache.druid.timeline.SegmentId;
import org.joda.time.DateTime;
import org.joda.time.Interval;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class ScanQueryResultOrderingTest
extends InitializedNullHandlingTest {
    private static final String DATASOURCE = "datasource";
    private static final String ID_COLUMN = "id";
    private static final RowAdapter<Object[]> ROW_ADAPTER = columnName -> {
        if (ID_COLUMN.equals(columnName)) {
            return row -> row[1];
        }
        if ("__time".equals(columnName)) {
            return row -> ((DateTime)row[0]).getMillis();
        }
        return row -> null;
    };
    private static final RowSignature ROW_SIGNATURE = RowSignature.builder().addTimeColumn().add("id", ColumnType.LONG).build();
    private static final List<RowBasedSegment<Object[]>> SEGMENTS = ImmutableList.of((Object)new RowBasedSegment(SegmentId.of((String)"datasource", (Interval)Intervals.of((String)"2000-01-01/P1D"), (String)"1", (int)0), Sequences.simple((Iterable)ImmutableList.of((Object)new Object[]{DateTimes.of((String)"2000T01"), 101}, (Object)new Object[]{DateTimes.of((String)"2000T01"), 80}, (Object)new Object[]{DateTimes.of((String)"2000T01"), 232}, (Object)new Object[]{DateTimes.of((String)"2000T01"), 12}, (Object)new Object[]{DateTimes.of((String)"2000T02"), 808}, (Object)new Object[]{DateTimes.of((String)"2000T02"), 411}, (Object)new Object[]{DateTimes.of((String)"2000T02"), 383}, (Object)new Object[]{DateTimes.of((String)"2000T05"), 22})), ROW_ADAPTER, ROW_SIGNATURE), (Object)new RowBasedSegment(SegmentId.of((String)"datasource", (Interval)Intervals.of((String)"2000-01-01/P1D"), (String)"1", (int)1), Sequences.simple((Iterable)ImmutableList.of((Object)new Object[]{DateTimes.of((String)"2000T01"), 333}, (Object)new Object[]{DateTimes.of((String)"2000T01"), 222}, (Object)new Object[]{DateTimes.of((String)"2000T01"), 444}, (Object)new Object[]{DateTimes.of((String)"2000T01"), 111}, (Object)new Object[]{DateTimes.of((String)"2000T03"), 555}, (Object)new Object[]{DateTimes.of((String)"2000T03"), 999}, (Object)new Object[]{DateTimes.of((String)"2000T03"), 888}, (Object)new Object[]{DateTimes.of((String)"2000T05"), 777})), ROW_ADAPTER, ROW_SIGNATURE), (Object)new RowBasedSegment(SegmentId.of((String)"datasource", (Interval)Intervals.of((String)"2000-01-02/P1D"), (String)"1", (int)0), Sequences.simple((Iterable)ImmutableList.of((Object)new Object[]{DateTimes.of((String)"2000-01-02T00"), 7}, (Object)new Object[]{DateTimes.of((String)"2000-01-02T02"), 9}, (Object)new Object[]{DateTimes.of((String)"2000-01-02T03"), 8})), ROW_ADAPTER, ROW_SIGNATURE));
    private final List<Integer> segmentToServerMap;
    private final int limit;
    private final int batchSize;
    private final int maxRowsQueuedForOrdering;
    private ScanQueryRunnerFactory queryRunnerFactory;
    private List<QueryRunner<ScanResultValue>> segmentRunners;

    @Parameterized.Parameters(name="Segment-to-server map[{0}], limit[{1}], batchSize[{2}], maxRowsQueuedForOrdering[{3}]")
    public static Iterable<Object[]> constructorFeeder() {
        int numServers = SEGMENTS.size();
        Set segmentToServerMaps = Sets.cartesianProduct(IntStream.range(0, SEGMENTS.size()).mapToObj(i -> IntStream.range(0, numServers).boxed().collect(Collectors.toSet())).collect(Collectors.toList()));
        TreeSet<Integer> limits = new TreeSet<Integer>();
        int totalNumRows = 19;
        for (int i2 = 0; i2 <= totalNumRows + 1; ++i2) {
            limits.add(i2);
        }
        ImmutableSortedSet batchSizes = ImmutableSortedSet.of((Comparable)Integer.valueOf(1), (Comparable)Integer.valueOf(2), (Comparable)Integer.valueOf(100));
        ImmutableSortedSet maxRowsQueuedForOrderings = ImmutableSortedSet.of((Comparable)Integer.valueOf(1), (Comparable)Integer.valueOf(7), (Comparable)Integer.valueOf(100000));
        return Sets.cartesianProduct((Set[])new Set[]{segmentToServerMaps, limits, batchSizes, maxRowsQueuedForOrderings}).stream().map(args -> args.toArray(new Object[0])).collect(Collectors.toList());
    }

    public ScanQueryResultOrderingTest(List<Integer> segmentToServerMap, int limit, int batchSize, int maxRowsQueuedForOrdering) {
        this.segmentToServerMap = segmentToServerMap;
        this.limit = limit;
        this.batchSize = batchSize;
        this.maxRowsQueuedForOrdering = maxRowsQueuedForOrdering;
    }

    @Before
    public void setUp() {
        this.queryRunnerFactory = new ScanQueryRunnerFactory(new ScanQueryQueryToolChest(DefaultGenericQueryMetricsFactory.instance()), new ScanQueryEngine(), new ScanQueryConfig());
        this.segmentRunners = SEGMENTS.stream().map(arg_0 -> ((ScanQueryRunnerFactory)this.queryRunnerFactory).createRunner(arg_0)).collect(Collectors.toList());
    }

    @Test
    public void testOrderNone() {
        this.assertResultsEquals(Druids.newScanQueryBuilder().dataSource("ds").intervals((QuerySegmentSpec)new MultipleIntervalSegmentSpec(Collections.singletonList(Intervals.of((String)"2000/P1D")))).columns(new String[]{"__time", ID_COLUMN}).order(Order.NONE).build(), (List<Integer>)ImmutableList.of((Object)101, (Object)80, (Object)232, (Object)12, (Object)808, (Object)411, (Object)383, (Object)22, (Object)333, (Object)222, (Object)444, (Object)111, (Object[])new Integer[]{555, 999, 888, 777, 7, 9, 8}));
    }

    @Test
    public void testOrderTimeAscending() {
        this.assertResultsEquals(Druids.newScanQueryBuilder().dataSource("ds").intervals((QuerySegmentSpec)new MultipleIntervalSegmentSpec(Collections.singletonList(Intervals.of((String)"2000/P1D")))).columns(new String[]{"__time", ID_COLUMN}).order(Order.ASCENDING).build(), (List<Integer>)ImmutableList.of((Object)101, (Object)80, (Object)232, (Object)12, (Object)333, (Object)222, (Object)444, (Object)111, (Object)808, (Object)411, (Object)383, (Object)555, (Object[])new Integer[]{999, 888, 22, 777, 7, 9, 8}));
    }

    @Test
    public void testOrderTimeDescending() {
        this.assertResultsEquals(Druids.newScanQueryBuilder().dataSource("ds").intervals((QuerySegmentSpec)new MultipleIntervalSegmentSpec(Collections.singletonList(Intervals.of((String)"2000/P1D")))).columns(new String[]{"__time", ID_COLUMN}).order(Order.DESCENDING).build(), (List<Integer>)ImmutableList.of((Object)8, (Object)9, (Object)7, (Object)777, (Object)22, (Object)888, (Object)999, (Object)555, (Object)383, (Object)411, (Object)808, (Object)111, (Object[])new Integer[]{444, 222, 333, 12, 232, 80, 101}));
    }

    private void assertResultsEquals(ScanQuery query, List<Integer> expectedResults) {
        ArrayList serverRunners = new ArrayList();
        for (int i = 0; i <= this.segmentToServerMap.stream().max(Comparator.naturalOrder()).orElse(0); ++i) {
            serverRunners.add(new ArrayList());
        }
        for (int segmentNumber = 0; segmentNumber < this.segmentToServerMap.size(); ++segmentNumber) {
            SegmentId segmentId = SEGMENTS.get(segmentNumber).getId();
            int serverNumber = this.segmentToServerMap.get(segmentNumber);
            ((List)serverRunners.get(serverNumber)).add(Pair.of((Object)segmentId, this.segmentRunners.get(segmentNumber)));
        }
        List mergedServerRunners = serverRunners.stream().filter(runners -> !runners.isEmpty()).map(runners -> this.queryRunnerFactory.getToolchest().mergeResults((QueryRunner)new QueryRunner<ScanResultValue>(){

            public Sequence<ScanResultValue> run(QueryPlus<ScanResultValue> queryPlus, ResponseContext responseContext) {
                return ScanQueryResultOrderingTest.this.queryRunnerFactory.mergeRunners((ExecutorService)Execs.directExecutor(), (Iterable)runners.stream().map(p -> (QueryRunner)p.rhs).collect(Collectors.toList())).run(queryPlus.withQuery(queryPlus.getQuery().withQuerySegmentSpec((QuerySegmentSpec)new MultipleSpecificSegmentSpec(runners.stream().map(p -> ((SegmentId)p.lhs).toDescriptor()).collect(Collectors.toList())))), responseContext);
            }
        })).collect(Collectors.toList());
        QueryRunner brokerRunner = this.queryRunnerFactory.getToolchest().mergeResults((queryPlus, responseContext) -> {
            List sequences = mergedServerRunners.stream().map(runner -> runner.run(queryPlus.withoutThreadUnsafeState())).collect(Collectors.toList());
            return new MergeSequence(queryPlus.getQuery().getResultOrdering(), Sequences.simple(sequences));
        });
        List<Integer> results = this.runQuery(Druids.ScanQueryBuilder.copy((ScanQuery)query).limit((long)this.limit).batchSize(this.batchSize).build().withOverriddenContext((Map)ImmutableMap.of((Object)"maxRowsQueuedForOrdering", (Object)this.maxRowsQueuedForOrdering)), (QueryRunner<ScanResultValue>)brokerRunner);
        Assert.assertEquals(expectedResults.stream().limit(this.limit == 0 ? Long.MAX_VALUE : (long)this.limit).collect(Collectors.toList()), results);
    }

    private List<Integer> runQuery(ScanQuery query, QueryRunner<ScanResultValue> brokerRunner) {
        List results = this.queryRunnerFactory.getToolchest().resultsAsArrays((Query)query, brokerRunner.run(QueryPlus.wrap((Query)query))).toList();
        return results.stream().mapToInt(row -> (Integer)row[1]).boxed().collect(Collectors.toList());
    }
}

