/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.planning;

import nl.jqno.equalsverifier.EqualsVerifier;
import org.apache.druid.math.expr.ExprMacroTable;
import org.apache.druid.query.DataSource;
import org.apache.druid.query.JoinAlgorithm;
import org.apache.druid.query.JoinDataSource;
import org.apache.druid.query.TableDataSource;
import org.apache.druid.query.filter.DimFilter;
import org.apache.druid.query.filter.TrueDimFilter;
import org.apache.druid.query.planning.PreJoinableClause;
import org.apache.druid.segment.join.JoinType;
import org.junit.Assert;
import org.junit.Test;

public class PreJoinableClauseTest {
    private final PreJoinableClause clause = this.makePreJoinableClause();

    private PreJoinableClause makePreJoinableClause() {
        JoinDataSource join = JoinDataSource.create((DataSource)new TableDataSource("bar"), (DataSource)new TableDataSource("foo"), (String)"j.", (String)"x == \"j.x\"", (JoinType)JoinType.LEFT, (DimFilter)TrueDimFilter.instance(), (ExprMacroTable)ExprMacroTable.nil(), null, (JoinAlgorithm)JoinAlgorithm.BROADCAST);
        return new PreJoinableClause(join);
    }

    @Test
    public void test_getPrefix() {
        Assert.assertEquals((Object)"j.", (Object)this.clause.getPrefix());
    }

    @Test
    public void test_getJoinType() {
        Assert.assertEquals((Object)JoinType.LEFT, (Object)this.clause.getJoinType());
    }

    @Test
    public void test_getCondition() {
        Assert.assertEquals((Object)"x == \"j.x\"", (Object)this.clause.getCondition().getOriginalExpression());
    }

    @Test
    public void test_getDataSource() {
        Assert.assertEquals((Object)new TableDataSource("foo"), (Object)this.clause.getDataSource());
    }

    @Test
    public void test_equals() {
        EqualsVerifier.forClass(PreJoinableClause.class).usingGetClass().withNonnullFields(new String[]{"prefix", "dataSource", "joinType", "condition"}).verify();
    }
}

