/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.planning;

import com.google.common.collect.ImmutableList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import nl.jqno.equalsverifier.EqualsVerifier;
import org.apache.druid.error.DruidException;
import org.apache.druid.java.util.common.Intervals;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.java.util.common.granularity.Granularities;
import org.apache.druid.math.expr.ExprMacroTable;
import org.apache.druid.query.DataSource;
import org.apache.druid.query.Druids;
import org.apache.druid.query.InlineDataSource;
import org.apache.druid.query.JoinAlgorithm;
import org.apache.druid.query.JoinDataSource;
import org.apache.druid.query.LookupDataSource;
import org.apache.druid.query.Query;
import org.apache.druid.query.QueryDataSource;
import org.apache.druid.query.RestrictedDataSource;
import org.apache.druid.query.TableDataSource;
import org.apache.druid.query.UnionDataSource;
import org.apache.druid.query.filter.DimFilter;
import org.apache.druid.query.filter.TrueDimFilter;
import org.apache.druid.query.groupby.GroupByQuery;
import org.apache.druid.query.planning.DataSourceAnalysis;
import org.apache.druid.query.planning.PreJoinableClause;
import org.apache.druid.query.policy.NoRestrictionPolicy;
import org.apache.druid.query.policy.Policy;
import org.apache.druid.query.scan.ScanQuery;
import org.apache.druid.query.spec.MultipleIntervalSegmentSpec;
import org.apache.druid.query.spec.QuerySegmentSpec;
import org.apache.druid.segment.column.ColumnType;
import org.apache.druid.segment.column.RowSignature;
import org.apache.druid.segment.join.JoinConditionAnalysis;
import org.apache.druid.segment.join.JoinType;
import org.joda.time.Interval;
import org.junit.Assert;
import org.junit.Test;

public class DataSourceAnalysisTest {
    private static final List<Interval> MILLENIUM_INTERVALS = ImmutableList.of((Object)Intervals.of((String)"2000/3000"));
    private static final TableDataSource TABLE_FOO = new TableDataSource("foo");
    private static final TableDataSource TABLE_BAR = new TableDataSource("bar");
    private static final RestrictedDataSource RESTRICTED_FOO = RestrictedDataSource.create((DataSource)TABLE_FOO, (Policy)NoRestrictionPolicy.instance());
    private static final LookupDataSource LOOKUP_LOOKYLOO = new LookupDataSource("lookyloo");
    private static final InlineDataSource INLINE = InlineDataSource.fromIterable((Iterable)ImmutableList.of((Object)new Object[0]), (RowSignature)RowSignature.builder().add("column", ColumnType.STRING).build());

    @Test
    public void testTable() {
        DataSourceAnalysis analysis = DataSourceAnalysisTest.makeScanQuery((DataSource)TABLE_FOO).getDataSourceAnalysis();
        Assert.assertTrue((boolean)analysis.isConcreteBased());
        Assert.assertTrue((boolean)analysis.isTableBased());
        Assert.assertTrue((boolean)analysis.isConcreteAndTableBased());
        Assert.assertEquals((Object)TABLE_FOO, (Object)analysis.getBaseDataSource());
        Assert.assertEquals((Object)TABLE_FOO, (Object)analysis.getBaseTableDataSource());
        Assert.assertEquals(Optional.empty(), (Object)analysis.getBaseUnionDataSource());
        Assert.assertEquals(Optional.empty(), (Object)analysis.getBaseQuery());
        Assert.assertEquals((Object)new MultipleIntervalSegmentSpec(MILLENIUM_INTERVALS), (Object)analysis.getEffectiveQuerySegmentSpec());
        Assert.assertEquals(Collections.emptyList(), (Object)analysis.getPreJoinableClauses());
        Assert.assertFalse((boolean)analysis.isGlobal());
        Assert.assertFalse((boolean)analysis.isJoin());
        Assert.assertTrue((boolean)analysis.isBaseColumn("foo"));
    }

    @Test
    public void testRestricted() {
        DataSourceAnalysis analysis = RESTRICTED_FOO.getAnalysis();
        Assert.assertTrue((boolean)analysis.isConcreteBased());
        Assert.assertTrue((boolean)analysis.isTableBased());
        Assert.assertTrue((boolean)analysis.isConcreteAndTableBased());
        Assert.assertEquals((Object)TABLE_FOO, (Object)analysis.getBaseDataSource());
        Assert.assertEquals((Object)TABLE_FOO, (Object)analysis.getBaseTableDataSource());
        Assert.assertEquals(Optional.empty(), (Object)analysis.getBaseUnionDataSource());
        Assert.assertEquals(Optional.empty(), (Object)analysis.getBaseQuery());
        Assert.assertThrows(DruidException.class, () -> analysis.getEffectiveQuerySegmentSpec());
        Assert.assertEquals(Collections.emptyList(), (Object)analysis.getPreJoinableClauses());
        Assert.assertFalse((boolean)analysis.isGlobal());
        Assert.assertFalse((boolean)analysis.isJoin());
        Assert.assertTrue((boolean)analysis.isBaseColumn("foo"));
    }

    @Test
    public void testRestrictedInJoin() {
        JoinDataSource ds = DataSourceAnalysisTest.join((DataSource)RESTRICTED_FOO, (DataSource)LOOKUP_LOOKYLOO, "1.", JoinType.INNER);
        DataSourceAnalysis analysis = DataSourceAnalysisTest.makeScanQuery((DataSource)ds).getDataSourceAnalysis();
        Assert.assertTrue((boolean)analysis.isConcreteBased());
        Assert.assertTrue((boolean)analysis.isTableBased());
        Assert.assertTrue((boolean)analysis.isConcreteAndTableBased());
        Assert.assertEquals((Object)RESTRICTED_FOO, (Object)analysis.getBaseDataSource());
        Assert.assertThrows(DruidException.class, () -> analysis.getBaseTableDataSource());
        Assert.assertEquals(Optional.empty(), (Object)analysis.getBaseUnionDataSource());
        Assert.assertEquals(Optional.empty(), (Object)analysis.getBaseQuery());
        Assert.assertEquals((Object)new MultipleIntervalSegmentSpec(MILLENIUM_INTERVALS), (Object)analysis.getEffectiveQuerySegmentSpec());
        Assert.assertFalse((boolean)analysis.isGlobal());
        Assert.assertTrue((boolean)analysis.isJoin());
        Assert.assertTrue((boolean)analysis.isBaseColumn("foo"));
    }

    @Test
    public void testUnion() {
        UnionDataSource unionDataSource = new UnionDataSource((List)ImmutableList.of((Object)TABLE_FOO, (Object)TABLE_BAR));
        DataSourceAnalysis analysis = unionDataSource.getAnalysis();
        Assert.assertTrue((boolean)analysis.isConcreteBased());
        Assert.assertTrue((boolean)analysis.isTableBased());
        Assert.assertTrue((boolean)analysis.isConcreteAndTableBased());
        Assert.assertEquals((Object)unionDataSource, (Object)analysis.getBaseDataSource());
        Assert.assertThrows(DruidException.class, () -> analysis.getBaseTableDataSource());
        Assert.assertEquals(Optional.of(unionDataSource), (Object)analysis.getBaseUnionDataSource());
        Assert.assertEquals(Optional.empty(), (Object)analysis.getBaseQuery());
        Assert.assertThrows(DruidException.class, () -> analysis.getEffectiveQuerySegmentSpec());
        Assert.assertEquals(Collections.emptyList(), (Object)analysis.getPreJoinableClauses());
        Assert.assertEquals((Object)unionDataSource.isGlobal(), (Object)analysis.isGlobal());
        Assert.assertFalse((boolean)analysis.isJoin());
        Assert.assertTrue((boolean)analysis.isBaseColumn("foo"));
    }

    @Test
    public void testSubQueryOnTable() {
        QueryDataSource queryDataSource = DataSourceAnalysisTest.makeQueryDS((DataSource)TABLE_FOO);
        DataSourceAnalysis analysis = DataSourceAnalysisTest.makeGroupByQuery((DataSource)queryDataSource).getDataSourceAnalysis();
        Assert.assertTrue((boolean)analysis.isConcreteBased());
        Assert.assertTrue((boolean)analysis.isTableBased());
        Assert.assertTrue((boolean)analysis.isConcreteAndTableBased());
        Assert.assertEquals((Object)TABLE_FOO, (Object)analysis.getBaseDataSource());
        Assert.assertEquals((Object)TABLE_FOO, (Object)analysis.getBaseTableDataSource());
        Assert.assertEquals(Optional.empty(), (Object)analysis.getBaseUnionDataSource());
        Assert.assertEquals(Optional.empty(), (Object)analysis.getBaseQuery());
        Assert.assertEquals((Object)new MultipleIntervalSegmentSpec(MILLENIUM_INTERVALS), (Object)analysis.getEffectiveQuerySegmentSpec());
        Assert.assertEquals(Collections.emptyList(), (Object)analysis.getPreJoinableClauses());
        Assert.assertFalse((boolean)analysis.isGlobal());
        Assert.assertFalse((boolean)analysis.isJoin());
        Assert.assertTrue((boolean)analysis.isBaseColumn("foo"));
    }

    @Test
    public void testQueryOnUnion() {
        UnionDataSource unionDataSource = new UnionDataSource((List)ImmutableList.of((Object)TABLE_FOO, (Object)TABLE_BAR));
        QueryDataSource queryDataSource = DataSourceAnalysisTest.makeQueryDS((DataSource)unionDataSource);
        DataSourceAnalysis analysis = queryDataSource.getAnalysis();
        Assert.assertFalse((boolean)analysis.isConcreteBased());
        Assert.assertFalse((boolean)analysis.isTableBased());
        Assert.assertFalse((boolean)analysis.isConcreteAndTableBased());
        Assert.assertEquals((Object)queryDataSource, (Object)analysis.getBaseDataSource());
        Assert.assertThrows(DruidException.class, () -> analysis.getBaseTableDataSource());
        Assert.assertEquals(Optional.empty(), (Object)analysis.getBaseUnionDataSource());
        Assert.assertEquals(Optional.of(queryDataSource.getQuery()), (Object)analysis.getBaseQuery());
        Assert.assertThrows(DruidException.class, () -> analysis.getEffectiveQuerySegmentSpec());
        Assert.assertEquals(Collections.emptyList(), (Object)analysis.getPreJoinableClauses());
        Assert.assertFalse((boolean)analysis.isGlobal());
        Assert.assertFalse((boolean)analysis.isJoin());
        Assert.assertFalse((boolean)analysis.isBaseColumn("foo"));
    }

    @Test
    public void testLookup() {
        DataSourceAnalysis analysis = LOOKUP_LOOKYLOO.getAnalysis();
        Assert.assertTrue((boolean)analysis.isConcreteBased());
        Assert.assertFalse((boolean)analysis.isTableBased());
        Assert.assertFalse((boolean)analysis.isConcreteAndTableBased());
        Assert.assertEquals((Object)LOOKUP_LOOKYLOO, (Object)analysis.getBaseDataSource());
        Assert.assertThrows(DruidException.class, () -> analysis.getBaseTableDataSource());
        Assert.assertEquals(Optional.empty(), (Object)analysis.getBaseUnionDataSource());
        Assert.assertEquals(Optional.empty(), (Object)analysis.getBaseQuery());
        Assert.assertThrows(DruidException.class, () -> analysis.getEffectiveQuerySegmentSpec());
        Assert.assertEquals(Collections.emptyList(), (Object)analysis.getPreJoinableClauses());
        Assert.assertTrue((boolean)analysis.isGlobal());
        Assert.assertFalse((boolean)analysis.isJoin());
        Assert.assertTrue((boolean)analysis.isBaseColumn("foo"));
    }

    @Test
    public void testQueryOnLookup() {
        QueryDataSource queryDataSource = DataSourceAnalysisTest.makeQueryDS((DataSource)LOOKUP_LOOKYLOO);
        DataSourceAnalysis analysis = queryDataSource.getAnalysis();
        Assert.assertFalse((boolean)analysis.isConcreteBased());
        Assert.assertFalse((boolean)analysis.isTableBased());
        Assert.assertFalse((boolean)analysis.isConcreteAndTableBased());
        Assert.assertEquals((Object)queryDataSource, (Object)analysis.getBaseDataSource());
        Assert.assertThrows(DruidException.class, () -> analysis.getBaseTableDataSource());
        Assert.assertEquals(Optional.empty(), (Object)analysis.getBaseUnionDataSource());
        Assert.assertEquals(Optional.of(queryDataSource.getQuery()), (Object)analysis.getBaseQuery());
        Assert.assertThrows(DruidException.class, () -> analysis.getEffectiveQuerySegmentSpec());
        Assert.assertEquals(Collections.emptyList(), (Object)analysis.getPreJoinableClauses());
        Assert.assertTrue((boolean)analysis.isGlobal());
        Assert.assertFalse((boolean)analysis.isJoin());
        Assert.assertFalse((boolean)analysis.isBaseColumn("foo"));
    }

    @Test
    public void testInline() {
        DataSourceAnalysis analysis = INLINE.getAnalysis();
        Assert.assertTrue((boolean)analysis.isConcreteBased());
        Assert.assertFalse((boolean)analysis.isTableBased());
        Assert.assertFalse((boolean)analysis.isConcreteAndTableBased());
        Assert.assertEquals((Object)INLINE, (Object)analysis.getBaseDataSource());
        Assert.assertThrows(DruidException.class, () -> analysis.getBaseTableDataSource());
        Assert.assertEquals(Optional.empty(), (Object)analysis.getBaseUnionDataSource());
        Assert.assertEquals(Optional.empty(), (Object)analysis.getBaseQuery());
        Assert.assertThrows(DruidException.class, () -> analysis.getEffectiveQuerySegmentSpec());
        Assert.assertEquals(Collections.emptyList(), (Object)analysis.getPreJoinableClauses());
        Assert.assertEquals((Object)INLINE.isGlobal(), (Object)analysis.isGlobal());
        Assert.assertTrue((boolean)analysis.isGlobal());
        Assert.assertFalse((boolean)analysis.isJoin());
        Assert.assertTrue((boolean)analysis.isBaseColumn("foo"));
    }

    @Test
    public void testJoinSimpleLeftLeaning() {
        JoinDataSource joinDataSource = DataSourceAnalysisTest.join((DataSource)DataSourceAnalysisTest.join((DataSource)DataSourceAnalysisTest.join((DataSource)TABLE_FOO, (DataSource)LOOKUP_LOOKYLOO, "1.", JoinType.INNER), (DataSource)INLINE, "2.", JoinType.LEFT), (DataSource)DataSourceAnalysisTest.makeQueryDS((DataSource)LOOKUP_LOOKYLOO), "3.", JoinType.FULL);
        DataSourceAnalysis analysis = joinDataSource.getAnalysis();
        Assert.assertTrue((boolean)analysis.isConcreteBased());
        Assert.assertTrue((boolean)analysis.isTableBased());
        Assert.assertTrue((boolean)analysis.isConcreteAndTableBased());
        Assert.assertEquals((Object)TABLE_FOO, (Object)analysis.getBaseDataSource());
        Assert.assertEquals((Object)TABLE_FOO, (Object)analysis.getBaseTableDataSource());
        Assert.assertEquals(Optional.empty(), (Object)analysis.getJoinBaseTableFilter());
        Assert.assertEquals(Optional.empty(), (Object)analysis.getBaseUnionDataSource());
        Assert.assertEquals(Optional.empty(), (Object)analysis.getBaseUnionDataSource());
        Assert.assertEquals(Optional.empty(), (Object)analysis.getBaseQuery());
        Assert.assertThrows(DruidException.class, () -> analysis.getEffectiveQuerySegmentSpec());
        Assert.assertEquals((Object)ImmutableList.of((Object)new PreJoinableClause((JoinDataSource)((JoinDataSource)joinDataSource.getLeft()).getLeft()), (Object)new PreJoinableClause((JoinDataSource)joinDataSource.getLeft()), (Object)new PreJoinableClause(joinDataSource)), (Object)analysis.getPreJoinableClauses());
        Assert.assertEquals((Object)joinDataSource.isGlobal(), (Object)analysis.isGlobal());
        Assert.assertFalse((boolean)analysis.isGlobal());
        Assert.assertTrue((boolean)analysis.isJoin());
        Assert.assertTrue((boolean)analysis.isBaseColumn("foo"));
        Assert.assertFalse((boolean)analysis.isBaseColumn("1.foo"));
        Assert.assertFalse((boolean)analysis.isBaseColumn("2.foo"));
        Assert.assertFalse((boolean)analysis.isBaseColumn("3.foo"));
    }

    @Test
    public void testJoinSimpleLeftLeaningWithLeftFilter() {
        JoinDataSource joinDataSource = DataSourceAnalysisTest.join((DataSource)DataSourceAnalysisTest.join((DataSource)DataSourceAnalysisTest.join((DataSource)TABLE_FOO, (DataSource)LOOKUP_LOOKYLOO, "1.", JoinType.INNER, (DimFilter)TrueDimFilter.instance()), (DataSource)INLINE, "2.", JoinType.LEFT), (DataSource)DataSourceAnalysisTest.makeQueryDS((DataSource)LOOKUP_LOOKYLOO), "3.", JoinType.FULL);
        DataSourceAnalysis analysis = joinDataSource.getAnalysis();
        Assert.assertTrue((boolean)analysis.isConcreteBased());
        Assert.assertTrue((boolean)analysis.isTableBased());
        Assert.assertTrue((boolean)analysis.isConcreteAndTableBased());
        Assert.assertEquals((Object)TABLE_FOO, (Object)analysis.getBaseDataSource());
        Assert.assertEquals((Object)TABLE_FOO, (Object)analysis.getBaseTableDataSource());
        Assert.assertEquals(null, analysis.getJoinBaseTableFilter().orElse(null));
        Assert.assertEquals(Optional.empty(), (Object)analysis.getBaseUnionDataSource());
        Assert.assertEquals(Optional.empty(), (Object)analysis.getBaseUnionDataSource());
        Assert.assertEquals(Optional.empty(), (Object)analysis.getBaseQuery());
        Assert.assertThrows(DruidException.class, () -> analysis.getEffectiveQuerySegmentSpec());
        Assert.assertEquals((Object)ImmutableList.of((Object)new PreJoinableClause((JoinDataSource)((JoinDataSource)joinDataSource.getLeft()).getLeft()), (Object)new PreJoinableClause((JoinDataSource)joinDataSource.getLeft()), (Object)new PreJoinableClause(joinDataSource)), (Object)analysis.getPreJoinableClauses());
        Assert.assertEquals((Object)joinDataSource.isGlobal(), (Object)analysis.isGlobal());
        Assert.assertFalse((boolean)analysis.isGlobal());
        Assert.assertTrue((boolean)analysis.isJoin());
        Assert.assertTrue((boolean)analysis.isBaseColumn("foo"));
        Assert.assertFalse((boolean)analysis.isBaseColumn("1.foo"));
        Assert.assertFalse((boolean)analysis.isBaseColumn("2.foo"));
        Assert.assertFalse((boolean)analysis.isBaseColumn("3.foo"));
    }

    @Test
    public void testJoinSimpleRightLeaning() {
        JoinDataSource rightLeaningJoinStack = DataSourceAnalysisTest.join((DataSource)LOOKUP_LOOKYLOO, (DataSource)DataSourceAnalysisTest.join((DataSource)INLINE, (DataSource)DataSourceAnalysisTest.makeQueryDS((DataSource)LOOKUP_LOOKYLOO), "1.", JoinType.LEFT), "2.", JoinType.FULL);
        JoinDataSource joinDataSource = DataSourceAnalysisTest.join((DataSource)TABLE_FOO, (DataSource)rightLeaningJoinStack, "3.", JoinType.RIGHT);
        DataSourceAnalysis analysis = joinDataSource.getAnalysis();
        Assert.assertTrue((boolean)analysis.isConcreteBased());
        Assert.assertTrue((boolean)analysis.isTableBased());
        Assert.assertTrue((boolean)analysis.isConcreteAndTableBased());
        Assert.assertEquals((Object)TABLE_FOO, (Object)analysis.getBaseDataSource());
        Assert.assertEquals((Object)TABLE_FOO, (Object)analysis.getBaseTableDataSource());
        Assert.assertEquals(Optional.empty(), (Object)analysis.getJoinBaseTableFilter());
        Assert.assertEquals(Optional.empty(), (Object)analysis.getBaseUnionDataSource());
        Assert.assertEquals(Optional.empty(), (Object)analysis.getBaseQuery());
        Assert.assertThrows(DruidException.class, () -> analysis.getEffectiveQuerySegmentSpec());
        Assert.assertEquals((Object)ImmutableList.of((Object)new PreJoinableClause(joinDataSource)), (Object)analysis.getPreJoinableClauses());
        Assert.assertFalse((boolean)analysis.isGlobal());
        Assert.assertTrue((boolean)analysis.isJoin());
        Assert.assertTrue((boolean)analysis.isBaseColumn("foo"));
        Assert.assertTrue((boolean)analysis.isBaseColumn("1.foo"));
        Assert.assertTrue((boolean)analysis.isBaseColumn("2.foo"));
        Assert.assertFalse((boolean)analysis.isBaseColumn("3.foo"));
    }

    @Test
    public void testJoinSimpleRightLeaningWithLeftFilter() {
        JoinDataSource rightLeaningJoinStack = DataSourceAnalysisTest.join((DataSource)LOOKUP_LOOKYLOO, (DataSource)DataSourceAnalysisTest.join((DataSource)INLINE, (DataSource)DataSourceAnalysisTest.makeQueryDS((DataSource)LOOKUP_LOOKYLOO), "1.", JoinType.LEFT), "2.", JoinType.FULL);
        JoinDataSource joinDataSource = DataSourceAnalysisTest.join((DataSource)TABLE_FOO, (DataSource)rightLeaningJoinStack, "3.", JoinType.RIGHT, (DimFilter)TrueDimFilter.instance());
        DataSourceAnalysis analysis = joinDataSource.getAnalysis();
        Assert.assertTrue((boolean)analysis.isConcreteBased());
        Assert.assertTrue((boolean)analysis.isTableBased());
        Assert.assertTrue((boolean)analysis.isConcreteAndTableBased());
        Assert.assertEquals((Object)TABLE_FOO, (Object)analysis.getBaseDataSource());
        Assert.assertEquals((Object)TABLE_FOO, (Object)analysis.getBaseTableDataSource());
        Assert.assertEquals(null, analysis.getJoinBaseTableFilter().orElse(null));
        Assert.assertEquals(Optional.empty(), (Object)analysis.getBaseUnionDataSource());
        Assert.assertEquals(Optional.empty(), (Object)analysis.getBaseQuery());
        Assert.assertThrows(DruidException.class, () -> analysis.getEffectiveQuerySegmentSpec());
        Assert.assertEquals((Object)ImmutableList.of((Object)new PreJoinableClause(joinDataSource)), (Object)analysis.getPreJoinableClauses());
        Assert.assertFalse((boolean)analysis.isGlobal());
        Assert.assertTrue((boolean)analysis.isJoin());
        Assert.assertTrue((boolean)analysis.isBaseColumn("foo"));
        Assert.assertTrue((boolean)analysis.isBaseColumn("1.foo"));
        Assert.assertTrue((boolean)analysis.isBaseColumn("2.foo"));
        Assert.assertFalse((boolean)analysis.isBaseColumn("3.foo"));
    }

    @Test
    public void testJoinOverTableSubquery() {
        JoinDataSource joinDataSource = DataSourceAnalysisTest.join((DataSource)TABLE_FOO, (DataSource)DataSourceAnalysisTest.makeQueryDS((DataSource)TABLE_FOO), "1.", JoinType.INNER, (DimFilter)TrueDimFilter.instance());
        DataSourceAnalysis analysis = joinDataSource.getAnalysis();
        Assert.assertFalse((boolean)analysis.isConcreteBased());
        Assert.assertTrue((boolean)analysis.isTableBased());
        Assert.assertFalse((boolean)analysis.isConcreteAndTableBased());
        Assert.assertEquals((Object)TABLE_FOO, (Object)analysis.getBaseDataSource());
        Assert.assertEquals(null, analysis.getJoinBaseTableFilter().orElse(null));
        Assert.assertEquals((Object)TABLE_FOO, (Object)analysis.getBaseTableDataSource());
        Assert.assertEquals(Optional.empty(), (Object)analysis.getBaseUnionDataSource());
        Assert.assertEquals((Object)ImmutableList.of((Object)new PreJoinableClause(joinDataSource)), (Object)analysis.getPreJoinableClauses());
        Assert.assertFalse((boolean)analysis.isGlobal());
        Assert.assertTrue((boolean)analysis.isJoin());
        Assert.assertTrue((boolean)analysis.isBaseColumn("foo"));
        Assert.assertFalse((boolean)analysis.isBaseColumn("1.foo"));
    }

    @Test
    public void testJoinTableUnionToLookup() {
        UnionDataSource unionDataSource = new UnionDataSource((List)ImmutableList.of((Object)TABLE_FOO, (Object)TABLE_BAR));
        JoinDataSource joinDataSource = DataSourceAnalysisTest.join((DataSource)unionDataSource, (DataSource)LOOKUP_LOOKYLOO, "1.", JoinType.INNER);
        DataSourceAnalysis analysis = joinDataSource.getAnalysis();
        Assert.assertTrue((boolean)analysis.isConcreteBased());
        Assert.assertTrue((boolean)analysis.isTableBased());
        Assert.assertTrue((boolean)analysis.isConcreteAndTableBased());
        Assert.assertThrows(DruidException.class, () -> analysis.getBaseTableDataSource());
        Assert.assertEquals(Optional.empty(), (Object)analysis.getJoinBaseTableFilter());
        Assert.assertEquals(Optional.of(unionDataSource), (Object)analysis.getBaseUnionDataSource());
        Assert.assertEquals((Object)unionDataSource, (Object)analysis.getBaseDataSource());
        Assert.assertEquals(Optional.empty(), (Object)analysis.getBaseQuery());
        Assert.assertThrows(DruidException.class, () -> analysis.getEffectiveQuerySegmentSpec());
        Assert.assertEquals((Object)ImmutableList.of((Object)new PreJoinableClause(joinDataSource)), (Object)analysis.getPreJoinableClauses());
        Assert.assertFalse((boolean)analysis.isGlobal());
        Assert.assertTrue((boolean)analysis.isJoin());
        Assert.assertTrue((boolean)analysis.isBaseColumn("foo"));
        Assert.assertFalse((boolean)analysis.isBaseColumn("1.foo"));
    }

    @Test
    public void testJoinUnderTopLevelSubqueries() {
        QueryDataSource queryDataSource = DataSourceAnalysisTest.makeQueryDS((DataSource)DataSourceAnalysisTest.makeQueryDS((DataSource)DataSourceAnalysisTest.join((DataSource)TABLE_FOO, (DataSource)LOOKUP_LOOKYLOO, "1.", JoinType.INNER, (DimFilter)TrueDimFilter.instance())));
        DataSourceAnalysis analysis = DataSourceAnalysisTest.makeScanQuery((DataSource)queryDataSource).getDataSourceAnalysis();
        Assert.assertFalse((boolean)analysis.isConcreteBased());
        Assert.assertFalse((boolean)analysis.isTableBased());
        Assert.assertFalse((boolean)analysis.isConcreteAndTableBased());
        Assert.assertEquals((Object)queryDataSource, (Object)analysis.getBaseDataSource());
        Assert.assertEquals(null, analysis.getJoinBaseTableFilter().orElse(null));
        Assert.assertThrows(DruidException.class, () -> analysis.getBaseTableDataSource());
        Assert.assertEquals(Optional.empty(), (Object)analysis.getBaseUnionDataSource());
        Assert.assertEquals(Optional.of(queryDataSource.getQuery()), (Object)analysis.getBaseQuery());
        Assert.assertEquals((Object)new MultipleIntervalSegmentSpec(MILLENIUM_INTERVALS), (Object)analysis.getEffectiveQuerySegmentSpec());
        Assert.assertEquals(Collections.emptyList(), (Object)analysis.getPreJoinableClauses());
        Assert.assertFalse((boolean)analysis.isGlobal());
        Assert.assertFalse((boolean)analysis.isJoin());
        Assert.assertFalse((boolean)analysis.isBaseColumn("foo"));
        Assert.assertFalse((boolean)analysis.isBaseColumn("1.foo"));
    }

    @Test
    public void testSubqueriesAnalysis() {
        JoinDataSource joinDataSource = DataSourceAnalysisTest.join((DataSource)TABLE_FOO, (DataSource)LOOKUP_LOOKYLOO, "1.", JoinType.INNER, (DimFilter)TrueDimFilter.instance());
        GroupByQuery query = GroupByQuery.builder().setDataSource((DataSource)DataSourceAnalysisTest.makeQueryDS((DataSource)joinDataSource)).setInterval((List)Intervals.ONLY_ETERNITY).setGranularity(Granularities.ALL).build();
        DataSourceAnalysis analysis = query.getDataSourceAnalysis();
        Assert.assertTrue((boolean)analysis.isConcreteBased());
        Assert.assertTrue((boolean)analysis.isTableBased());
        Assert.assertTrue((boolean)analysis.isConcreteAndTableBased());
        Assert.assertEquals((Object)TABLE_FOO, (Object)analysis.getBaseDataSource());
        Assert.assertEquals(null, analysis.getJoinBaseTableFilter().orElse(null));
        Assert.assertEquals((Object)TABLE_FOO, (Object)analysis.getBaseTableDataSource());
        Assert.assertEquals(Optional.empty(), (Object)analysis.getBaseUnionDataSource());
        Assert.assertEquals(Optional.empty(), (Object)analysis.getBaseQuery());
        Assert.assertEquals((Object)new MultipleIntervalSegmentSpec(MILLENIUM_INTERVALS), (Object)analysis.getEffectiveQuerySegmentSpec());
        Assert.assertEquals((Object)ImmutableList.of((Object)new PreJoinableClause(joinDataSource)), (Object)analysis.getPreJoinableClauses());
        Assert.assertFalse((boolean)analysis.isGlobal());
        Assert.assertTrue((boolean)analysis.isJoin());
        Assert.assertTrue((boolean)analysis.isBaseColumn("foo"));
        Assert.assertFalse((boolean)analysis.isBaseColumn("1.foo"));
    }

    @Test
    public void testSubQuery3() {
        QueryDataSource queryDataSource = DataSourceAnalysisTest.makeQueryDS((DataSource)DataSourceAnalysisTest.makeQueryDS((DataSource)DataSourceAnalysisTest.makeQueryDS((DataSource)TABLE_FOO)));
        DataSourceAnalysis analysis = DataSourceAnalysisTest.makeScanQuery((DataSource)queryDataSource).getDataSourceAnalysis();
        Assert.assertFalse((boolean)analysis.isConcreteBased());
        Assert.assertFalse((boolean)analysis.isTableBased());
        Assert.assertFalse((boolean)analysis.isConcreteAndTableBased());
        Assert.assertEquals((Object)queryDataSource, (Object)analysis.getBaseDataSource());
        Assert.assertEquals(null, analysis.getJoinBaseTableFilter().orElse(null));
        Assert.assertThrows(DruidException.class, () -> analysis.getBaseTableDataSource());
        Assert.assertEquals(Optional.empty(), (Object)analysis.getBaseUnionDataSource());
        Assert.assertEquals(Optional.of(queryDataSource.getQuery()), (Object)analysis.getBaseQuery());
        Assert.assertEquals((Object)new MultipleIntervalSegmentSpec(MILLENIUM_INTERVALS), (Object)analysis.getEffectiveQuerySegmentSpec());
        Assert.assertFalse((boolean)analysis.isGlobal());
        Assert.assertFalse((boolean)analysis.isJoin());
        Assert.assertFalse((boolean)analysis.isBaseColumn("foo"));
        Assert.assertFalse((boolean)analysis.isBaseColumn("1.foo"));
    }

    @Test
    public void testJoinLookupToLookup() {
        JoinDataSource joinDataSource = DataSourceAnalysisTest.join((DataSource)LOOKUP_LOOKYLOO, (DataSource)LOOKUP_LOOKYLOO, "1.", JoinType.INNER);
        DataSourceAnalysis analysis = joinDataSource.getAnalysis();
        Assert.assertTrue((boolean)analysis.isConcreteBased());
        Assert.assertFalse((boolean)analysis.isTableBased());
        Assert.assertFalse((boolean)analysis.isConcreteAndTableBased());
        Assert.assertEquals((Object)LOOKUP_LOOKYLOO, (Object)analysis.getBaseDataSource());
        Assert.assertThrows(DruidException.class, () -> analysis.getBaseTableDataSource());
        Assert.assertEquals(Optional.empty(), (Object)analysis.getBaseUnionDataSource());
        Assert.assertEquals(Optional.empty(), (Object)analysis.getBaseQuery());
        Assert.assertThrows(DruidException.class, () -> analysis.getEffectiveQuerySegmentSpec());
        Assert.assertEquals(Optional.empty(), (Object)analysis.getJoinBaseTableFilter());
        Assert.assertEquals((Object)ImmutableList.of((Object)new PreJoinableClause(joinDataSource)), (Object)analysis.getPreJoinableClauses());
        Assert.assertTrue((boolean)analysis.isGlobal());
        Assert.assertTrue((boolean)analysis.isJoin());
        Assert.assertTrue((boolean)analysis.isBaseColumn("foo"));
        Assert.assertFalse((boolean)analysis.isBaseColumn("1.foo"));
    }

    @Test
    public void testJoinLookupToTable() {
        JoinDataSource joinDataSource = DataSourceAnalysisTest.join((DataSource)LOOKUP_LOOKYLOO, (DataSource)TABLE_FOO, "1.", JoinType.INNER);
        DataSourceAnalysis analysis = joinDataSource.getAnalysis();
        Assert.assertFalse((boolean)analysis.isConcreteBased());
        Assert.assertFalse((boolean)analysis.isTableBased());
        Assert.assertFalse((boolean)analysis.isConcreteAndTableBased());
        Assert.assertEquals((Object)LOOKUP_LOOKYLOO, (Object)analysis.getBaseDataSource());
        Assert.assertThrows(DruidException.class, () -> analysis.getBaseTableDataSource());
        Assert.assertEquals(Optional.empty(), (Object)analysis.getBaseUnionDataSource());
        Assert.assertEquals(Optional.empty(), (Object)analysis.getBaseQuery());
        Assert.assertThrows(DruidException.class, () -> analysis.getEffectiveQuerySegmentSpec());
        Assert.assertEquals(Optional.empty(), (Object)analysis.getJoinBaseTableFilter());
        Assert.assertEquals((Object)ImmutableList.of((Object)new PreJoinableClause(joinDataSource)), (Object)analysis.getPreJoinableClauses());
        Assert.assertFalse((boolean)analysis.isGlobal());
        Assert.assertTrue((boolean)analysis.isJoin());
        Assert.assertTrue((boolean)analysis.isBaseColumn("foo"));
        Assert.assertFalse((boolean)analysis.isBaseColumn("1.foo"));
    }

    @Test
    public void testEquals() {
        EqualsVerifier.forClass(DataSourceAnalysis.class).usingGetClass().withNonnullFields(new String[]{"baseDataSource"}).withIgnoredFields(new String[]{"baseQuery", "preJoinableClauses", "joinBaseTableFilter"}).verify();
    }

    private static JoinDataSource join(DataSource left, DataSource right, String rightPrefix, JoinType joinType, DimFilter dimFilter) {
        return JoinDataSource.create((DataSource)left, (DataSource)right, (String)rightPrefix, (String)DataSourceAnalysisTest.joinClause(rightPrefix).getOriginalExpression(), (JoinType)joinType, (DimFilter)dimFilter, (ExprMacroTable)ExprMacroTable.nil(), null, (JoinAlgorithm)JoinAlgorithm.BROADCAST);
    }

    private static JoinDataSource join(DataSource left, DataSource right, String rightPrefix, JoinType joinType) {
        return DataSourceAnalysisTest.join(left, right, rightPrefix, joinType, null);
    }

    private static JoinConditionAnalysis joinClause(String rightPrefix) {
        return JoinConditionAnalysis.forExpression((String)StringUtils.format((String)"x == \"%sx\"", (Object[])new Object[]{rightPrefix}), (String)rightPrefix, (ExprMacroTable)ExprMacroTable.nil());
    }

    private static QueryDataSource makeQueryDS(DataSource dataSource) {
        return new QueryDataSource((Query)DataSourceAnalysisTest.makeGroupByQuery(dataSource));
    }

    private static GroupByQuery makeGroupByQuery(DataSource dataSource) {
        return GroupByQuery.builder().setDataSource(dataSource).setInterval((QuerySegmentSpec)new MultipleIntervalSegmentSpec(MILLENIUM_INTERVALS)).setGranularity(Granularities.ALL).build();
    }

    private static ScanQuery makeScanQuery(DataSource dataSource) {
        return Druids.newScanQueryBuilder().dataSource(dataSource).intervals((QuerySegmentSpec)new MultipleIntervalSegmentSpec(MILLENIUM_INTERVALS)).build();
    }
}

