/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.http;

import com.fasterxml.jackson.databind.ObjectMapper;
import nl.jqno.equalsverifier.EqualsVerifier;
import org.apache.druid.error.DruidException;
import org.apache.druid.error.ErrorResponse;
import org.apache.druid.indexer.TaskState;
import org.apache.druid.query.http.SqlTaskStatus;
import org.apache.druid.segment.TestHelper;
import org.junit.Assert;
import org.junit.Test;

public class SqlTaskStatusTest {
    @Test
    public void testSerde() throws Exception {
        ObjectMapper mapper = TestHelper.makeJsonMapper();
        DruidException underlyingException = DruidException.forPersona((DruidException.Persona)DruidException.Persona.DEVELOPER).ofCategory(DruidException.Category.INVALID_INPUT).build("error message", new Object[0]);
        SqlTaskStatus status = new SqlTaskStatus("taskid", TaskState.FAILED, new ErrorResponse(underlyingException));
        SqlTaskStatus status2 = (SqlTaskStatus)mapper.readValue(mapper.writeValueAsString((Object)status), SqlTaskStatus.class);
        Assert.assertEquals((Object)status.getTaskId(), (Object)status2.getTaskId());
        Assert.assertEquals((Object)status.getState(), (Object)status2.getState());
        Assert.assertNotNull((Object)status.getError());
        Assert.assertNotNull((Object)status2.getError());
        Assert.assertEquals((Object)status.getError().getAsMap(), (Object)status2.getError().getAsMap());
    }

    @Test
    public void testEquals() {
        EqualsVerifier.forClass(SqlTaskStatus.class).usingGetClass().verify();
    }
}

