/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.groupby.epinephelinae;

import com.google.common.base.Suppliers;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.druid.data.input.MapBasedRow;
import org.apache.druid.data.input.Row;
import org.apache.druid.java.util.common.IAE;
import org.apache.druid.java.util.common.Pair;
import org.apache.druid.java.util.common.parsers.CloseableIterator;
import org.apache.druid.query.aggregation.AggregatorAdapters;
import org.apache.druid.query.aggregation.AggregatorFactory;
import org.apache.druid.query.aggregation.CountAggregatorFactory;
import org.apache.druid.query.aggregation.LongSumAggregatorFactory;
import org.apache.druid.query.dimension.DefaultDimensionSpec;
import org.apache.druid.query.groupby.epinephelinae.GroupByTestColumnSelectorFactory;
import org.apache.druid.query.groupby.epinephelinae.Grouper;
import org.apache.druid.query.groupby.epinephelinae.GrouperBufferComparatorUtils;
import org.apache.druid.query.groupby.epinephelinae.GrouperTestUtil;
import org.apache.druid.query.groupby.epinephelinae.IntKey;
import org.apache.druid.query.groupby.epinephelinae.IntKeySerde;
import org.apache.druid.query.groupby.epinephelinae.LimitedBufferHashGrouper;
import org.apache.druid.query.groupby.orderby.DefaultLimitSpec;
import org.apache.druid.query.groupby.orderby.OrderByColumnSpec;
import org.apache.druid.query.ordering.StringComparator;
import org.apache.druid.query.ordering.StringComparators;
import org.apache.druid.segment.ColumnSelectorFactory;
import org.apache.druid.testing.InitializedNullHandlingTest;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;

public class LimitedBufferHashGrouperTest
extends InitializedNullHandlingTest {
    static final int LIMIT = 100;
    static final int KEY_BASE = 100000;
    static final int NUM_ROWS = 1000;
    @Rule
    public ExpectedException expectedException = ExpectedException.none();

    @Test
    public void testLimitAndBufferSwapping() {
        int i;
        GroupByTestColumnSelectorFactory columnSelectorFactory = GrouperTestUtil.newColumnSelectorFactory();
        LimitedBufferHashGrouper<IntKey> grouper = LimitedBufferHashGrouperTest.makeGrouper(columnSelectorFactory, 20000);
        columnSelectorFactory.setRow((Row)new MapBasedRow(0L, (Map)ImmutableMap.of((Object)"value", (Object)10L)));
        for (i = 0; i < 1000; ++i) {
            Assert.assertTrue((String)String.valueOf(i + 100000), (boolean)grouper.aggregate((Object)new IntKey(i + 100000)).isOk());
        }
        Assert.assertEquals((long)13L, (long)grouper.getGrowthCount());
        Assert.assertEquals((long)116L, (long)grouper.getSize());
        Assert.assertEquals((long)337L, (long)grouper.getBuckets());
        Assert.assertEquals((long)168L, (long)grouper.getMaxSize());
        Assert.assertEquals((long)100L, (long)grouper.getLimit());
        columnSelectorFactory.setRow((Row)new MapBasedRow(0L, (Map)ImmutableMap.of((Object)"value", (Object)11L)));
        for (i = 0; i < 1000; ++i) {
            Assert.assertTrue((String)String.valueOf(i), (boolean)grouper.aggregate((Object)new IntKey(i)).isOk());
        }
        Assert.assertEquals((long)27L, (long)grouper.getGrowthCount());
        Assert.assertEquals((long)164L, (long)grouper.getSize());
        Assert.assertEquals((long)337L, (long)grouper.getBuckets());
        Assert.assertEquals((long)168L, (long)grouper.getMaxSize());
        Assert.assertEquals((long)100L, (long)grouper.getLimit());
        ArrayList<Pair> expected = new ArrayList<Pair>();
        for (int i2 = 0; i2 < 100; ++i2) {
            expected.add(Pair.of((Object)i2, (Object)ImmutableList.of((Object)11L, (Object)1L)));
        }
        Assert.assertEquals(expected, LimitedBufferHashGrouperTest.entriesToList((Iterator<Grouper.Entry<IntKey>>)grouper.iterator(true)));
        Assert.assertEquals(expected, LimitedBufferHashGrouperTest.entriesToList((Iterator<Grouper.Entry<IntKey>>)grouper.iterator(true)));
    }

    @Test
    public void testBufferTooSmall() {
        this.expectedException.expect(IAE.class);
        this.expectedException.expectMessage("LimitedBufferHashGrouper initialized with insufficient buffer capacity");
        GroupByTestColumnSelectorFactory columnSelectorFactory = GrouperTestUtil.newColumnSelectorFactory();
        LimitedBufferHashGrouperTest.makeGrouper(columnSelectorFactory, 10);
    }

    @Test
    public void testMinBufferSize() {
        int i;
        GroupByTestColumnSelectorFactory columnSelectorFactory = GrouperTestUtil.newColumnSelectorFactory();
        LimitedBufferHashGrouper<IntKey> grouper = LimitedBufferHashGrouperTest.makeGrouper(columnSelectorFactory, 12120);
        columnSelectorFactory.setRow((Row)new MapBasedRow(0L, (Map)ImmutableMap.of((Object)"value", (Object)10L)));
        for (i = 0; i < 1000; ++i) {
            Assert.assertTrue((String)String.valueOf(i + 100000), (boolean)grouper.aggregate((Object)new IntKey(i + 100000)).isOk());
        }
        Assert.assertEquals((long)899L, (long)grouper.getGrowthCount());
        Assert.assertEquals((long)101L, (long)grouper.getSize());
        Assert.assertEquals((long)202L, (long)grouper.getBuckets());
        Assert.assertEquals((long)101L, (long)grouper.getMaxSize());
        Assert.assertEquals((long)100L, (long)grouper.getLimit());
        columnSelectorFactory.setRow((Row)new MapBasedRow(0L, (Map)ImmutableMap.of((Object)"value", (Object)11L)));
        for (i = 0; i < 1000; ++i) {
            Assert.assertTrue((String)String.valueOf(i), (boolean)grouper.aggregate((Object)new IntKey(i)).isOk());
        }
        Assert.assertEquals((long)1899L, (long)grouper.getGrowthCount());
        Assert.assertEquals((long)101L, (long)grouper.getSize());
        Assert.assertEquals((long)202L, (long)grouper.getBuckets());
        Assert.assertEquals((long)101L, (long)grouper.getMaxSize());
        Assert.assertEquals((long)100L, (long)grouper.getLimit());
        ArrayList<Pair> expected = new ArrayList<Pair>();
        for (int i2 = 0; i2 < 100; ++i2) {
            expected.add(Pair.of((Object)i2, (Object)ImmutableList.of((Object)11L, (Object)1L)));
        }
        Assert.assertEquals(expected, LimitedBufferHashGrouperTest.entriesToList((Iterator<Grouper.Entry<IntKey>>)grouper.iterator(true)));
        Assert.assertEquals(expected, LimitedBufferHashGrouperTest.entriesToList((Iterator<Grouper.Entry<IntKey>>)grouper.iterator(true)));
    }

    @Test
    public void testAggregateAfterIterated() {
        this.expectedException.expect(IllegalStateException.class);
        this.expectedException.expectMessage("attempted to add offset after grouper was iterated");
        GroupByTestColumnSelectorFactory columnSelectorFactory = GrouperTestUtil.newColumnSelectorFactory();
        LimitedBufferHashGrouper<IntKey> grouper = LimitedBufferHashGrouperTest.makeGrouper(columnSelectorFactory, 12120);
        columnSelectorFactory.setRow((Row)new MapBasedRow(0L, (Map)ImmutableMap.of((Object)"value", (Object)10L)));
        for (int i = 0; i < 1000; ++i) {
            Assert.assertTrue((String)String.valueOf(i + 100000), (boolean)grouper.aggregate((Object)new IntKey(i + 100000)).isOk());
        }
        ArrayList iterated = Lists.newArrayList((Iterator)grouper.iterator(true));
        Assert.assertEquals((long)100L, (long)iterated.size());
        grouper.aggregate((Object)new IntKey(101001));
    }

    @Test
    public void testIteratorOrderByDim() {
        GroupByTestColumnSelectorFactory columnSelectorFactory = GrouperTestUtil.newColumnSelectorFactory();
        LimitedBufferHashGrouper<IntKey> grouper = LimitedBufferHashGrouperTest.makeGrouperWithOrderBy(columnSelectorFactory, "value", OrderByColumnSpec.Direction.ASCENDING);
        for (int i = 0; i < 1000; ++i) {
            columnSelectorFactory.setRow((Row)new MapBasedRow(0L, (Map)ImmutableMap.of((Object)"value", (Object)(1000 - i + 100000))));
            Assert.assertTrue((String)String.valueOf(1000 - i + 100000), (boolean)grouper.aggregate((Object)new IntKey(1000 - i + 100000)).isOk());
        }
        CloseableIterator iterator = grouper.iterator(true);
        int i = 0;
        while (iterator.hasNext()) {
            Grouper.Entry entry = (Grouper.Entry)iterator.next();
            Assert.assertEquals((Object)((long)(100000 + i) + 1L), (Object)entry.getValues()[0]);
            ++i;
        }
        Assert.assertEquals((long)100L, (long)i);
    }

    @Test
    public void testIteratorOrderByDimDesc() {
        GroupByTestColumnSelectorFactory columnSelectorFactory = GrouperTestUtil.newColumnSelectorFactory();
        LimitedBufferHashGrouper<IntKey> grouper = LimitedBufferHashGrouperTest.makeGrouperWithOrderBy(columnSelectorFactory, "value", OrderByColumnSpec.Direction.DESCENDING);
        for (int i = 0; i < 1000; ++i) {
            columnSelectorFactory.setRow((Row)new MapBasedRow(0L, (Map)ImmutableMap.of((Object)"value", (Object)(i + 1))));
            Assert.assertTrue((String)String.valueOf(i + 100000), (boolean)grouper.aggregate((Object)new IntKey(i + 100000)).isOk());
        }
        CloseableIterator iterator = grouper.iterator(true);
        int i = 0;
        while (iterator.hasNext()) {
            Grouper.Entry entry = (Grouper.Entry)iterator.next();
            Assert.assertEquals((Object)(1000L - (long)i), (Object)entry.getValues()[0]);
            ++i;
        }
    }

    @Test
    public void testIteratorOrderByAggs() {
        GroupByTestColumnSelectorFactory columnSelectorFactory = GrouperTestUtil.newColumnSelectorFactory();
        LimitedBufferHashGrouper<IntKey> grouper = LimitedBufferHashGrouperTest.makeGrouperWithOrderBy(columnSelectorFactory, "valueSum", OrderByColumnSpec.Direction.ASCENDING);
        for (int i = 0; i < 1000; ++i) {
            columnSelectorFactory.setRow((Row)new MapBasedRow(0L, (Map)ImmutableMap.of((Object)"value", (Object)(1000 - i))));
            Assert.assertTrue((String)String.valueOf(1000 - i + 100000), (boolean)grouper.aggregate((Object)new IntKey(1000 - i + 100000)).isOk());
        }
        CloseableIterator iterator = grouper.iterator(true);
        int i = 0;
        while (iterator.hasNext()) {
            Grouper.Entry entry = (Grouper.Entry)iterator.next();
            Assert.assertEquals((Object)((long)i + 1L), (Object)entry.getValues()[0]);
            ++i;
        }
        Assert.assertEquals((long)100L, (long)i);
    }

    @Test
    public void testIteratorOrderByAggsDesc() {
        GroupByTestColumnSelectorFactory columnSelectorFactory = GrouperTestUtil.newColumnSelectorFactory();
        LimitedBufferHashGrouper<IntKey> grouper = LimitedBufferHashGrouperTest.makeGrouperWithOrderBy(columnSelectorFactory, "valueSum", OrderByColumnSpec.Direction.DESCENDING);
        for (int i = 0; i < 1000; ++i) {
            columnSelectorFactory.setRow((Row)new MapBasedRow(0L, (Map)ImmutableMap.of((Object)"value", (Object)(i + 1))));
            Assert.assertTrue((String)String.valueOf(1000 - i + 100000), (boolean)grouper.aggregate((Object)new IntKey(1000 - i + 100000)).isOk());
        }
        CloseableIterator iterator = grouper.iterator(true);
        int i = 0;
        while (iterator.hasNext()) {
            Grouper.Entry entry = (Grouper.Entry)iterator.next();
            Assert.assertEquals((Object)(1000L - (long)i), (Object)entry.getValues()[0]);
            ++i;
        }
        Assert.assertEquals((long)100L, (long)i);
    }

    private static LimitedBufferHashGrouper<IntKey> makeGrouper(GroupByTestColumnSelectorFactory columnSelectorFactory, int bufferSize) {
        LimitedBufferHashGrouper grouper = new LimitedBufferHashGrouper(Suppliers.ofInstance((Object)ByteBuffer.allocate(bufferSize)), GrouperTestUtil.intKeySerde(), AggregatorAdapters.factorizeBuffered((ColumnSelectorFactory)columnSelectorFactory, (List)ImmutableList.of((Object)new LongSumAggregatorFactory("valueSum", "value"), (Object)new CountAggregatorFactory("count"))), Integer.MAX_VALUE, 0.5f, 2, 100, false);
        grouper.init();
        return grouper;
    }

    private static LimitedBufferHashGrouper<IntKey> makeGrouperWithOrderBy(GroupByTestColumnSelectorFactory columnSelectorFactory, String orderByColumn, OrderByColumnSpec.Direction direction) {
        StringComparator stringComparator = "value".equals(orderByColumn) ? StringComparators.LEXICOGRAPHIC : StringComparators.NUMERIC;
        DefaultLimitSpec orderBy = DefaultLimitSpec.builder().orderBy(new OrderByColumnSpec[]{new OrderByColumnSpec(orderByColumn, direction, stringComparator)}).limit(100).build();
        LimitedBufferHashGrouper grouper = new LimitedBufferHashGrouper(Suppliers.ofInstance((Object)ByteBuffer.allocate(12120)), (Grouper.KeySerde)new GroupByIshKeySerde(orderBy), AggregatorAdapters.factorizeBuffered((ColumnSelectorFactory)columnSelectorFactory, (List)ImmutableList.of((Object)new LongSumAggregatorFactory("valueSum", "value"), (Object)new CountAggregatorFactory("count"))), Integer.MAX_VALUE, 0.5f, 2, 100, !((OrderByColumnSpec)orderBy.getColumns().get(0)).getDimension().equals("value"));
        grouper.init();
        return grouper;
    }

    private static List<Pair<Integer, List<Object>>> entriesToList(Iterator<Grouper.Entry<IntKey>> entryIterator) {
        ArrayList<Pair<Integer, List<Object>>> retVal = new ArrayList<Pair<Integer, List<Object>>>();
        while (entryIterator.hasNext()) {
            Grouper.Entry<IntKey> entry = entryIterator.next();
            retVal.add((Pair<Integer, List<Object>>)Pair.of((Object)((IntKey)entry.getKey()).intValue(), (Object)ImmutableList.copyOf(Arrays.asList(entry.getValues()))));
        }
        return retVal;
    }

    private static class GroupByIshKeySerde
    extends IntKeySerde {
        private final DefaultLimitSpec orderBy;

        public GroupByIshKeySerde(DefaultLimitSpec orderBy) {
            this.orderBy = orderBy;
        }

        @Override
        public Grouper.BufferComparator bufferComparator() {
            return GrouperBufferComparatorUtils.bufferComparator((boolean)false, (boolean)false, (int)1, (Grouper.BufferComparator[])new Grouper.BufferComparator[]{KEY_COMPARATOR});
        }

        @Override
        public Grouper.BufferComparator bufferComparatorWithAggregators(AggregatorFactory[] aggregatorFactories, int[] aggregatorOffsets) {
            return GrouperBufferComparatorUtils.bufferComparatorWithAggregators((AggregatorFactory[])aggregatorFactories, (int[])aggregatorOffsets, (DefaultLimitSpec)this.orderBy, (List)ImmutableList.of((Object)DefaultDimensionSpec.of((String)"value")), (Grouper.BufferComparator[])new Grouper.BufferComparator[]{KEY_COMPARATOR}, (boolean)false, (boolean)false, (int)4);
        }
    }
}

