/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.groupby;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import org.apache.druid.query.QueryRunnerTestHelper;
import org.apache.druid.query.aggregation.AggregatorFactory;
import org.apache.druid.query.aggregation.DoubleMaxAggregatorFactory;
import org.apache.druid.query.dimension.DefaultDimensionSpec;
import org.apache.druid.query.dimension.DimensionSpec;
import org.apache.druid.query.groupby.GroupByQuery;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class GroupByQueryBuilderTest {
    private GroupByQuery.Builder builder;

    @Before
    public void setup() {
        this.builder = new GroupByQuery.Builder().setDataSource("testing").setGranularity(QueryRunnerTestHelper.ALL_GRAN).setQuerySegmentSpec(QueryRunnerTestHelper.EMPTY_INTERVAL).setDimensions(new DimensionSpec[]{new DefaultDimensionSpec("market", "market")}).setAggregatorSpecs(new AggregatorFactory[]{new DoubleMaxAggregatorFactory("index", "index")});
    }

    @Test
    public void testQueryIdWhenContextInBuilderIsNullReturnContextContainingQueryId() {
        GroupByQuery query = this.builder.queryId("queryId").build();
        Assert.assertEquals((Object)ImmutableMap.of((Object)"queryId", (Object)"queryId"), (Object)query.getContext());
    }

    @Test
    public void testQueryIdWhenBuilderHasNonnullContextWithoutQueryIdReturnMergedContext() {
        GroupByQuery query = this.builder.setContext((Map)ImmutableMap.of((Object)"my", (Object)"context")).queryId("queryId").build();
        Assert.assertEquals((Object)ImmutableMap.of((Object)"queryId", (Object)"queryId", (Object)"my", (Object)"context"), (Object)query.getContext());
    }

    @Test
    public void testQueryIdWhenBuilderHasNonnullContextWithQueryIdReturnMergedContext() {
        GroupByQuery query = this.builder.setContext((Map)ImmutableMap.of((Object)"my", (Object)"context", (Object)"queryId", (Object)"queryId")).queryId("realQueryId").build();
        Assert.assertEquals((Object)ImmutableMap.of((Object)"queryId", (Object)"realQueryId", (Object)"my", (Object)"context"), (Object)query.getContext());
    }

    @Test
    public void testContextAfterSettingQueryIdReturnContextWithoutQueryId() {
        GroupByQuery query = this.builder.queryId("queryId").setContext((Map)ImmutableMap.of((Object)"my", (Object)"context")).build();
        Assert.assertEquals((Object)ImmutableMap.of((Object)"my", (Object)"context"), (Object)query.getContext());
    }

    @Test
    public void testContextContainingQueryIdAfterSettingQueryIdOverwriteQueryId() {
        GroupByQuery query = this.builder.queryId("queryId").setContext((Map)ImmutableMap.of((Object)"my", (Object)"context", (Object)"queryId", (Object)"realQueryId")).build();
        Assert.assertEquals((Object)ImmutableMap.of((Object)"queryId", (Object)"realQueryId", (Object)"my", (Object)"context"), (Object)query.getContext());
    }
}

