/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.filter;

import com.fasterxml.jackson.core.JsonProcessingException;
import java.util.Arrays;
import nl.jqno.equalsverifier.EqualsVerifier;
import org.apache.druid.error.DruidException;
import org.apache.druid.jackson.DefaultObjectMapper;
import org.apache.druid.query.filter.DimFilter;
import org.apache.druid.query.filter.EqualityFilter;
import org.apache.druid.query.filter.FilterTuning;
import org.apache.druid.query.filter.IsFalseDimFilter;
import org.apache.druid.query.filter.IsTrueDimFilter;
import org.apache.druid.segment.column.ColumnType;
import org.apache.druid.testing.InitializedNullHandlingTest;
import org.junit.Assert;
import org.junit.Test;

public class IsBooleanDimFilterTest
extends InitializedNullHandlingTest {
    @Test
    public void testSerde() throws JsonProcessingException {
        DefaultObjectMapper mapper = new DefaultObjectMapper();
        EqualityFilter baseFilter = new EqualityFilter("x", ColumnType.STRING, (Object)"hello", null);
        IsTrueDimFilter trueFilter = IsTrueDimFilter.of((DimFilter)baseFilter);
        String s = mapper.writeValueAsString((Object)trueFilter);
        Assert.assertEquals((Object)trueFilter, (Object)mapper.readValue(s, IsTrueDimFilter.class));
        IsFalseDimFilter falseFilter = IsFalseDimFilter.of((DimFilter)baseFilter);
        s = mapper.writeValueAsString((Object)falseFilter);
        Assert.assertEquals((Object)falseFilter, (Object)mapper.readValue(s, IsFalseDimFilter.class));
    }

    @Test
    public void testGetCacheKey() {
        IsTrueDimFilter f1 = IsTrueDimFilter.of((DimFilter)new EqualityFilter("x", ColumnType.STRING, (Object)"hello", null));
        IsTrueDimFilter f1_2 = IsTrueDimFilter.of((DimFilter)new EqualityFilter("x", ColumnType.STRING, (Object)"hello", null));
        IsFalseDimFilter f1_3 = IsFalseDimFilter.of((DimFilter)new EqualityFilter("x", ColumnType.STRING, (Object)"hello", null));
        IsFalseDimFilter f1_4 = IsFalseDimFilter.of((DimFilter)new EqualityFilter("x", ColumnType.STRING, (Object)"hello", null));
        IsTrueDimFilter f2 = IsTrueDimFilter.of((DimFilter)new EqualityFilter("x", ColumnType.STRING, (Object)"world", null));
        IsTrueDimFilter f3 = IsTrueDimFilter.of((DimFilter)new EqualityFilter("x", ColumnType.STRING, (Object)"hello", new FilterTuning(Boolean.valueOf(true), null, null)));
        Assert.assertArrayEquals((byte[])f1.getCacheKey(), (byte[])f1_2.getCacheKey());
        Assert.assertFalse((boolean)Arrays.equals(f1.getCacheKey(), f1_3.getCacheKey()));
        Assert.assertArrayEquals((byte[])f1_3.getCacheKey(), (byte[])f1_4.getCacheKey());
        Assert.assertFalse((boolean)Arrays.equals(f1.getCacheKey(), f2.getCacheKey()));
        Assert.assertArrayEquals((byte[])f1.getCacheKey(), (byte[])f3.getCacheKey());
    }

    @Test
    public void testInvalidParameters() {
        Throwable t = Assert.assertThrows(DruidException.class, () -> new IsTrueDimFilter(null));
        Assert.assertEquals((Object)"IS TRUE operator requires a non-null filter for field", (Object)t.getMessage());
        t = Assert.assertThrows(DruidException.class, () -> new IsFalseDimFilter(null));
        Assert.assertEquals((Object)"IS FALSE operator requires a non-null filter for field", (Object)t.getMessage());
    }

    @Test
    public void test_equals() {
        EqualsVerifier.forClass(IsTrueDimFilter.class).usingGetClass().withNonnullFields(new String[]{"field"}).withIgnoredFields(new String[]{"optimizedFilterIncludeUnknown", "optimizedFilterNoIncludeUnknown"}).verify();
        EqualsVerifier.forClass(IsFalseDimFilter.class).usingGetClass().withNonnullFields(new String[]{"field"}).withIgnoredFields(new String[]{"optimizedFilterIncludeUnknown", "optimizedFilterNoIncludeUnknown"}).verify();
    }
}

