/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.extraction;

import com.fasterxml.jackson.databind.InjectableValues;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Sets;
import java.util.Arrays;
import java.util.LinkedHashSet;
import nl.jqno.equalsverifier.EqualsVerifier;
import org.apache.druid.jackson.DefaultObjectMapper;
import org.apache.druid.js.JavaScriptConfig;
import org.apache.druid.query.extraction.CascadeExtractionFn;
import org.apache.druid.query.extraction.ExtractionFn;
import org.apache.druid.query.extraction.JavaScriptExtractionFn;
import org.apache.druid.query.extraction.RegexDimExtractionFn;
import org.apache.druid.query.extraction.StrlenExtractionFn;
import org.apache.druid.query.extraction.SubstringDimExtractionFn;
import org.apache.druid.testing.InitializedNullHandlingTest;
import org.junit.Assert;
import org.junit.Test;

public class CascadeExtractionFnTest
extends InitializedNullHandlingTest {
    private static final String[] PATHS = new String[]{"/druid/prod/historical", "/druid/prod/broker", "/druid/prod/coordinator", "/druid/demo/historical", "/druid/demo/broker", "/druid/demo/coordinator", "/dash/aloe", "/dash/baloo"};
    private final String regex = "/([^/]+)/";
    private final String function = "function(str) { return \"the \".concat(str) }";
    private final RegexDimExtractionFn regexDimExtractionFn = new RegexDimExtractionFn("/([^/]+)/", Boolean.valueOf(false), null);
    private final JavaScriptExtractionFn javascriptExtractionFn = new JavaScriptExtractionFn("function(str) { return \"the \".concat(str) }", true, JavaScriptConfig.getEnabledInstance());
    private final SubstringDimExtractionFn substringDimExtractionFn = new SubstringDimExtractionFn(0, Integer.valueOf(7));
    private final String regexDimExtractionFnJson = "{ \"type\" : \"regex\", \"expr\" : \"/([^/]+)/\" , \"replaceMissingValue\": false, \"replaceMissingValueWith\": null}";
    private final String javascriptExtractionFnJson = "{ \"type\" : \"javascript\", \"function\" : \"function(str) { return \\\"the \\\".concat(str) }\" }";
    private final String substringDimExtractionFnJson = "{ \"type\" : \"substring\", \"index\" : 0, \"length\" : 7 }";

    @Test
    public void testRegexAndJavascriptAndSubstring() {
        ExtractionFn[] fns = new ExtractionFn[]{this.regexDimExtractionFn, this.javascriptExtractionFn, this.substringDimExtractionFn};
        CascadeExtractionFn cascadeExtractionFn = new CascadeExtractionFn(fns);
        LinkedHashSet<String> extracted = new LinkedHashSet<String>();
        for (String path : PATHS) {
            extracted.add(cascadeExtractionFn.apply(path));
        }
        LinkedHashSet expected = Sets.newLinkedHashSet((Iterable)ImmutableList.of((Object)"the dru", (Object)"the das"));
        Assert.assertEquals((Object)expected, extracted);
    }

    @Test
    public void testGetCacheKey() {
        ExtractionFn[] fns1 = new ExtractionFn[]{this.javascriptExtractionFn, this.regexDimExtractionFn};
        CascadeExtractionFn cascadeExtractionFn1 = new CascadeExtractionFn(fns1);
        ExtractionFn[] fns2 = new ExtractionFn[]{this.regexDimExtractionFn, this.javascriptExtractionFn};
        CascadeExtractionFn cascadeExtractionFn2 = new CascadeExtractionFn(fns2);
        ExtractionFn[] fns3 = new ExtractionFn[]{this.regexDimExtractionFn, this.javascriptExtractionFn, this.substringDimExtractionFn};
        CascadeExtractionFn cascadeExtractionFn3 = new CascadeExtractionFn(fns3);
        Assert.assertFalse((boolean)Arrays.equals(cascadeExtractionFn1.getCacheKey(), cascadeExtractionFn2.getCacheKey()));
        Assert.assertFalse((boolean)Arrays.equals(cascadeExtractionFn1.getCacheKey(), cascadeExtractionFn3.getCacheKey()));
        Assert.assertFalse((boolean)Arrays.equals(cascadeExtractionFn2.getCacheKey(), cascadeExtractionFn3.getCacheKey()));
    }

    @Test
    public void testHashCode() {
        ExtractionFn[] fns1 = new ExtractionFn[]{this.javascriptExtractionFn, this.regexDimExtractionFn};
        CascadeExtractionFn cascadeExtractionFn1 = new CascadeExtractionFn(fns1);
        ExtractionFn[] fns2 = new ExtractionFn[]{this.regexDimExtractionFn, this.javascriptExtractionFn};
        CascadeExtractionFn cascadeExtractionFn2 = new CascadeExtractionFn(fns2);
        ExtractionFn[] fns3 = new ExtractionFn[]{this.regexDimExtractionFn, this.javascriptExtractionFn, this.substringDimExtractionFn};
        CascadeExtractionFn cascadeExtractionFn3 = new CascadeExtractionFn(fns3);
        Assert.assertNotEquals((long)cascadeExtractionFn1.hashCode(), (long)cascadeExtractionFn2.hashCode());
        Assert.assertNotEquals((long)cascadeExtractionFn1.hashCode(), (long)cascadeExtractionFn3.hashCode());
        Assert.assertNotEquals((long)cascadeExtractionFn2.hashCode(), (long)cascadeExtractionFn3.hashCode());
    }

    @Test
    public void testPreservesOrdering() {
        ExtractionFn[] fns1 = new ExtractionFn[]{this.substringDimExtractionFn};
        CascadeExtractionFn cascadeExtractionFn1 = new CascadeExtractionFn(fns1);
        ExtractionFn[] fns2 = new ExtractionFn[]{this.regexDimExtractionFn, this.substringDimExtractionFn};
        CascadeExtractionFn cascadeExtractionFn2 = new CascadeExtractionFn(fns2);
        ExtractionFn[] fns3 = new ExtractionFn[]{this.substringDimExtractionFn, this.javascriptExtractionFn};
        CascadeExtractionFn cascadeExtractionFn3 = new CascadeExtractionFn(fns3);
        Assert.assertTrue((boolean)cascadeExtractionFn1.preservesOrdering());
        Assert.assertFalse((boolean)cascadeExtractionFn2.preservesOrdering());
        Assert.assertFalse((boolean)cascadeExtractionFn3.preservesOrdering());
    }

    @Test
    public void testGetExtractionType() {
        ExtractionFn[] fns1 = new ExtractionFn[]{this.javascriptExtractionFn};
        CascadeExtractionFn cascadeExtractionFn1 = new CascadeExtractionFn(fns1);
        ExtractionFn[] fns2 = new ExtractionFn[]{this.regexDimExtractionFn, this.javascriptExtractionFn};
        CascadeExtractionFn cascadeExtractionFn2 = new CascadeExtractionFn(fns2);
        Assert.assertTrue((cascadeExtractionFn1.getExtractionType() == ExtractionFn.ExtractionType.ONE_TO_ONE ? 1 : 0) != 0);
        Assert.assertTrue((cascadeExtractionFn2.getExtractionType() == ExtractionFn.ExtractionType.MANY_TO_ONE ? 1 : 0) != 0);
    }

    @Test
    public void testSerde() throws Exception {
        DefaultObjectMapper objectMapper = new DefaultObjectMapper();
        objectMapper.setInjectableValues((InjectableValues)new InjectableValues.Std().addValue(JavaScriptConfig.class, (Object)JavaScriptConfig.getEnabledInstance()));
        String json = "{\"type\" : \"cascade\", \"extractionFns\": [{ \"type\" : \"regex\", \"expr\" : \"/([^/]+)/\" , \"replaceMissingValue\": false, \"replaceMissingValueWith\": null},{ \"type\" : \"javascript\", \"function\" : \"function(str) { return \\\"the \\\".concat(str) }\" },{ \"type\" : \"substring\", \"index\" : 0, \"length\" : 7 }]}";
        CascadeExtractionFn cascadeExtractionFn = (CascadeExtractionFn)objectMapper.readValue("{\"type\" : \"cascade\", \"extractionFns\": [{ \"type\" : \"regex\", \"expr\" : \"/([^/]+)/\" , \"replaceMissingValue\": false, \"replaceMissingValueWith\": null},{ \"type\" : \"javascript\", \"function\" : \"function(str) { return \\\"the \\\".concat(str) }\" },{ \"type\" : \"substring\", \"index\" : 0, \"length\" : 7 }]}", ExtractionFn.class);
        RegexDimExtractionFn regexDimExtractionFn = (RegexDimExtractionFn)objectMapper.readValue("{ \"type\" : \"regex\", \"expr\" : \"/([^/]+)/\" , \"replaceMissingValue\": false, \"replaceMissingValueWith\": null}", ExtractionFn.class);
        JavaScriptExtractionFn javascriptExtractionFn = (JavaScriptExtractionFn)objectMapper.readValue("{ \"type\" : \"javascript\", \"function\" : \"function(str) { return \\\"the \\\".concat(str) }\" }", ExtractionFn.class);
        SubstringDimExtractionFn substringDimExtractionFn = (SubstringDimExtractionFn)objectMapper.readValue("{ \"type\" : \"substring\", \"index\" : 0, \"length\" : 7 }", ExtractionFn.class);
        Assert.assertEquals((Object)regexDimExtractionFn, (Object)cascadeExtractionFn.getExtractionFns()[0]);
        Assert.assertEquals((Object)javascriptExtractionFn, (Object)cascadeExtractionFn.getExtractionFns()[1]);
        Assert.assertEquals((Object)substringDimExtractionFn, (Object)cascadeExtractionFn.getExtractionFns()[2]);
        Assert.assertEquals((Object)cascadeExtractionFn, (Object)objectMapper.readValue(objectMapper.writeValueAsBytes((Object)cascadeExtractionFn), ExtractionFn.class));
    }

    @Test
    public void testEqualsContract() {
        EqualsVerifier.forClass(CascadeExtractionFn.class).withPrefabValues(CascadeExtractionFn.ChainedExtractionFn.class, (Object)CascadeExtractionFn.DEFAULT_CHAINED_EXTRACTION_FN, (Object)new CascadeExtractionFn.ChainedExtractionFn((ExtractionFn)StrlenExtractionFn.instance(), CascadeExtractionFn.DEFAULT_CHAINED_EXTRACTION_FN)).withNonnullFields(new String[]{"chainedExtractionFn"}).usingGetClass().verify();
    }

    @Test
    public void testEqualsContractForChainedExtractionFn() {
        EqualsVerifier.forClass(CascadeExtractionFn.ChainedExtractionFn.class).withPrefabValues(CascadeExtractionFn.ChainedExtractionFn.class, (Object)CascadeExtractionFn.DEFAULT_CHAINED_EXTRACTION_FN, (Object)new CascadeExtractionFn.ChainedExtractionFn((ExtractionFn)StrlenExtractionFn.instance(), CascadeExtractionFn.DEFAULT_CHAINED_EXTRACTION_FN)).withNonnullFields(new String[]{"fn"}).usingGetClass().verify();
    }
}

