/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.expression;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.compress.utils.Sets;
import org.apache.druid.math.expr.Expr;
import org.apache.druid.math.expr.ExprEval;
import org.apache.druid.math.expr.ExprMacroTable;
import org.apache.druid.query.expression.LookupExprMacro;
import org.apache.druid.query.expression.MacroTestBase;
import org.apache.druid.query.lookup.LookupExtractorFactoryContainer;
import org.apache.druid.query.lookup.LookupExtractorFactoryContainerProvider;
import org.junit.Assert;
import org.junit.Test;

public class LookupExprMacroTest
extends MacroTestBase {
    public LookupExprMacroTest() {
        super((ExprMacroTable.ExprMacro)new LookupExprMacro(new LookupExtractorFactoryContainerProvider(){

            public Set<String> getAllLookupNames() {
                return Sets.newHashSet((Object[])new String[]{"test_lookup"});
            }

            public Optional<LookupExtractorFactoryContainer> get(String lookupName) {
                return Optional.empty();
            }

            public String getCanonicalLookupName(String lookupName) {
                return lookupName;
            }
        }));
    }

    @Test
    public void testTooFewArgs() {
        this.expectException(IllegalArgumentException.class, "Function[lookup] requires 2 to 3 arguments");
        this.apply(Collections.emptyList());
    }

    @Test
    public void testNonLiteralLookupName() {
        this.expectException(IllegalArgumentException.class, "Function[lookup] second argument must be a registered lookup name");
        this.apply(this.getArgs(Lists.newArrayList((Object[])new Object[]{"1", new ArrayList()})));
    }

    @Test
    public void testValidCalls() {
        Assert.assertNotNull((Object)this.apply(this.getArgs(Lists.newArrayList((Object[])new Object[]{"1", "test_lookup"}))));
        Assert.assertNotNull((Object)this.apply(this.getArgs(Lists.newArrayList((Object[])new Object[]{"null", "test_lookup"}))));
        Assert.assertNotNull((Object)this.apply(this.getArgs(Lists.newArrayList((Object[])new Object[]{"1", "test_lookup", null}))));
        Assert.assertNotNull((Object)this.apply(this.getArgs(Lists.newArrayList((Object[])new Object[]{"1", "test_lookup", "N/A"}))));
    }

    private List<Expr> getArgs(List<Object> args) {
        return args.stream().map(a -> {
            if (a != null && a instanceof String) {
                return ExprEval.of((String)a.toString()).toExpr();
            }
            return ExprEval.bestEffortOf(null).toExpr();
        }).collect(Collectors.toList());
    }
}

