/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Map;
import org.apache.druid.java.util.common.Intervals;
import org.apache.druid.java.util.common.granularity.Granularities;
import org.apache.druid.query.Druids;
import org.apache.druid.query.SegmentDescriptor;
import org.apache.druid.query.search.SearchQuery;
import org.apache.druid.query.spec.MultipleSpecificSegmentSpec;
import org.apache.druid.query.spec.QuerySegmentSpec;
import org.apache.druid.query.timeboundary.TimeBoundaryQuery;
import org.apache.druid.query.timeseries.TimeseriesQuery;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class DruidsTest {
    private static final String DATASOURCE = "datasource";
    private static final QuerySegmentSpec QUERY_SEGMENT_SPEC = new MultipleSpecificSegmentSpec((List)ImmutableList.of((Object)new SegmentDescriptor(Intervals.of((String)"2000/3000"), "0", 0), (Object)new SegmentDescriptor(Intervals.of((String)"2000/3000"), "0", 1)));

    public static class TimeBoundaryBuilderTest {
        private Druids.TimeBoundaryQueryBuilder builder;

        @Before
        public void setup() {
            this.builder = Druids.newTimeBoundaryQueryBuilder().dataSource(DruidsTest.DATASOURCE).intervals(QUERY_SEGMENT_SPEC);
        }

        @Test
        public void testQueryIdWhenContextInBuilderIsNullReturnContextContainingQueryId() {
            TimeBoundaryQuery query = this.builder.queryId("queryId").build();
            Assert.assertEquals((Object)ImmutableMap.of((Object)"queryId", (Object)"queryId"), (Object)query.getContext());
        }

        @Test
        public void testQueryIdWhenBuilderHasNonnullContextWithoutQueryIdReturnMergedContext() {
            TimeBoundaryQuery query = this.builder.context((Map)ImmutableMap.of((Object)"my", (Object)"context")).queryId("queryId").build();
            Assert.assertEquals((Object)ImmutableMap.of((Object)"queryId", (Object)"queryId", (Object)"my", (Object)"context"), (Object)query.getContext());
        }

        @Test
        public void testQueryIdWhenBuilderHasNonnullContextWithQueryIdReturnMergedContext() {
            TimeBoundaryQuery query = this.builder.context((Map)ImmutableMap.of((Object)"my", (Object)"context", (Object)"queryId", (Object)"queryId")).queryId("realQueryId").build();
            Assert.assertEquals((Object)ImmutableMap.of((Object)"queryId", (Object)"realQueryId", (Object)"my", (Object)"context"), (Object)query.getContext());
        }

        @Test
        public void testContextAfterSettingQueryIdReturnContextWithoutQueryId() {
            TimeBoundaryQuery query = this.builder.queryId("queryId").context((Map)ImmutableMap.of((Object)"my", (Object)"context")).build();
            Assert.assertEquals((Object)ImmutableMap.of((Object)"my", (Object)"context"), (Object)query.getContext());
        }

        @Test
        public void testContextContainingQueryIdAfterSettingQueryIdOverwriteQueryId() {
            TimeBoundaryQuery query = this.builder.queryId("queryId").context((Map)ImmutableMap.of((Object)"my", (Object)"context", (Object)"queryId", (Object)"realQueryId")).build();
            Assert.assertEquals((Object)ImmutableMap.of((Object)"queryId", (Object)"realQueryId", (Object)"my", (Object)"context"), (Object)query.getContext());
        }
    }

    public static class SearchQueryBuilderTest {
        private Druids.SearchQueryBuilder builder;

        @Before
        public void setup() {
            this.builder = Druids.newSearchQueryBuilder().dataSource(DruidsTest.DATASOURCE).intervals(QUERY_SEGMENT_SPEC).granularity(Granularities.ALL);
        }

        @Test
        public void testQueryIdWhenContextInBuilderIsNullReturnContextContainingQueryId() {
            SearchQuery query = this.builder.queryId("queryId").build();
            Assert.assertEquals((Object)ImmutableMap.of((Object)"queryId", (Object)"queryId"), (Object)query.getContext());
        }

        @Test
        public void testQueryIdWhenBuilderHasNonnullContextWithoutQueryIdReturnMergedContext() {
            SearchQuery query = this.builder.context((Map)ImmutableMap.of((Object)"my", (Object)"context")).queryId("queryId").build();
            Assert.assertEquals((Object)ImmutableMap.of((Object)"queryId", (Object)"queryId", (Object)"my", (Object)"context"), (Object)query.getContext());
        }

        @Test
        public void testQueryIdWhenBuilderHasNonnullContextWithQueryIdReturnMergedContext() {
            SearchQuery query = this.builder.context((Map)ImmutableMap.of((Object)"my", (Object)"context", (Object)"queryId", (Object)"queryId")).queryId("realQueryId").build();
            Assert.assertEquals((Object)ImmutableMap.of((Object)"queryId", (Object)"realQueryId", (Object)"my", (Object)"context"), (Object)query.getContext());
        }

        @Test
        public void testContextAfterSettingQueryIdReturnContextWithoutQueryId() {
            SearchQuery query = this.builder.queryId("queryId").context((Map)ImmutableMap.of((Object)"my", (Object)"context")).build();
            Assert.assertEquals((Object)ImmutableMap.of((Object)"my", (Object)"context"), (Object)query.getContext());
        }

        @Test
        public void testContextContainingQueryIdAfterSettingQueryIdOverwriteQueryId() {
            SearchQuery query = this.builder.queryId("queryId").context((Map)ImmutableMap.of((Object)"my", (Object)"context", (Object)"queryId", (Object)"realQueryId")).build();
            Assert.assertEquals((Object)ImmutableMap.of((Object)"queryId", (Object)"realQueryId", (Object)"my", (Object)"context"), (Object)query.getContext());
        }
    }

    public static class TimeseriesQueryBuilderTest {
        private Druids.TimeseriesQueryBuilder builder;

        @Before
        public void setup() {
            this.builder = Druids.newTimeseriesQueryBuilder().dataSource(DruidsTest.DATASOURCE).intervals(QUERY_SEGMENT_SPEC).granularity(Granularities.ALL);
        }

        @Test
        public void testQueryIdWhenContextInBuilderIsNullReturnContextContainingQueryId() {
            TimeseriesQuery query = this.builder.queryId("queryId").build();
            Assert.assertEquals((Object)ImmutableMap.of((Object)"queryId", (Object)"queryId"), (Object)query.getContext());
        }

        @Test
        public void testQueryIdWhenBuilderHasNonnullContextWithoutQueryIdReturnMergedContext() {
            TimeseriesQuery query = this.builder.context((Map)ImmutableMap.of((Object)"my", (Object)"context")).queryId("queryId").build();
            Assert.assertEquals((Object)ImmutableMap.of((Object)"queryId", (Object)"queryId", (Object)"my", (Object)"context"), (Object)query.getContext());
        }

        @Test
        public void testQueryIdWhenBuilderHasNonnullContextWithQueryIdReturnMergedContext() {
            TimeseriesQuery query = this.builder.context((Map)ImmutableMap.of((Object)"my", (Object)"context", (Object)"queryId", (Object)"queryId")).queryId("realQueryId").build();
            Assert.assertEquals((Object)ImmutableMap.of((Object)"queryId", (Object)"realQueryId", (Object)"my", (Object)"context"), (Object)query.getContext());
        }

        @Test
        public void testContextAfterSettingQueryIdReturnContextWithoutQueryId() {
            TimeseriesQuery query = this.builder.queryId("queryId").context((Map)ImmutableMap.of((Object)"my", (Object)"context")).build();
            Assert.assertEquals((Object)ImmutableMap.of((Object)"my", (Object)"context"), (Object)query.getContext());
        }

        @Test
        public void testContextContainingQueryIdAfterSettingQueryIdOverwriteQueryId() {
            TimeseriesQuery query = this.builder.queryId("queryId").context((Map)ImmutableMap.of((Object)"my", (Object)"context", (Object)"queryId", (Object)"realQueryId")).build();
            Assert.assertEquals((Object)ImmutableMap.of((Object)"queryId", (Object)"realQueryId", (Object)"my", (Object)"context"), (Object)query.getContext());
        }
    }
}

