/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.java.util.metrics;

import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.util.List;
import org.apache.druid.java.util.common.concurrent.Execs;
import org.apache.druid.java.util.emitter.service.ServiceEmitter;
import org.apache.druid.java.util.metrics.AbstractMonitor;
import org.apache.druid.java.util.metrics.BasicMonitorScheduler;
import org.apache.druid.java.util.metrics.DruidMonitorSchedulerConfig;
import org.apache.druid.java.util.metrics.Monitor;
import org.easymock.EasyMock;
import org.joda.time.Duration;
import org.junit.Test;

public class MonitorSchedulerTest {
    @Test
    public void testMonitorAndStopOnRemove() throws IOException {
        DruidMonitorSchedulerConfig infiniteFlushDelayConfig = new DruidMonitorSchedulerConfig(){

            public Duration getEmissionDuration() {
                return Duration.millis((long)Long.MAX_VALUE);
            }
        };
        ServiceEmitter emitter = (ServiceEmitter)EasyMock.mock(ServiceEmitter.class);
        AbstractMonitor monitor = new AbstractMonitor(){

            public boolean doMonitor(ServiceEmitter emitter) {
                try {
                    emitter.flush();
                    return true;
                }
                catch (Throwable t) {
                    return false;
                }
            }
        };
        BasicMonitorScheduler scheduler = new BasicMonitorScheduler(infiniteFlushDelayConfig, emitter, (List)ImmutableList.of((Object)monitor), Execs.scheduledSingleThreaded((String)"MonitorScheduler-%s"));
        scheduler.start();
        emitter.flush();
        EasyMock.expectLastCall().times(1);
        EasyMock.replay((Object[])new Object[]{emitter});
        scheduler.removeMonitor((Monitor)monitor);
        EasyMock.verify((Object[])new Object[]{emitter});
    }
}

