/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.java.util.metrics;

import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Map;
import org.apache.druid.java.util.emitter.core.ConcurrentTimeCounter;
import org.apache.druid.java.util.emitter.core.HttpPostEmitter;
import org.apache.druid.java.util.emitter.service.ServiceEmitter;
import org.apache.druid.java.util.metrics.HttpPostEmitterMonitor;
import org.apache.druid.java.util.metrics.StubServiceEmitter;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;

public class HttpPostEmitterMonitorTest {
    private HttpPostEmitter mockHttpPostEmitter;
    private HttpPostEmitterMonitor monitor;

    @BeforeEach
    public void setUp() {
        this.mockHttpPostEmitter = (HttpPostEmitter)Mockito.mock(HttpPostEmitter.class);
        this.monitor = new HttpPostEmitterMonitor("testFeed", this.mockHttpPostEmitter, ImmutableMap.of((Object)"dimensionKey", (Object)"dimensionValue"));
    }

    @Test
    public void testDoMonitor() {
        Mockito.when((Object)this.mockHttpPostEmitter.getTotalEmittedEvents()).thenReturn((Object)100L);
        Mockito.when((Object)this.mockHttpPostEmitter.getTotalDroppedBuffers()).thenReturn((Object)10);
        Mockito.when((Object)this.mockHttpPostEmitter.getTotalAllocatedBuffers()).thenReturn((Object)20);
        Mockito.when((Object)this.mockHttpPostEmitter.getTotalFailedBuffers()).thenReturn((Object)5);
        Mockito.when((Object)this.mockHttpPostEmitter.getEventsToEmit()).thenReturn((Object)200L);
        Mockito.when((Object)this.mockHttpPostEmitter.getLargeEventsToEmit()).thenReturn((Object)75L);
        Mockito.when((Object)this.mockHttpPostEmitter.getBuffersToEmit()).thenReturn((Object)30);
        Mockito.when((Object)this.mockHttpPostEmitter.getBuffersToReuse()).thenReturn((Object)15);
        Mockito.when((Object)this.mockHttpPostEmitter.getBatchFillingTimeCounter()).thenReturn((Object)((ConcurrentTimeCounter)Mockito.mock(ConcurrentTimeCounter.class)));
        Mockito.when((Object)this.mockHttpPostEmitter.getSuccessfulSendingTimeCounter()).thenReturn((Object)((ConcurrentTimeCounter)Mockito.mock(ConcurrentTimeCounter.class)));
        Mockito.when((Object)this.mockHttpPostEmitter.getFailedSendingTimeCounter()).thenReturn((Object)((ConcurrentTimeCounter)Mockito.mock(ConcurrentTimeCounter.class)));
        StubServiceEmitter stubServiceEmitter = new StubServiceEmitter("service", "host");
        Assertions.assertTrue((boolean)this.monitor.doMonitor((ServiceEmitter)stubServiceEmitter));
        Map<String, List<StubServiceEmitter.ServiceMetricEventSnapshot>> metricEvents = stubServiceEmitter.getMetricEvents();
        this.assertMetricValue(metricEvents, "emitter/successfulSending/maxTimeMs", 0);
        this.assertMetricValue(metricEvents, "emitter/events/emitted/delta", 100L);
        this.assertMetricValue(metricEvents, "emitter/successfulSending/minTimeMs", 0);
        this.assertMetricValue(metricEvents, "emitter/buffers/emitQueue", 30);
        this.assertMetricValue(metricEvents, "emitter/failedSending/minTimeMs", 0);
        this.assertMetricValue(metricEvents, "emitter/buffers/allocated/delta", 20);
        this.assertMetricValue(metricEvents, "emitter/batchFilling/maxTimeMs", 0);
        this.assertMetricValue(metricEvents, "emitter/buffers/dropped/delta", 10);
        this.assertMetricValue(metricEvents, "emitter/batchFilling/minTimeMs", 0);
        this.assertMetricValue(metricEvents, "emitter/events/emitQueue", 200L);
        this.assertMetricValue(metricEvents, "emitter/events/large/emitQueue", 75L);
        this.assertMetricValue(metricEvents, "emitter/buffers/reuseQueue", 15);
        this.assertMetricValue(metricEvents, "emitter/buffers/failed/delta", 5);
        this.assertMetricValue(metricEvents, "emitter/failedSending/maxTimeMs", 0L);
    }

    private void assertMetricValue(Map<String, List<StubServiceEmitter.ServiceMetricEventSnapshot>> metricEvents, String metricName, Number expectedValue) {
        Assertions.assertEquals((double)metricEvents.get(metricName).get(0).getMetricEvent().getValue().doubleValue(), (double)expectedValue.doubleValue());
    }
}

