/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.java.util.emitter.core;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.primitives.Ints;
import java.io.IOException;
import java.lang.reflect.Field;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.druid.java.util.emitter.core.BaseHttpEmittingConfig;
import org.apache.druid.java.util.emitter.core.BatchingStrategy;
import org.apache.druid.java.util.emitter.core.EmitterTest;
import org.apache.druid.java.util.emitter.core.Event;
import org.apache.druid.java.util.emitter.core.GoHandler;
import org.apache.druid.java.util.emitter.core.GoHandlers;
import org.apache.druid.java.util.emitter.core.HttpEmitterConfig;
import org.apache.druid.java.util.emitter.core.HttpPostEmitter;
import org.apache.druid.java.util.emitter.core.IntEvent;
import org.apache.druid.java.util.emitter.core.MockHttpClient;
import org.asynchttpclient.AsyncHttpClient;
import org.asynchttpclient.ListenableFuture;
import org.asynchttpclient.Request;
import org.asynchttpclient.Response;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class HttpPostEmitterTest {
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper(){

        public byte[] writeValueAsBytes(Object value) {
            return Ints.toByteArray((int)((IntEvent)value).index);
        }
    };
    private final MockHttpClient httpClient = new MockHttpClient();

    @Before
    public void setup() {
        this.httpClient.setGoHandler(new GoHandler(){

            @Override
            protected ListenableFuture<Response> go(Request request) {
                return GoHandlers.immediateFuture(EmitterTest.okResponse());
            }
        });
    }

    @Test
    public void testRecoveryEmitAndReturnBatch() throws InterruptedException, IOException, NoSuchFieldException, IllegalAccessException {
        HttpEmitterConfig config = new HttpEmitterConfig.Builder("http://foo.bar").setFlushMillis(100L).setFlushCount(4).setFlushTimeout(BaseHttpEmittingConfig.TEST_FLUSH_TIMEOUT_MILLIS).setBatchingStrategy(BatchingStrategy.ONLY_EVENTS).setMaxBatchSize(0x100000).setBatchQueueSizeLimit(1000).build();
        try (HttpPostEmitter emitter = new HttpPostEmitter(config, (AsyncHttpClient)this.httpClient, OBJECT_MAPPER);){
            emitter.start();
            emitter.emitAndReturnBatch((Event)new IntEvent());
            Thread.sleep(1000L);
            Field concurrentBatch = emitter.getClass().getDeclaredField("concurrentBatch");
            concurrentBatch.setAccessible(true);
            ((AtomicReference)concurrentBatch.get(emitter)).getAndSet(1L);
            emitter.emitAndReturnBatch((Event)new IntEvent());
            emitter.flush();
            Assert.assertEquals((long)2L, (long)emitter.getTotalEmittedEvents());
        }
    }
}

