/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.java.util.common.parsers;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Collection;
import java.util.Iterator;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.java.util.common.parsers.FlattenerJsonProvider;
import org.junit.Assert;
import org.junit.Test;

public class FlattenerJsonProviderTest {
    FlattenerJsonProvider jsonProvider = new FlattenerJsonProvider(){

        public boolean isArray(Object o) {
            throw new RuntimeException("not tested");
        }

        public boolean isMap(Object o) {
            throw new RuntimeException("not tested");
        }

        public Collection<String> getPropertyKeys(Object o) {
            throw new RuntimeException("not tested");
        }

        public Object getMapValue(Object o, String s) {
            throw new RuntimeException("not tested");
        }
    };

    @Test
    public void testMapStuff() {
        Object aMap = this.jsonProvider.createMap();
        this.jsonProvider.setProperty(aMap, (Object)"key", (Object)"value");
        Assert.assertEquals((Object)ImmutableMap.of((Object)"key", (Object)"value"), (Object)aMap);
        this.jsonProvider.removeProperty(aMap, (Object)"key");
        Assert.assertEquals((Object)ImmutableMap.of(), (Object)aMap);
        Assert.assertEquals((Object)aMap, (Object)this.jsonProvider.unwrap(aMap));
        Assert.assertThrows(UnsupportedOperationException.class, () -> this.jsonProvider.setProperty(this.jsonProvider.createArray(), (Object)"key", (Object)"value"));
        Assert.assertThrows(UnsupportedOperationException.class, () -> this.jsonProvider.removeProperty(this.jsonProvider.createArray(), (Object)"key"));
    }

    @Test
    public void testArrayStuff() {
        Object aList = this.jsonProvider.createArray();
        this.jsonProvider.setArrayIndex(aList, 0, (Object)"a");
        this.jsonProvider.setArrayIndex(aList, 1, (Object)"b");
        this.jsonProvider.setArrayIndex(aList, 2, (Object)"c");
        Assert.assertEquals((long)3L, (long)this.jsonProvider.length(aList));
        Assert.assertEquals((Object)"a", (Object)this.jsonProvider.getArrayIndex(aList, 0));
        Assert.assertEquals((Object)"b", (Object)this.jsonProvider.getArrayIndex(aList, 1));
        Assert.assertEquals((Object)"c", (Object)this.jsonProvider.getArrayIndex(aList, 2));
        ImmutableList expected = ImmutableList.of((Object)"a", (Object)"b", (Object)"c");
        Assert.assertEquals((Object)expected, (Object)aList);
        Iterator iter = this.jsonProvider.toIterable(aList).iterator();
        Iterator expectedIter = expected.iterator();
        while (iter.hasNext()) {
            Assert.assertEquals(expectedIter.next(), iter.next());
        }
        Assert.assertFalse((boolean)expectedIter.hasNext());
        Assert.assertEquals((Object)aList, (Object)this.jsonProvider.unwrap(aList));
        Assert.assertThrows(UnsupportedOperationException.class, () -> this.jsonProvider.getArrayIndex(this.jsonProvider.createMap(), 0));
        Assert.assertThrows(UnsupportedOperationException.class, () -> this.jsonProvider.setArrayIndex(this.jsonProvider.createMap(), 0, (Object)"a"));
        Assert.assertThrows(UnsupportedOperationException.class, () -> this.jsonProvider.toIterable(this.jsonProvider.createMap()));
    }

    @Test
    public void testNotImplementedOnPurpose() {
        Object aList = this.jsonProvider.createArray();
        Throwable t = Assert.assertThrows(UnsupportedOperationException.class, () -> this.jsonProvider.toJson(aList));
        Assert.assertEquals((Object)"Unused", (Object)t.getMessage());
        t = Assert.assertThrows(UnsupportedOperationException.class, () -> this.jsonProvider.parse("{}"));
        Assert.assertEquals((Object)"Unused", (Object)t.getMessage());
        t = Assert.assertThrows(UnsupportedOperationException.class, () -> this.jsonProvider.parse((InputStream)new ByteArrayInputStream(StringUtils.toUtf8((String)"{}")), "UTF-8"));
        Assert.assertEquals((Object)"Unused", (Object)t.getMessage());
        t = Assert.assertThrows(UnsupportedOperationException.class, () -> this.jsonProvider.getArrayIndex(aList, 0, false));
        Assert.assertEquals((Object)"Deprecated", (Object)t.getMessage());
    }
}

