/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.java.util.common;

import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import org.apache.druid.java.util.common.Intervals;
import org.apache.druid.java.util.common.JodaUtils;
import org.apache.druid.java.util.common.granularity.Granularities;
import org.apache.druid.java.util.common.granularity.IntervalsByGranularity;
import org.joda.time.Interval;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;

public class IntervalsByGranularityTest {
    @Rule
    public ExpectedException expectedException = ExpectedException.none();

    @Test
    public void testTrivialIntervalExplosion() {
        Interval first = Intervals.of((String)"2013-01-01T00Z/2013-02-01T00Z");
        Interval second = Intervals.of((String)"2012-01-01T00Z/2012-02-01T00Z");
        Interval third = Intervals.of((String)"2002-01-01T00Z/2003-01-01T00Z");
        IntervalsByGranularity intervals = new IntervalsByGranularity((Collection)ImmutableList.of((Object)first, (Object)second, (Object)third), Granularities.DAY);
        Iterator granularityIntervals = intervals.granularityIntervalsIterator();
        long count = this.verifyIteratorAndReturnIntervalCount(granularityIntervals);
        Assert.assertEquals((long)427L, (long)count);
        granularityIntervals = intervals.granularityIntervalsIterator();
        count = this.getCountWithNoHasNext(granularityIntervals);
        Assert.assertEquals((long)427L, (long)count);
    }

    @Test
    public void testDups() {
        Interval first = Intervals.of((String)"2013-01-01T00Z/2013-02-01T00Z");
        Interval second = Intervals.of((String)"2012-04-01T00Z/2012-05-01T00Z");
        Interval third = Intervals.of((String)"2013-01-01T00Z/2013-02-01T00Z");
        IntervalsByGranularity intervals = new IntervalsByGranularity((Collection)ImmutableList.of((Object)first, (Object)second, (Object)third), Granularities.DAY);
        Iterator granularityIntervals = intervals.granularityIntervalsIterator();
        long count = this.verifyIteratorAndReturnIntervalCount(granularityIntervals);
        Assert.assertEquals((long)61L, (long)count);
    }

    @Test
    public void testCondenseForManyIntervals() {
        Interval first = Intervals.of((String)"2012-01-01T00Z/P1Y");
        IntervalsByGranularity intervals = new IntervalsByGranularity((Collection)ImmutableList.of((Object)first), Granularities.SECOND);
        Assert.assertEquals((Object)ImmutableList.of((Object)Intervals.of((String)"2012-01-01T00Z/2013-01-01T00Z")), (Object)ImmutableList.copyOf((Iterator)JodaUtils.condensedIntervalsIterator((Iterator)intervals.granularityIntervalsIterator())));
    }

    @Ignore
    @Test
    public void testIterateHugeIntervalsWithTinyGranularity() {
        Interval first = Intervals.of((String)"2012-01-01T00Z/2012-12-31T00Z");
        Interval second = Intervals.of((String)"2002-01-01T00Z/2002-12-31T00Z");
        Interval third = Intervals.of((String)"2021-01-01T00Z/2021-06-30T00Z");
        IntervalsByGranularity intervals = new IntervalsByGranularity((Collection)ImmutableList.of((Object)first, (Object)second, (Object)third), Granularities.SECOND);
        Iterator granularityIntervals = intervals.granularityIntervalsIterator();
        long count = this.verifyIteratorAndReturnIntervalCount(granularityIntervals);
        Assert.assertEquals((long)78537600L, (long)count);
    }

    @Test
    public void testSimpleEliminateRepeated() {
        ImmutableList inputIntervals = ImmutableList.of((Object)Intervals.of((String)"2012-01-08T00Z/2012-01-11T00Z"), (Object)Intervals.of((String)"2012-01-07T00Z/2012-01-08T00Z"), (Object)Intervals.of((String)"2012-01-03T00Z/2012-01-04T00Z"), (Object)Intervals.of((String)"2012-01-01T00Z/2012-01-03T00Z"));
        IntervalsByGranularity intervals = new IntervalsByGranularity((Collection)inputIntervals, Granularities.MONTH);
        Assert.assertEquals((Object)ImmutableList.of((Object)Intervals.of((String)"2012-01-01T00Z/2012-02-01T00Z")), (Object)ImmutableList.copyOf((Iterator)intervals.granularityIntervalsIterator()));
    }

    @Test
    public void testALittleMoreComplexEliminateRepeated() {
        ImmutableList inputIntervals = ImmutableList.of((Object)Intervals.of((String)"2015-01-08T00Z/2015-01-11T00Z"), (Object)Intervals.of((String)"2012-01-08T00Z/2012-01-11T00Z"), (Object)Intervals.of((String)"2012-01-07T00Z/2012-01-08T00Z"), (Object)Intervals.of((String)"2012-01-03T00Z/2012-01-04T00Z"), (Object)Intervals.of((String)"2012-01-01T00Z/2012-01-03T00Z"), (Object)Intervals.of((String)"2007-03-08T00Z/2007-04-11T00Z"));
        IntervalsByGranularity intervals = new IntervalsByGranularity((Collection)inputIntervals, Granularities.MONTH);
        Assert.assertEquals((Object)ImmutableList.of((Object)Intervals.of((String)"2007-03-01T00Z/2007-04-01T00Z"), (Object)Intervals.of((String)"2007-04-01T00Z/2007-05-01T00Z"), (Object)Intervals.of((String)"2012-01-01T00Z/2012-02-01T00Z"), (Object)Intervals.of((String)"2015-01-01T00Z/2015-02-01T00Z")), (Object)ImmutableList.copyOf((Iterator)intervals.granularityIntervalsIterator()));
    }

    @Test
    public void testOverlappingShouldThrow() {
        ImmutableList inputIntervals = ImmutableList.of((Object)Intervals.of((String)"2013-01-01T00Z/2013-01-11T00Z"), (Object)Intervals.of((String)"2013-01-05T00Z/2013-01-08T00Z"), (Object)Intervals.of((String)"2013-01-07T00Z/2013-01-15T00Z"));
        IntervalsByGranularity intervals = new IntervalsByGranularity((Collection)inputIntervals, Granularities.DAY);
        Iterator granularityIntervals = intervals.granularityIntervalsIterator();
        long count = this.verifyIteratorAndReturnIntervalCount(granularityIntervals);
        Assert.assertEquals((long)14L, (long)count);
    }

    @Test
    public void testWithGranularity() {
        ImmutableList inputIntervals = ImmutableList.of((Object)Intervals.of((String)"2013-01-01T00Z/2013-01-10T00Z"), (Object)Intervals.of((String)"2013-01-15T00Z/2013-01-20T00Z"), (Object)Intervals.of((String)"2013-02-07T00Z/2013-02-15T00Z"));
        IntervalsByGranularity intervals = new IntervalsByGranularity((Collection)inputIntervals, Granularities.MONTH);
        Iterator granularityIntervals = intervals.granularityIntervalsIterator();
        long count = this.verifyIteratorAndReturnIntervalCount(granularityIntervals);
        Assert.assertEquals((long)2L, (long)count);
    }

    @Test(expected=UnsupportedOperationException.class)
    public void testRemoveThrowsException() {
        ImmutableList inputIntervals = ImmutableList.of((Object)Intervals.of((String)"2015-01-08T00Z/2015-01-11T00Z"));
        IntervalsByGranularity intervals = new IntervalsByGranularity((Collection)inputIntervals, Granularities.MONTH);
        intervals.granularityIntervalsIterator().remove();
    }

    @Test
    public void testEmptyInput() {
        List inputIntervals = Collections.emptyList();
        IntervalsByGranularity intervals = new IntervalsByGranularity(inputIntervals, Granularities.MONTH);
        Assert.assertFalse((boolean)intervals.granularityIntervalsIterator().hasNext());
    }

    private long verifyIteratorAndReturnIntervalCount(Iterator<Interval> granularityIntervalIterator) {
        long count = 0L;
        Interval previous = null;
        while (granularityIntervalIterator.hasNext()) {
            Interval current = granularityIntervalIterator.next();
            if (previous != null) {
                Assert.assertTrue((String)(String.valueOf(previous) + "," + String.valueOf(current)), (previous.getEndMillis() <= current.getStartMillis() ? 1 : 0) != 0);
            }
            previous = current;
            ++count;
        }
        return count;
    }

    private long getCountWithNoHasNext(Iterator<Interval> granularityIntervalIterator) {
        long count = 0L;
        Interval previous = null;
        while (true) {
            Interval current;
            try {
                current = granularityIntervalIterator.next();
            }
            catch (NoSuchElementException e) {
                break;
            }
            if (previous != null) {
                Assert.assertTrue((previous.getEndMillis() <= current.getStartMillis() ? 1 : 0) != 0);
            }
            previous = current;
            ++count;
        }
        return count;
    }
}

