/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.java.util.common;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.Collection;
import java.util.HashMap;
import java.util.Set;
import javax.validation.ConstraintViolation;
import javax.validation.Validation;
import javax.validation.Validator;
import javax.validation.groups.Default;
import org.apache.druid.java.util.common.HumanReadableBytes;
import org.apache.druid.java.util.common.HumanReadableBytesRange;
import org.apache.druid.java.util.common.IAE;
import org.apache.druid.utils.CollectionUtils;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;

public class HumanReadableBytesTest {
    @Rule
    public ExpectedException expectedException = ExpectedException.none();

    @Test
    public void testNumberString() {
        Assert.assertEquals((long)0L, (long)HumanReadableBytes.parse((String)"0"));
        Assert.assertEquals((long)1L, (long)HumanReadableBytes.parse((String)"1"));
        Assert.assertEquals((long)10000000L, (long)HumanReadableBytes.parse((String)"10000000"));
    }

    @Test
    public void testWithWhiteSpace() {
        Assert.assertEquals((long)12345L, (long)HumanReadableBytes.parse((String)" 12345 "));
        Assert.assertEquals((long)12345L, (long)HumanReadableBytes.parse((String)"\t12345\t"));
    }

    @Test
    public void testK() {
        Assert.assertEquals((long)1000L, (long)HumanReadableBytes.parse((String)"1k"));
        Assert.assertEquals((long)1000L, (long)HumanReadableBytes.parse((String)"1K"));
    }

    @Test
    public void testM() {
        Assert.assertEquals((long)1000000L, (long)HumanReadableBytes.parse((String)"1m"));
        Assert.assertEquals((long)1000000L, (long)HumanReadableBytes.parse((String)"1M"));
    }

    @Test
    public void testG() {
        Assert.assertEquals((long)1000000000L, (long)HumanReadableBytes.parse((String)"1g"));
        Assert.assertEquals((long)1000000000L, (long)HumanReadableBytes.parse((String)"1G"));
    }

    @Test
    public void testT() {
        Assert.assertEquals((long)1000000000000L, (long)HumanReadableBytes.parse((String)"1t"));
        Assert.assertEquals((long)1000000000000L, (long)HumanReadableBytes.parse((String)"1T"));
    }

    @Test
    public void testKiB() {
        Assert.assertEquals((long)1024L, (long)HumanReadableBytes.parse((String)"1kib"));
        Assert.assertEquals((long)9216L, (long)HumanReadableBytes.parse((String)"9KiB"));
        Assert.assertEquals((long)9216L, (long)HumanReadableBytes.parse((String)"9Kib"));
        Assert.assertEquals((long)9216L, (long)HumanReadableBytes.parse((String)"9Ki"));
    }

    @Test
    public void testMiB() {
        Assert.assertEquals((long)0x100000L, (long)HumanReadableBytes.parse((String)"1mib"));
        Assert.assertEquals((long)0x900000L, (long)HumanReadableBytes.parse((String)"9MiB"));
        Assert.assertEquals((long)0x900000L, (long)HumanReadableBytes.parse((String)"9Mib"));
        Assert.assertEquals((long)0x900000L, (long)HumanReadableBytes.parse((String)"9Mi"));
    }

    @Test
    public void testGiB() {
        Assert.assertEquals((long)0x40000000L, (long)HumanReadableBytes.parse((String)"1gib"));
        Assert.assertEquals((long)0x40000000L, (long)HumanReadableBytes.parse((String)"1GiB"));
        Assert.assertEquals((long)0x240000000L, (long)HumanReadableBytes.parse((String)"9Gib"));
        Assert.assertEquals((long)0x240000000L, (long)HumanReadableBytes.parse((String)"9Gi"));
    }

    @Test
    public void testTiB() {
        Assert.assertEquals((long)0x10000000000L, (long)HumanReadableBytes.parse((String)"1tib"));
        Assert.assertEquals((long)0x90000000000L, (long)HumanReadableBytes.parse((String)"9TiB"));
        Assert.assertEquals((long)0x90000000000L, (long)HumanReadableBytes.parse((String)"9Tib"));
        Assert.assertEquals((long)0x90000000000L, (long)HumanReadableBytes.parse((String)"9Ti"));
    }

    @Test
    public void testPiB() {
        Assert.assertEquals((long)0x4000000000000L, (long)HumanReadableBytes.parse((String)"1pib"));
        Assert.assertEquals((long)0x24000000000000L, (long)HumanReadableBytes.parse((String)"9PiB"));
        Assert.assertEquals((long)0x24000000000000L, (long)HumanReadableBytes.parse((String)"9Pib"));
        Assert.assertEquals((long)0x24000000000000L, (long)HumanReadableBytes.parse((String)"9Pi"));
    }

    @Test
    public void testDefault() {
        Assert.assertEquals((long)-123L, (long)HumanReadableBytes.parse((String)" ", (long)-123L));
        Assert.assertEquals((long)-456L, (long)HumanReadableBytes.parse(null, (long)-456L));
        Assert.assertEquals((long)-789L, (long)HumanReadableBytes.parse((String)"\t", (long)-789L));
    }

    @Test
    public void testNull() {
        this.expectedException.expect((Matcher)ExceptionMatcher.INVALIDFORMAT);
        HumanReadableBytes.parse(null);
    }

    @Test
    public void testEmpty() {
        this.expectedException.expect((Matcher)ExceptionMatcher.INVALIDFORMAT);
        HumanReadableBytes.parse((String)"");
    }

    @Test
    public void testWhitespace() {
        this.expectedException.expect((Matcher)ExceptionMatcher.INVALIDFORMAT);
        HumanReadableBytes.parse((String)"   ");
    }

    @Test
    public void testNegative() {
        this.expectedException.expect((Matcher)ExceptionMatcher.INVALIDFORMAT);
        HumanReadableBytes.parse((String)"-1");
    }

    @Test
    public void testInvalidFormatOneChar() {
        this.expectedException.expect((Matcher)ExceptionMatcher.INVALIDFORMAT);
        HumanReadableBytes.parse((String)"b");
    }

    @Test
    public void testInvalidFormatOneCharK8s() {
        this.expectedException.expect((Matcher)ExceptionMatcher.INVALIDFORMAT);
        HumanReadableBytes.parse((String)"i");
    }

    @Test
    public void testInvalidFormatOneChar2() {
        this.expectedException.expect((Matcher)ExceptionMatcher.INVALIDFORMAT);
        HumanReadableBytes.parse((String)"B");
    }

    @Test
    public void testInvalidFormatExtraSpace() {
        this.expectedException.expect((Matcher)ExceptionMatcher.INVALIDFORMAT);
        HumanReadableBytes.parse((String)"1 b");
    }

    @Test
    public void testInvalidFormat4() {
        this.expectedException.expect((Matcher)ExceptionMatcher.INVALIDFORMAT);
        HumanReadableBytes.parse((String)"1b");
    }

    @Test
    public void testInvalidFormatMiBExtraSpace() {
        this.expectedException.expect((Matcher)ExceptionMatcher.INVALIDFORMAT);
        HumanReadableBytes.parse((String)"1 mib");
    }

    @Test
    public void testInvalidFormatMiExtraSpace() {
        this.expectedException.expect((Matcher)ExceptionMatcher.INVALIDFORMAT);
        HumanReadableBytes.parse((String)"1 mi");
    }

    @Test
    public void testInvalidFormatTiB() {
        this.expectedException.expect((Matcher)ExceptionMatcher.INVALIDFORMAT);
        HumanReadableBytes.parse((String)"tib");
    }

    @Test
    public void testInvalidFormatTi() {
        this.expectedException.expect((Matcher)ExceptionMatcher.INVALIDFORMAT);
        HumanReadableBytes.parse((String)"ti");
    }

    @Test
    public void testInvalidFormatGiB() {
        this.expectedException.expect((Matcher)ExceptionMatcher.INVALIDFORMAT);
        HumanReadableBytes.parse((String)"gib");
    }

    @Test
    public void testInvalidFormatPiB() {
        this.expectedException.expect((Matcher)ExceptionMatcher.INVALIDFORMAT);
        HumanReadableBytes.parse((String)" pib");
    }

    @Test
    public void testInvalidCharacter() {
        this.expectedException.expect((Matcher)ExceptionMatcher.INVALIDFORMAT);
        HumanReadableBytes.parse((String)"c");
    }

    @Test
    public void testExtraLargeNumber() {
        this.expectedException.expect((Matcher)ExceptionMatcher.INVALIDFORMAT);
        String extraLarge = "92233720368547758071";
        HumanReadableBytes.parse((String)extraLarge);
    }

    @Test
    public void testOverflowK() {
        this.expectedException.expect((Matcher)ExceptionMatcher.OVERFLOW);
        String overflow = "9223372036854776k";
        HumanReadableBytes.parse((String)overflow);
    }

    @Test
    public void testOverflowM() {
        this.expectedException.expect((Matcher)ExceptionMatcher.OVERFLOW);
        String overflow = "9223372036855m";
        HumanReadableBytes.parse((String)overflow);
    }

    @Test
    public void testOverflowG() {
        this.expectedException.expect((Matcher)ExceptionMatcher.OVERFLOW);
        String overflow = "9223372037g";
        HumanReadableBytes.parse((String)overflow);
    }

    @Test
    public void testOverflowT() {
        this.expectedException.expect((Matcher)ExceptionMatcher.OVERFLOW);
        String overflow = "9223373t";
        HumanReadableBytes.parse((String)overflow);
    }

    @Test
    public void testOverflowP() {
        this.expectedException.expect((Matcher)ExceptionMatcher.OVERFLOW);
        String overflow = "9224p";
        HumanReadableBytes.parse((String)overflow);
    }

    @Test
    public void testOverflowKiB() {
        this.expectedException.expect((Matcher)ExceptionMatcher.OVERFLOW);
        String overflow = "9007199254740992KiB";
        HumanReadableBytes.parse((String)overflow);
    }

    @Test
    public void testOverflowMiB() {
        this.expectedException.expect((Matcher)ExceptionMatcher.OVERFLOW);
        String overflow = "8796093022208MiB";
        HumanReadableBytes.parse((String)overflow);
    }

    @Test
    public void testOverflowGiB() {
        this.expectedException.expect((Matcher)ExceptionMatcher.OVERFLOW);
        String overflow = "8589934592GiB";
        HumanReadableBytes.parse((String)overflow);
    }

    @Test
    public void testOverflowTiB() {
        this.expectedException.expect((Matcher)ExceptionMatcher.OVERFLOW);
        String overflow = "8388608TiB";
        HumanReadableBytes.parse((String)overflow);
    }

    @Test
    public void testOverflowPiB() {
        this.expectedException.expect((Matcher)ExceptionMatcher.OVERFLOW);
        String overflow = "8192PiB";
        HumanReadableBytes.parse((String)overflow);
    }

    @Test
    public void testJSON() throws JsonProcessingException {
        ObjectMapper mapper = new ObjectMapper();
        HumanReadableBytes bytes = new HumanReadableBytes("5m");
        String serialized = mapper.writeValueAsString((Object)bytes);
        HumanReadableBytes deserialized = (HumanReadableBytes)mapper.readValue(serialized, HumanReadableBytes.class);
        Assert.assertEquals((Object)bytes, (Object)deserialized);
    }

    @Test
    public void testGetInt() {
        this.expectedException.expectMessage("Number [2147483648] exceeds range of Integer.MAX_VALUE");
        HumanReadableBytes bytes = new HumanReadableBytes("2GiB");
        bytes.getBytesInInt();
    }

    @Test
    public void testBytesRange() {
        String message = HumanReadableBytesTest.validate(new TestBytesRange(HumanReadableBytes.valueOf((int)-1)));
        Assert.assertEquals((Object)"value must be in the range of [0, 5]", (Object)message);
        message = HumanReadableBytesTest.validate(new TestBytesRange(HumanReadableBytes.valueOf((int)0)));
        Assert.assertEquals(null, (Object)message);
        message = HumanReadableBytesTest.validate(new TestBytesRange(HumanReadableBytes.valueOf((int)5)));
        Assert.assertEquals(null, (Object)message);
        message = HumanReadableBytesTest.validate(new TestBytesRange(HumanReadableBytes.valueOf((int)6)));
        Assert.assertEquals((Object)"value must be in the range of [0, 5]", (Object)message);
    }

    @Test
    public void testFormatInBinaryByte() {
        Assert.assertEquals((Object)"-8.00 EiB", (Object)HumanReadableBytes.format((long)Long.MIN_VALUE, (long)2L, (HumanReadableBytes.UnitSystem)HumanReadableBytes.UnitSystem.BINARY_BYTE));
        Assert.assertEquals((Object)"-8.000 EiB", (Object)HumanReadableBytes.format((long)Long.MIN_VALUE, (long)3L, (HumanReadableBytes.UnitSystem)HumanReadableBytes.UnitSystem.BINARY_BYTE));
        Assert.assertEquals((Object)"-2.00 GiB", (Object)HumanReadableBytes.format((long)Integer.MIN_VALUE, (long)2L, (HumanReadableBytes.UnitSystem)HumanReadableBytes.UnitSystem.BINARY_BYTE));
        Assert.assertEquals((Object)"-32.00 KiB", (Object)HumanReadableBytes.format((long)-32768L, (long)2L, (HumanReadableBytes.UnitSystem)HumanReadableBytes.UnitSystem.BINARY_BYTE));
        Assert.assertEquals((Object)"-128 B", (Object)HumanReadableBytes.format((long)-128L, (long)2L, (HumanReadableBytes.UnitSystem)HumanReadableBytes.UnitSystem.BINARY_BYTE));
        Assert.assertEquals((Object)"-1 B", (Object)HumanReadableBytes.format((long)-1L, (long)2L, (HumanReadableBytes.UnitSystem)HumanReadableBytes.UnitSystem.BINARY_BYTE));
        Assert.assertEquals((Object)"0 B", (Object)HumanReadableBytes.format((long)0L, (long)2L, (HumanReadableBytes.UnitSystem)HumanReadableBytes.UnitSystem.BINARY_BYTE));
        Assert.assertEquals((Object)"1 B", (Object)HumanReadableBytes.format((long)1L, (long)2L, (HumanReadableBytes.UnitSystem)HumanReadableBytes.UnitSystem.BINARY_BYTE));
        Assert.assertEquals((Object)"1.00 KiB", (Object)HumanReadableBytes.format((long)1024L, (long)2L, (HumanReadableBytes.UnitSystem)HumanReadableBytes.UnitSystem.BINARY_BYTE));
        Assert.assertEquals((Object)"1.00 MiB", (Object)HumanReadableBytes.format((long)0x100000L, (long)2L, (HumanReadableBytes.UnitSystem)HumanReadableBytes.UnitSystem.BINARY_BYTE));
        Assert.assertEquals((Object)"1.00 GiB", (Object)HumanReadableBytes.format((long)0x40000000L, (long)2L, (HumanReadableBytes.UnitSystem)HumanReadableBytes.UnitSystem.BINARY_BYTE));
        Assert.assertEquals((Object)"1.00 TiB", (Object)HumanReadableBytes.format((long)0x10000000000L, (long)2L, (HumanReadableBytes.UnitSystem)HumanReadableBytes.UnitSystem.BINARY_BYTE));
        Assert.assertEquals((Object)"1.00 PiB", (Object)HumanReadableBytes.format((long)0x4000000000000L, (long)2L, (HumanReadableBytes.UnitSystem)HumanReadableBytes.UnitSystem.BINARY_BYTE));
        Assert.assertEquals((Object)"8.00 EiB", (Object)HumanReadableBytes.format((long)Long.MAX_VALUE, (long)2L, (HumanReadableBytes.UnitSystem)HumanReadableBytes.UnitSystem.BINARY_BYTE));
    }

    @Test
    public void testPrecisionInBinaryFormat() {
        Assert.assertEquals((Object)"1 KiB", (Object)HumanReadableBytes.format((long)1500L, (long)0L, (HumanReadableBytes.UnitSystem)HumanReadableBytes.UnitSystem.BINARY_BYTE));
        Assert.assertEquals((Object)"1.5 KiB", (Object)HumanReadableBytes.format((long)1500L, (long)1L, (HumanReadableBytes.UnitSystem)HumanReadableBytes.UnitSystem.BINARY_BYTE));
        Assert.assertEquals((Object)"1.46 KiB", (Object)HumanReadableBytes.format((long)1500L, (long)2L, (HumanReadableBytes.UnitSystem)HumanReadableBytes.UnitSystem.BINARY_BYTE));
        Assert.assertEquals((Object)"1.465 KiB", (Object)HumanReadableBytes.format((long)1500L, (long)3L, (HumanReadableBytes.UnitSystem)HumanReadableBytes.UnitSystem.BINARY_BYTE));
    }

    @Test
    public void testPrecisionInDecimalFormat() {
        Assert.assertEquals((Object)"1 KB", (Object)HumanReadableBytes.format((long)1456L, (long)0L, (HumanReadableBytes.UnitSystem)HumanReadableBytes.UnitSystem.DECIMAL_BYTE));
        Assert.assertEquals((Object)"1.5 KB", (Object)HumanReadableBytes.format((long)1456L, (long)1L, (HumanReadableBytes.UnitSystem)HumanReadableBytes.UnitSystem.DECIMAL_BYTE));
        Assert.assertEquals((Object)"1.46 KB", (Object)HumanReadableBytes.format((long)1456L, (long)2L, (HumanReadableBytes.UnitSystem)HumanReadableBytes.UnitSystem.DECIMAL_BYTE));
        Assert.assertEquals((Object)"1.456 KB", (Object)HumanReadableBytes.format((long)1456L, (long)3L, (HumanReadableBytes.UnitSystem)HumanReadableBytes.UnitSystem.DECIMAL_BYTE));
    }

    @Test
    public void testFormatInDecimalByte() {
        Assert.assertEquals((Object)"1 B", (Object)HumanReadableBytes.format((long)1L, (long)2L, (HumanReadableBytes.UnitSystem)HumanReadableBytes.UnitSystem.DECIMAL_BYTE));
        Assert.assertEquals((Object)"1.00 KB", (Object)HumanReadableBytes.format((long)1000L, (long)2L, (HumanReadableBytes.UnitSystem)HumanReadableBytes.UnitSystem.DECIMAL_BYTE));
        Assert.assertEquals((Object)"1.00 MB", (Object)HumanReadableBytes.format((long)1000000L, (long)2L, (HumanReadableBytes.UnitSystem)HumanReadableBytes.UnitSystem.DECIMAL_BYTE));
        Assert.assertEquals((Object)"1.00 GB", (Object)HumanReadableBytes.format((long)1000000000L, (long)2L, (HumanReadableBytes.UnitSystem)HumanReadableBytes.UnitSystem.DECIMAL_BYTE));
        Assert.assertEquals((Object)"1.00 TB", (Object)HumanReadableBytes.format((long)1000000000000L, (long)2L, (HumanReadableBytes.UnitSystem)HumanReadableBytes.UnitSystem.DECIMAL_BYTE));
        Assert.assertEquals((Object)"1.00 PB", (Object)HumanReadableBytes.format((long)1000000000000000L, (long)2L, (HumanReadableBytes.UnitSystem)HumanReadableBytes.UnitSystem.DECIMAL_BYTE));
        Assert.assertEquals((Object)"9.22 EB", (Object)HumanReadableBytes.format((long)Long.MAX_VALUE, (long)2L, (HumanReadableBytes.UnitSystem)HumanReadableBytes.UnitSystem.DECIMAL_BYTE));
        Assert.assertEquals((Object)"100.00 KB", (Object)HumanReadableBytes.format((long)99999L, (long)2L, (HumanReadableBytes.UnitSystem)HumanReadableBytes.UnitSystem.DECIMAL_BYTE));
        Assert.assertEquals((Object)"99.999 KB", (Object)HumanReadableBytes.format((long)99999L, (long)3L, (HumanReadableBytes.UnitSystem)HumanReadableBytes.UnitSystem.DECIMAL_BYTE));
        Assert.assertEquals((Object)"999.9 PB", (Object)HumanReadableBytes.format((long)999949999999999999L, (long)1L, (HumanReadableBytes.UnitSystem)HumanReadableBytes.UnitSystem.DECIMAL_BYTE));
        Assert.assertEquals((Object)"999.95 PB", (Object)HumanReadableBytes.format((long)999949999999999999L, (long)2L, (HumanReadableBytes.UnitSystem)HumanReadableBytes.UnitSystem.DECIMAL_BYTE));
        Assert.assertEquals((Object)"999.949 PB", (Object)HumanReadableBytes.format((long)999949999999999999L, (long)3L, (HumanReadableBytes.UnitSystem)HumanReadableBytes.UnitSystem.DECIMAL_BYTE));
    }

    @Test
    public void testFormatInDecimal() {
        Assert.assertEquals((Object)"1", (Object)HumanReadableBytes.format((long)1L, (long)2L, (HumanReadableBytes.UnitSystem)HumanReadableBytes.UnitSystem.DECIMAL));
        Assert.assertEquals((Object)"999", (Object)HumanReadableBytes.format((long)999L, (long)2L, (HumanReadableBytes.UnitSystem)HumanReadableBytes.UnitSystem.DECIMAL));
        Assert.assertEquals((Object)"-999", (Object)HumanReadableBytes.format((long)-999L, (long)2L, (HumanReadableBytes.UnitSystem)HumanReadableBytes.UnitSystem.DECIMAL));
        Assert.assertEquals((Object)"-1.00 K", (Object)HumanReadableBytes.format((long)-1000L, (long)2L, (HumanReadableBytes.UnitSystem)HumanReadableBytes.UnitSystem.DECIMAL));
        Assert.assertEquals((Object)"1.00 K", (Object)HumanReadableBytes.format((long)1000L, (long)2L, (HumanReadableBytes.UnitSystem)HumanReadableBytes.UnitSystem.DECIMAL));
        Assert.assertEquals((Object)"1.00 M", (Object)HumanReadableBytes.format((long)1000000L, (long)2L, (HumanReadableBytes.UnitSystem)HumanReadableBytes.UnitSystem.DECIMAL));
        Assert.assertEquals((Object)"1.00 G", (Object)HumanReadableBytes.format((long)1000000000L, (long)2L, (HumanReadableBytes.UnitSystem)HumanReadableBytes.UnitSystem.DECIMAL));
        Assert.assertEquals((Object)"1.00 T", (Object)HumanReadableBytes.format((long)1000000000000L, (long)2L, (HumanReadableBytes.UnitSystem)HumanReadableBytes.UnitSystem.DECIMAL));
        Assert.assertEquals((Object)"1.00 P", (Object)HumanReadableBytes.format((long)1000000000000000L, (long)2L, (HumanReadableBytes.UnitSystem)HumanReadableBytes.UnitSystem.DECIMAL));
        Assert.assertEquals((Object)"-9.22 E", (Object)HumanReadableBytes.format((long)Long.MIN_VALUE, (long)2L, (HumanReadableBytes.UnitSystem)HumanReadableBytes.UnitSystem.DECIMAL));
        Assert.assertEquals((Object)"9.22 E", (Object)HumanReadableBytes.format((long)Long.MAX_VALUE, (long)2L, (HumanReadableBytes.UnitSystem)HumanReadableBytes.UnitSystem.DECIMAL));
    }

    @Test
    public void testInvalidPrecisionArgumentLowerBound() {
        this.expectedException.expect(IAE.class);
        this.expectedException.expectMessage("precision [-1] must be in the range of [0,3]");
        Assert.assertEquals((Object)"1.00", (Object)HumanReadableBytes.format((long)1L, (long)-1L, (HumanReadableBytes.UnitSystem)HumanReadableBytes.UnitSystem.DECIMAL));
    }

    @Test
    public void testInvalidPrecisionArgumentUpperBound() {
        this.expectedException.expect(IAE.class);
        this.expectedException.expectMessage("precision [4] must be in the range of [0,3]");
        Assert.assertEquals((Object)"1", (Object)HumanReadableBytes.format((long)1L, (long)3L, (HumanReadableBytes.UnitSystem)HumanReadableBytes.UnitSystem.DECIMAL));
        Assert.assertEquals((Object)"1", (Object)HumanReadableBytes.format((long)1L, (long)4L, (HumanReadableBytes.UnitSystem)HumanReadableBytes.UnitSystem.DECIMAL));
    }

    private static <T> String validate(T obj) {
        Validator validator = Validation.buildDefaultValidatorFactory().getValidator();
        HashMap errorMap = new HashMap();
        Set set = validator.validate(obj, new Class[]{Default.class});
        return CollectionUtils.isNullOrEmpty((Collection)set) ? null : ((ConstraintViolation)set.stream().findFirst().get()).getMessage();
    }

    static class ExceptionMatcher
    implements Matcher {
        static ExceptionMatcher INVALIDFORMAT = new ExceptionMatcher("Invalid format");
        static ExceptionMatcher OVERFLOW = new ExceptionMatcher("Number overflow");
        private String prefix;

        public ExceptionMatcher(String prefix) {
            this.prefix = prefix;
        }

        public boolean matches(Object item) {
            if (!(item instanceof IAE)) {
                return false;
            }
            return ((IAE)((Object)item)).getMessage().startsWith(this.prefix);
        }

        public void describeMismatch(Object item, Description mismatchDescription) {
        }

        public void _dont_implement_Matcher___instead_extend_BaseMatcher_() {
        }

        public void describeTo(Description description) {
        }
    }

    static class TestBytesRange {
        @HumanReadableBytesRange(min=0L, max=5L)
        HumanReadableBytes bytes;

        public TestBytesRange(HumanReadableBytes bytes) {
            this.bytes = bytes;
        }
    }
}

