/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.java.util.common;

import com.google.common.collect.ImmutableList;
import com.google.common.io.Files;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import org.apache.druid.collections.ResourceHolder;
import org.apache.druid.java.util.common.ByteBufferUtils;
import org.apache.druid.java.util.common.StringUtils;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;

public class ByteBufferUtilsTest {
    private static final List<String> COMPARE_TEST_STRINGS = ImmutableList.of((Object)"\uff08\u8acb\u53c3\u898b\u5df2\u88ab\u522a\u9664\u7248\u672c\uff09", (Object)"\u8acb\u53c3\u898b\u5df2\u88ab\u522a\u9664\u7248\u672c", (Object)"\u05e9\u05b8\u05c1\u05dc\u05d5\u05b9\u05dd", (Object)"\uff0b{{[[Template:\u5225\u540d\u91cd\u5b9a\u5411|\u5225\u540d\u91cd\u5b9a\u5411]]}}", (Object)"\ud83d\udc4d\ud83d\udc4d\ud83d\udc4d", (Object)"\ud83d\udca9", (Object)"", (Object)"f", (Object)"fo", (Object)"\ud83d\ude42", (Object)"\ud83e\udee5", (Object)"\ud83e\udd20", (Object[])new String[]{"quick", "brown", "fox"});
    @Rule
    public TemporaryFolder temporaryFolder = new TemporaryFolder();

    @Test
    public void testAllocateDirect() {
        int sz = 10;
        try (ResourceHolder holder = ByteBufferUtils.allocateDirect((int)10);){
            ByteBuffer buf = (ByteBuffer)holder.get();
            Assert.assertTrue((boolean)buf.isDirect());
            Assert.assertEquals((long)10L, (long)buf.remaining());
        }
    }

    @Test
    public void testUnmapDoesntCrashJVM() throws Exception {
        File file = this.temporaryFolder.newFile("some_mmap_file");
        try (BufferedOutputStream os = new BufferedOutputStream(new FileOutputStream(file));){
            byte[] data = new byte[4096];
            Arrays.fill(data, (byte)90);
            ((OutputStream)os).write(data);
        }
        MappedByteBuffer mappedByteBuffer = Files.map((File)file);
        Assert.assertEquals((long)90L, (long)mappedByteBuffer.get(0));
        ByteBufferUtils.unmap((MappedByteBuffer)mappedByteBuffer);
        ByteBufferUtils.unmap((MappedByteBuffer)mappedByteBuffer);
    }

    @Test
    public void testFreeDoesntCrashJVM() {
        ByteBuffer directBuffer = ByteBuffer.allocateDirect(4096);
        ByteBufferUtils.free((ByteBuffer)directBuffer);
        ByteBufferUtils.free((ByteBuffer)directBuffer);
        ByteBuffer heapBuffer = ByteBuffer.allocate(4096);
        ByteBufferUtils.free((ByteBuffer)heapBuffer);
    }

    @Test
    public void testUtf8Comparator() {
        Comparator comparator = ByteBufferUtils.utf8Comparator();
        MatcherAssert.assertThat((Object)comparator.compare(null, null), (Matcher)Matchers.equalTo((Object)0));
        MatcherAssert.assertThat((Object)comparator.compare(null, ByteBuffer.allocate(0)), (Matcher)Matchers.lessThan((Comparable)Integer.valueOf(0)));
        MatcherAssert.assertThat((Object)comparator.compare(ByteBuffer.allocate(0), null), (Matcher)Matchers.greaterThan((Comparable)Integer.valueOf(0)));
        MatcherAssert.assertThat((Object)comparator.compare(null, ByteBuffer.allocate(1)), (Matcher)Matchers.lessThan((Comparable)Integer.valueOf(0)));
        MatcherAssert.assertThat((Object)comparator.compare(ByteBuffer.allocate(1), null), (Matcher)Matchers.greaterThan((Comparable)Integer.valueOf(0)));
        MatcherAssert.assertThat((Object)comparator.compare(null, ByteBuffer.wrap(new byte[]{-1})), (Matcher)Matchers.lessThan((Comparable)Integer.valueOf(0)));
        MatcherAssert.assertThat((Object)comparator.compare(ByteBuffer.wrap(new byte[]{-1}), null), (Matcher)Matchers.greaterThan((Comparable)Integer.valueOf(0)));
        MatcherAssert.assertThat((Object)comparator.compare(ByteBuffer.wrap(new byte[]{1, 2, 3}), ByteBuffer.wrap(new byte[]{1, 2, 3, 4})), (Matcher)Matchers.lessThan((Comparable)Integer.valueOf(0)));
        MatcherAssert.assertThat((Object)comparator.compare(ByteBuffer.wrap(new byte[]{1, 2, 3, 4}), ByteBuffer.wrap(new byte[]{1, 2, 3})), (Matcher)Matchers.greaterThan((Comparable)Integer.valueOf(0)));
        for (String string1 : COMPARE_TEST_STRINGS) {
            for (String string2 : COMPARE_TEST_STRINGS) {
                byte[] utf8Bytes1 = StringUtils.toUtf8((String)string1);
                byte[] utf8Bytes2 = StringUtils.toUtf8((String)string2);
                ByteBuffer utf8ByteBuffer1 = ByteBuffer.allocate(utf8Bytes1.length + 2);
                ByteBuffer utf8ByteBuffer2 = ByteBuffer.allocate(utf8Bytes2.length + 2);
                utf8ByteBuffer1.position(1);
                utf8ByteBuffer1.put(utf8Bytes1, 0, utf8Bytes1.length).position(utf8Bytes1.length);
                utf8ByteBuffer1.position(1).limit(1 + utf8Bytes1.length);
                utf8ByteBuffer2.position(1);
                utf8ByteBuffer2.put(utf8Bytes2, 0, utf8Bytes2.length).position(utf8Bytes2.length);
                utf8ByteBuffer2.position(1).limit(1 + utf8Bytes2.length);
                int compareByteBufferUtilsUtf8 = ByteBufferUtils.utf8Comparator().compare(utf8ByteBuffer1, utf8ByteBuffer2);
                Assert.assertEquals((String)StringUtils.format((String)"compareByteBufferUtilsUtf8(byte[]) (actual) matches compareJavaString (expected) for [%s] vs [%s]", (Object[])new Object[]{string1, string2}), (long)((int)Math.signum(string1.compareTo(string2))), (long)((int)Math.signum(compareByteBufferUtilsUtf8)));
            }
        }
    }
}

