/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.indexer.granularity;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Optional;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterators;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.druid.indexer.granularity.GranularitySpec;
import org.apache.druid.indexer.granularity.UniformGranularitySpec;
import org.apache.druid.jackson.DefaultObjectMapper;
import org.apache.druid.java.util.common.DateTimes;
import org.apache.druid.java.util.common.Intervals;
import org.apache.druid.java.util.common.granularity.DurationGranularity;
import org.apache.druid.java.util.common.granularity.Granularities;
import org.apache.druid.java.util.common.granularity.Granularity;
import org.apache.druid.java.util.common.granularity.PeriodGranularity;
import org.joda.time.Chronology;
import org.joda.time.DateTimeZone;
import org.joda.time.Interval;
import org.joda.time.Period;
import org.joda.time.chrono.ISOChronology;
import org.junit.Assert;
import org.junit.Test;

public class UniformGranularityTest {
    private static final ObjectMapper JSON_MAPPER = new DefaultObjectMapper();

    @Test
    public void testSimple() {
        ArrayList inputIntervals = Lists.newArrayList((Object[])new Interval[]{Intervals.of((String)"2012-01-08T00Z/2012-01-11T00Z"), Intervals.of((String)"2012-01-07T00Z/2012-01-08T00Z"), Intervals.of((String)"2012-01-03T00Z/2012-01-04T00Z"), Intervals.of((String)"2012-01-01T00Z/2012-01-03T00Z")});
        UniformGranularitySpec spec = new UniformGranularitySpec(Granularities.DAY, null, (List)inputIntervals);
        Assert.assertTrue((boolean)spec.isRollup());
        Assert.assertEquals((Object)inputIntervals, (Object)Lists.newArrayList((Iterable)spec.inputIntervals()));
        Assert.assertEquals((Object)Lists.newArrayList((Object[])new Interval[]{Intervals.of((String)"2012-01-01T00Z/P1D"), Intervals.of((String)"2012-01-02T00Z/P1D"), Intervals.of((String)"2012-01-03T00Z/P1D"), Intervals.of((String)"2012-01-07T00Z/P1D"), Intervals.of((String)"2012-01-08T00Z/P1D"), Intervals.of((String)"2012-01-09T00Z/P1D"), Intervals.of((String)"2012-01-10T00Z/P1D")}), (Object)Lists.newArrayList((Iterable)spec.sortedBucketIntervals()));
        Assert.assertEquals((Object)Optional.absent(), (Object)spec.bucketInterval(DateTimes.of((String)"2011-01-12T00Z")));
        Assert.assertEquals((Object)Optional.of((Object)Intervals.of((String)"2012-01-01T00Z/2012-01-02T00Z")), (Object)spec.bucketInterval(DateTimes.of((String)"2012-01-01T00Z")));
        Assert.assertEquals((Object)Optional.of((Object)Intervals.of((String)"2012-01-10T00Z/2012-01-11T00Z")), (Object)spec.bucketInterval(DateTimes.of((String)"2012-01-10T00Z")));
        Assert.assertEquals((Object)Optional.absent(), (Object)spec.bucketInterval(DateTimes.of((String)"2012-01-12T00Z")));
        Assert.assertEquals((String)"2012-01-03T00Z", (Object)Optional.of((Object)Intervals.of((String)"2012-01-03T00Z/2012-01-04T00Z")), (Object)spec.bucketInterval(DateTimes.of((String)"2012-01-03T00Z")));
        Assert.assertEquals((String)"2012-01-03T01Z", (Object)Optional.of((Object)Intervals.of((String)"2012-01-03T00Z/2012-01-04T00Z")), (Object)spec.bucketInterval(DateTimes.of((String)"2012-01-03T01Z")));
        Assert.assertEquals((String)"2012-01-04T01Z", (Object)Optional.absent(), (Object)spec.bucketInterval(DateTimes.of((String)"2012-01-04T01Z")));
        Assert.assertEquals((String)"2012-01-07T23:59:59.999Z", (Object)Optional.of((Object)Intervals.of((String)"2012-01-07T00Z/2012-01-08T00Z")), (Object)spec.bucketInterval(DateTimes.of((String)"2012-01-07T23:59:59.999Z")));
        Assert.assertEquals((String)"2012-01-08T01Z", (Object)Optional.of((Object)Intervals.of((String)"2012-01-08T00Z/2012-01-09T00Z")), (Object)spec.bucketInterval(DateTimes.of((String)"2012-01-08T01Z")));
    }

    @Test
    public void testRollupSetting() {
        ArrayList intervals = Lists.newArrayList((Object[])new Interval[]{Intervals.of((String)"2012-01-08T00Z/2012-01-11T00Z"), Intervals.of((String)"2012-01-07T00Z/2012-01-08T00Z"), Intervals.of((String)"2012-01-03T00Z/2012-01-04T00Z"), Intervals.of((String)"2012-01-01T00Z/2012-01-03T00Z")});
        UniformGranularitySpec spec = new UniformGranularitySpec(Granularities.DAY, Granularities.NONE, Boolean.valueOf(false), (List)intervals);
        Assert.assertFalse((boolean)spec.isRollup());
    }

    @Test
    public void testJson() {
        UniformGranularitySpec spec = new UniformGranularitySpec(Granularities.DAY, null, (List)Lists.newArrayList((Object[])new Interval[]{Intervals.of((String)"2012-01-08T00Z/2012-01-11T00Z"), Intervals.of((String)"2012-01-07T00Z/2012-01-08T00Z"), Intervals.of((String)"2012-01-03T00Z/2012-01-04T00Z"), Intervals.of((String)"2012-01-01T00Z/2012-01-03T00Z")}));
        try {
            GranularitySpec rtSpec = (GranularitySpec)JSON_MAPPER.readValue(JSON_MAPPER.writeValueAsString((Object)spec), GranularitySpec.class);
            Assert.assertEquals((String)"Round-trip sortedBucketIntervals", (Object)ImmutableList.copyOf((Iterable)spec.sortedBucketIntervals()), (Object)ImmutableList.copyOf(rtSpec.sortedBucketIntervals().iterator()));
            Assert.assertEquals((String)"Round-trip granularity", (Object)spec.getSegmentGranularity(), (Object)rtSpec.getSegmentGranularity());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Test
    public void testEquals() {
        UniformGranularitySpec spec = new UniformGranularitySpec(Granularities.DAY, null, (List)Lists.newArrayList((Object[])new Interval[]{Intervals.of((String)"2012-01-08T00Z/2012-01-11T00Z"), Intervals.of((String)"2012-01-07T00Z/2012-01-08T00Z"), Intervals.of((String)"2012-01-03T00Z/2012-01-04T00Z"), Intervals.of((String)"2012-01-01T00Z/2012-01-03T00Z")}));
        this.equalsCheck((GranularitySpec)spec, (GranularitySpec)new UniformGranularitySpec(Granularities.DAY, null, (List)Lists.newArrayList((Object[])new Interval[]{Intervals.of((String)"2012-01-08T00Z/2012-01-11T00Z"), Intervals.of((String)"2012-01-07T00Z/2012-01-08T00Z"), Intervals.of((String)"2012-01-03T00Z/2012-01-04T00Z"), Intervals.of((String)"2012-01-01T00Z/2012-01-03T00Z")})));
    }

    public void equalsCheck(GranularitySpec spec1, GranularitySpec spec2) {
        Assert.assertEquals((Object)spec1, (Object)spec2);
        Assert.assertEquals((long)spec1.hashCode(), (long)spec2.hashCode());
    }

    @Test
    public void testNotEquals() {
        UniformGranularitySpec spec = new UniformGranularitySpec(Granularities.DAY, null, (List)Lists.newArrayList((Object[])new Interval[]{Intervals.of((String)"2012-01-08T00Z/2012-01-11T00Z"), Intervals.of((String)"2012-01-07T00Z/2012-01-08T00Z"), Intervals.of((String)"2012-01-03T00Z/2012-01-04T00Z"), Intervals.of((String)"2012-01-01T00Z/2012-01-03T00Z")}));
        this.notEqualsCheck((GranularitySpec)spec, (GranularitySpec)new UniformGranularitySpec(Granularities.YEAR, null, (List)Lists.newArrayList((Object[])new Interval[]{Intervals.of((String)"2012-01-08T00Z/2012-01-11T00Z"), Intervals.of((String)"2012-01-07T00Z/2012-01-08T00Z"), Intervals.of((String)"2012-01-03T00Z/2012-01-04T00Z"), Intervals.of((String)"2012-01-01T00Z/2012-01-03T00Z")})));
        this.notEqualsCheck((GranularitySpec)spec, (GranularitySpec)new UniformGranularitySpec(Granularities.DAY, null, (List)Lists.newArrayList((Object[])new Interval[]{Intervals.of((String)"2012-01-08T00Z/2012-01-12T00Z"), Intervals.of((String)"2012-01-07T00Z/2012-01-08T00Z"), Intervals.of((String)"2012-01-03T00Z/2012-01-04T00Z"), Intervals.of((String)"2012-01-01T00Z/2012-01-03T00Z")})));
        this.notEqualsCheck((GranularitySpec)spec, (GranularitySpec)new UniformGranularitySpec(Granularities.DAY, Granularities.ALL, (List)Lists.newArrayList((Object[])new Interval[]{Intervals.of((String)"2012-01-08T00Z/2012-01-11T00Z"), Intervals.of((String)"2012-01-07T00Z/2012-01-08T00Z"), Intervals.of((String)"2012-01-03T00Z/2012-01-04T00Z"), Intervals.of((String)"2012-01-01T00Z/2012-01-03T00Z")})));
    }

    @Test
    public void testPeriodSegmentGranularity() {
        UniformGranularitySpec spec = new UniformGranularitySpec((Granularity)new PeriodGranularity(new Period((Object)"P1D"), null, DateTimes.inferTzFromString((String)"America/Los_Angeles")), null, (List)Lists.newArrayList((Object[])new Interval[]{Intervals.of((String)"2012-01-08T00-08:00/2012-01-11T00-08:00"), Intervals.of((String)"2012-01-07T00-08:00/2012-01-08T00-08:00"), Intervals.of((String)"2012-01-03T00-08:00/2012-01-04T00-08:00"), Intervals.of((String)"2012-01-01T00-08:00/2012-01-03T00-08:00"), Intervals.of((String)"2012-09-01T00-07:00/2012-09-03T00-07:00")}));
        Assert.assertTrue((boolean)spec.sortedBucketIntervals().iterator().hasNext());
        Iterable intervals = spec.sortedBucketIntervals();
        ArrayList<Long> actualIntervals = new ArrayList<Long>();
        for (Interval interval : intervals) {
            actualIntervals.add(interval.toDurationMillis());
        }
        ISOChronology chrono = ISOChronology.getInstance((DateTimeZone)DateTimes.inferTzFromString((String)"America/Los_Angeles"));
        ArrayList expectedIntervals = Lists.newArrayList((Object[])new Long[]{new Interval((Object)"2012-01-01/2012-01-02", (Chronology)chrono).toDurationMillis(), new Interval((Object)"2012-01-02/2012-01-03", (Chronology)chrono).toDurationMillis(), new Interval((Object)"2012-01-03/2012-01-04", (Chronology)chrono).toDurationMillis(), new Interval((Object)"2012-01-07/2012-01-08", (Chronology)chrono).toDurationMillis(), new Interval((Object)"2012-01-08/2012-01-09", (Chronology)chrono).toDurationMillis(), new Interval((Object)"2012-01-09/2012-01-10", (Chronology)chrono).toDurationMillis(), new Interval((Object)"2012-01-10/2012-01-11", (Chronology)chrono).toDurationMillis(), new Interval((Object)"2012-09-01/2012-09-02", (Chronology)chrono).toDurationMillis(), new Interval((Object)"2012-09-02/2012-09-03", (Chronology)chrono).toDurationMillis()});
        Assert.assertEquals((Object)expectedIntervals, actualIntervals);
    }

    @Test
    public void testUniformGranularitySpecWithLargeNumberOfIntervalsDoesNotBlowUp() {
        UniformGranularitySpec spec = new UniformGranularitySpec((Granularity)new DurationGranularity(1000L, 0L), null, Collections.singletonList(Intervals.of((String)"2012-01-01T00Z/P10Y")));
        Assert.assertTrue((spec != null ? 1 : 0) != 0);
        int count = Iterators.size(spec.sortedBucketIntervals().iterator());
        Assert.assertEquals((long)315619200L, (long)count);
    }

    private void notEqualsCheck(GranularitySpec spec1, GranularitySpec spec2) {
        Assert.assertNotEquals((Object)spec1, (Object)spec2);
        Assert.assertNotEquals((long)spec1.hashCode(), (long)spec2.hashCode());
    }
}

