/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.frame.processor;

import java.io.IOException;
import org.apache.druid.frame.allocation.HeapMemoryAllocator;
import org.apache.druid.frame.allocation.MemoryAllocator;
import org.apache.druid.frame.channel.BlockingQueueFrameChannel;
import org.apache.druid.frame.channel.ReadableFrameChannel;
import org.apache.druid.frame.channel.WritableFrameChannel;
import org.apache.druid.frame.channel.WritableFrameFileChannel;
import org.apache.druid.frame.processor.OutputChannel;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Assert;
import org.junit.Test;
import org.junit.internal.matchers.ThrowableMessageMatcher;

public class OutputChannelTest {
    @Test
    public void test_nil() {
        OutputChannel channel = OutputChannel.nil((int)1);
        Assert.assertEquals((long)1L, (long)channel.getPartitionNumber());
        Assert.assertTrue((boolean)channel.getReadableChannel().isFinished());
        IllegalStateException e1 = (IllegalStateException)Assert.assertThrows(IllegalStateException.class, () -> ((OutputChannel)channel).getWritableChannel());
        MatcherAssert.assertThat((Object)e1, (Matcher)ThrowableMessageMatcher.hasMessage((Matcher)CoreMatchers.equalTo((Object)"Writable channel is not available. The output channel might be marked as read-only, hence no writes are allowed.")));
        IllegalStateException e2 = (IllegalStateException)Assert.assertThrows(IllegalStateException.class, () -> ((OutputChannel)channel).getFrameMemoryAllocator());
        MatcherAssert.assertThat((Object)e2, (Matcher)ThrowableMessageMatcher.hasMessage((Matcher)CoreMatchers.equalTo((Object)"Frame allocator is not available. The output channel might be marked as read-only, hence memory allocator is not required.")));
        Assert.assertSame((Object)channel, (Object)channel.mapWritableChannel(c -> BlockingQueueFrameChannel.minimal().writable()));
    }

    @Test
    public void test_pair() throws IOException {
        BlockingQueueFrameChannel theChannel = BlockingQueueFrameChannel.minimal();
        HeapMemoryAllocator allocator = HeapMemoryAllocator.unlimited();
        OutputChannel channel = OutputChannel.pair((WritableFrameChannel)theChannel.writable(), (MemoryAllocator)allocator, () -> ((BlockingQueueFrameChannel)theChannel).readable(), (int)1);
        Assert.assertEquals((long)1L, (long)channel.getPartitionNumber());
        IllegalStateException e1 = (IllegalStateException)Assert.assertThrows(IllegalStateException.class, () -> ((OutputChannel)channel).getReadableChannel());
        Assert.assertEquals((Object)"Readable channel is not ready", (Object)e1.getMessage());
        Assert.assertSame((Object)theChannel.writable(), (Object)channel.getWritableChannel());
        Assert.assertSame((Object)allocator, (Object)channel.getFrameMemoryAllocator());
        Assert.assertFalse((boolean)channel.isReadableChannelReady());
        theChannel.writable().close();
        Assert.assertTrue((boolean)channel.isReadableChannelReady());
        Assert.assertEquals((long)1L, (long)channel.getPartitionNumber());
        Assert.assertSame((Object)theChannel.readable(), (Object)channel.getReadableChannel());
        Assert.assertSame((Object)theChannel.writable(), (Object)channel.getWritableChannel());
        Assert.assertSame((Object)allocator, (Object)channel.getFrameMemoryAllocator());
        Assert.assertTrue((boolean)channel.isReadableChannelReady());
        WritableFrameFileChannel otherWritableChannel = new WritableFrameFileChannel(null);
        OutputChannel mappedChannel = channel.mapWritableChannel(c -> otherWritableChannel);
        Assert.assertEquals((long)1L, (long)mappedChannel.getPartitionNumber());
        IllegalStateException e2 = (IllegalStateException)Assert.assertThrows(IllegalStateException.class, () -> ((OutputChannel)mappedChannel).getReadableChannel());
        Assert.assertEquals((Object)"Readable channel is not ready", (Object)e2.getMessage());
        Assert.assertSame((Object)otherWritableChannel, (Object)mappedChannel.getWritableChannel());
        Assert.assertSame((Object)allocator, (Object)mappedChannel.getFrameMemoryAllocator());
        Assert.assertFalse((boolean)mappedChannel.isReadableChannelReady());
    }

    @Test
    public void test_immediatelyReadablePair() {
        BlockingQueueFrameChannel theChannel = BlockingQueueFrameChannel.minimal();
        HeapMemoryAllocator allocator = HeapMemoryAllocator.unlimited();
        OutputChannel channel = OutputChannel.immediatelyReadablePair((WritableFrameChannel)theChannel.writable(), (MemoryAllocator)allocator, (ReadableFrameChannel)theChannel.readable(), (int)1);
        Assert.assertEquals((long)1L, (long)channel.getPartitionNumber());
        Assert.assertSame((Object)theChannel.readable(), (Object)channel.getReadableChannel());
        Assert.assertSame((Object)theChannel.writable(), (Object)channel.getWritableChannel());
        Assert.assertSame((Object)allocator, (Object)channel.getFrameMemoryAllocator());
        Assert.assertTrue((boolean)channel.isReadableChannelReady());
        WritableFrameFileChannel otherWritableChannel = new WritableFrameFileChannel(null);
        OutputChannel mappedChannel = channel.mapWritableChannel(c -> otherWritableChannel);
        Assert.assertEquals((long)1L, (long)mappedChannel.getPartitionNumber());
        Assert.assertSame((Object)theChannel.readable(), (Object)mappedChannel.getReadableChannel());
        Assert.assertSame((Object)otherWritableChannel, (Object)mappedChannel.getWritableChannel());
        Assert.assertSame((Object)allocator, (Object)mappedChannel.getFrameMemoryAllocator());
        Assert.assertTrue((boolean)channel.isReadableChannelReady());
    }
}

