/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.frame.key;

import com.google.common.collect.ImmutableList;
import java.util.Collections;
import java.util.List;
import nl.jqno.equalsverifier.EqualsVerifier;
import org.apache.druid.frame.key.ClusterBy;
import org.apache.druid.frame.key.KeyColumn;
import org.apache.druid.frame.key.KeyOrder;
import org.apache.druid.frame.key.RowKeyComparator;
import org.apache.druid.java.util.common.guava.Comparators;
import org.apache.druid.segment.column.ColumnType;
import org.apache.druid.segment.column.RowSignature;
import org.junit.Assert;
import org.junit.Test;

public class ClusterByTest {
    @Test
    public void test_keyComparator() {
        ImmutableList keyColumns = ImmutableList.of((Object)new KeyColumn("x", KeyOrder.ASCENDING), (Object)new KeyColumn("y", KeyOrder.ASCENDING));
        RowSignature rowSignature = RowSignature.builder().add("x", ColumnType.LONG).add("y", ColumnType.LONG).build();
        Assert.assertEquals((Object)RowKeyComparator.create((List)keyColumns, (RowSignature)rowSignature), (Object)new ClusterBy((List)keyColumns, 1).keyComparator(rowSignature));
    }

    @Test
    public void test_bucketComparator_noKey() {
        Assert.assertSame((Object)Comparators.alwaysEqual(), (Object)ClusterBy.none().bucketComparator(RowSignature.empty()));
    }

    @Test
    public void test_bucketComparator_noBucketKey() {
        RowSignature rowSignature = RowSignature.builder().add("x", ColumnType.LONG).add("y", ColumnType.LONG).build();
        Assert.assertSame((Object)Comparators.alwaysEqual(), (Object)new ClusterBy((List)ImmutableList.of((Object)new KeyColumn("x", KeyOrder.ASCENDING), (Object)new KeyColumn("y", KeyOrder.ASCENDING)), 0).bucketComparator(rowSignature));
    }

    @Test
    public void test_bucketComparator_withBucketKey() {
        RowSignature rowSignature = RowSignature.builder().add("x", ColumnType.LONG).add("y", ColumnType.LONG).build();
        Assert.assertEquals((Object)RowKeyComparator.create((List)ImmutableList.of((Object)new KeyColumn("x", KeyOrder.ASCENDING)), (RowSignature)rowSignature), (Object)new ClusterBy((List)ImmutableList.of((Object)new KeyColumn("x", KeyOrder.ASCENDING), (Object)new KeyColumn("y", KeyOrder.ASCENDING)), 1).bucketComparator(rowSignature));
    }

    @Test
    public void test_sortable() {
        Assert.assertFalse((boolean)new ClusterBy((List)ImmutableList.of((Object)new KeyColumn("x", KeyOrder.NONE), (Object)new KeyColumn("y", KeyOrder.NONE)), 0).sortable());
        Assert.assertTrue((boolean)new ClusterBy((List)ImmutableList.of((Object)new KeyColumn("x", KeyOrder.ASCENDING), (Object)new KeyColumn("y", KeyOrder.ASCENDING)), 0).sortable());
        Assert.assertTrue((boolean)new ClusterBy(Collections.emptyList(), 0).sortable());
    }

    @Test
    public void test_equals() {
        EqualsVerifier.forClass(ClusterBy.class).usingGetClass().withIgnoredFields(new String[]{"sortable"}).verify();
    }
}

